/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.SparseArray;
import com.android.internal.util.MessageUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.BitSet;

public final class ApfProgramEvent
implements Parcelable {
    public static final int FLAG_MULTICAST_FILTER_ON = 0;
    public static final int FLAG_HAS_IPV4_ADDRESS = 1;
    public long lifetime;
    public long actualLifetime;
    public int filteredRas;
    public int currentRas;
    public int programLength;
    public int flags;
    public static final Parcelable.Creator<ApfProgramEvent> CREATOR = new Parcelable.Creator<ApfProgramEvent>(){

        @Override
        public ApfProgramEvent createFromParcel(Parcel in) {
            return new ApfProgramEvent(in);
        }

        public ApfProgramEvent[] newArray(int size) {
            return new ApfProgramEvent[size];
        }
    };

    public ApfProgramEvent() {
    }

    private ApfProgramEvent(Parcel in) {
        this.lifetime = in.readLong();
        this.actualLifetime = in.readLong();
        this.filteredRas = in.readInt();
        this.currentRas = in.readInt();
        this.programLength = in.readInt();
        this.flags = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.lifetime);
        out.writeLong(this.actualLifetime);
        out.writeInt(this.filteredRas);
        out.writeInt(this.currentRas);
        out.writeInt(this.programLength);
        out.writeInt(flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        String lifetimeString = this.lifetime < Long.MAX_VALUE ? this.lifetime + "s" : "forever";
        return String.format("ApfProgramEvent(%d/%d RAs %dB %ds/%s %s)", this.filteredRas, this.currentRas, this.programLength, this.actualLifetime, lifetimeString, ApfProgramEvent.namesOf(this.flags));
    }

    public static int flagsFor(boolean hasIPv4, boolean multicastFilterOn) {
        int bitfield = 0;
        if (hasIPv4) {
            bitfield |= 2;
        }
        if (multicastFilterOn) {
            bitfield |= 1;
        }
        return bitfield;
    }

    private static String namesOf(int bitfield) {
        ArrayList<String> names = new ArrayList<String>(Integer.bitCount(bitfield));
        BitSet set = BitSet.valueOf(new long[]{bitfield & Integer.MAX_VALUE});
        int bit = set.nextSetBit(0);
        while (bit >= 0) {
            names.add(Decoder.constants.get(bit));
            bit = set.nextSetBit(bit + 1);
        }
        return TextUtils.join((CharSequence)"|", names);
    }

    static final class Decoder {
        static final SparseArray<String> constants = MessageUtils.findMessageNames(new Class[]{ApfProgramEvent.class}, new String[]{"FLAG_"});

        Decoder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

