/*
 * Decompiled with CFR 0.152.
 */
package android.net.metrics;

import android.net.metrics.WakeupEvent;
import android.os.SystemClock;

public class WakeupStats {
    private static final int NO_UID = -1;
    public final long creationTimeMs = SystemClock.elapsedRealtime();
    public final String iface;
    public long totalWakeups = 0L;
    public long rootWakeups = 0L;
    public long systemWakeups = 0L;
    public long nonApplicationWakeups = 0L;
    public long applicationWakeups = 0L;
    public long noUidWakeups = 0L;
    public long durationSec = 0L;

    public WakeupStats(String iface) {
        this.iface = iface;
    }

    public void updateDuration() {
        this.durationSec = (SystemClock.elapsedRealtime() - this.creationTimeMs) / 1000L;
    }

    public void countEvent(WakeupEvent ev) {
        ++this.totalWakeups;
        switch (ev.uid) {
            case 0: {
                ++this.rootWakeups;
                break;
            }
            case 1000: {
                ++this.systemWakeups;
                break;
            }
            case -1: {
                ++this.noUidWakeups;
                break;
            }
            default: {
                if (ev.uid >= 10000) {
                    ++this.applicationWakeups;
                    break;
                }
                ++this.nonApplicationWakeups;
            }
        }
    }

    public String toString() {
        this.updateDuration();
        return "WakeupStats(" + this.iface + ", total: " + this.totalWakeups + ", root: " + this.rootWakeups + ", system: " + this.systemWakeups + ", apps: " + this.applicationWakeups + ", non-apps: " + this.nonApplicationWakeups + ", no uid: " + this.noUidWakeups + ", " + this.durationSec + "s)";
    }
}

