/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.net.netlink.NetlinkConstants;
import android.system.OsConstants;
import java.nio.ByteBuffer;

public class StructNdMsg {
    public static final int STRUCT_SIZE = 12;
    public static final short NUD_NONE = 0;
    public static final short NUD_INCOMPLETE = 1;
    public static final short NUD_REACHABLE = 2;
    public static final short NUD_STALE = 4;
    public static final short NUD_DELAY = 8;
    public static final short NUD_PROBE = 16;
    public static final short NUD_FAILED = 32;
    public static final short NUD_NOARP = 64;
    public static final short NUD_PERMANENT = 128;
    public static byte NTF_USE = 1;
    public static byte NTF_SELF = (byte)2;
    public static byte NTF_MASTER = (byte)4;
    public static byte NTF_PROXY = (byte)8;
    public static byte NTF_ROUTER = (byte)-128;
    public byte ndm_family = (byte)OsConstants.AF_UNSPEC;
    public int ndm_ifindex;
    public short ndm_state;
    public byte ndm_flags;
    public byte ndm_type;

    public static String stringForNudState(short nudState) {
        switch (nudState) {
            case 0: {
                return "NUD_NONE";
            }
            case 1: {
                return "NUD_INCOMPLETE";
            }
            case 2: {
                return "NUD_REACHABLE";
            }
            case 4: {
                return "NUD_STALE";
            }
            case 8: {
                return "NUD_DELAY";
            }
            case 16: {
                return "NUD_PROBE";
            }
            case 32: {
                return "NUD_FAILED";
            }
            case 64: {
                return "NUD_NOARP";
            }
            case 128: {
                return "NUD_PERMANENT";
            }
        }
        return "unknown NUD state: " + String.valueOf(nudState);
    }

    public static boolean isNudStateConnected(short nudState) {
        return (nudState & 0xC2) != 0;
    }

    public static String stringForNudFlags(byte flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & NTF_USE) != 0) {
            sb.append("NTF_USE");
        }
        if ((flags & NTF_SELF) != 0) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("NTF_SELF");
        }
        if ((flags & NTF_MASTER) != 0) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("NTF_MASTER");
        }
        if ((flags & NTF_PROXY) != 0) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("NTF_PROXY");
        }
        if ((flags & NTF_ROUTER) != 0) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append("NTF_ROUTER");
        }
        return sb.toString();
    }

    private static boolean hasAvailableSpace(ByteBuffer byteBuffer) {
        return byteBuffer != null && byteBuffer.remaining() >= 12;
    }

    public static StructNdMsg parse(ByteBuffer byteBuffer) {
        if (!StructNdMsg.hasAvailableSpace(byteBuffer)) {
            return null;
        }
        StructNdMsg struct = new StructNdMsg();
        struct.ndm_family = byteBuffer.get();
        byte pad1 = byteBuffer.get();
        short pad2 = byteBuffer.getShort();
        struct.ndm_ifindex = byteBuffer.getInt();
        struct.ndm_state = byteBuffer.getShort();
        struct.ndm_flags = byteBuffer.get();
        struct.ndm_type = byteBuffer.get();
        return struct;
    }

    public void pack(ByteBuffer byteBuffer) {
        byteBuffer.put(this.ndm_family);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putInt(this.ndm_ifindex);
        byteBuffer.putShort(this.ndm_state);
        byteBuffer.put(this.ndm_flags);
        byteBuffer.put(this.ndm_type);
    }

    public boolean nudConnected() {
        return StructNdMsg.isNudStateConnected(this.ndm_state);
    }

    public boolean nudValid() {
        return this.nudConnected() || (this.ndm_state & 0x1C) != 0;
    }

    public String toString() {
        String stateStr = "" + this.ndm_state + " (" + StructNdMsg.stringForNudState(this.ndm_state) + ")";
        String flagsStr = "" + this.ndm_flags + " (" + StructNdMsg.stringForNudFlags(this.ndm_flags) + ")";
        return "StructNdMsg{ family{" + NetlinkConstants.stringForAddressFamily(this.ndm_family) + "}, ifindex{" + this.ndm_ifindex + "}, state{" + stateStr + "}, flags{" + flagsStr + "}, type{" + this.ndm_type + "} }";
    }
}

