/*
 * Decompiled with CFR 0.152.
 */
package android.net.netlink;

import android.system.Os;
import android.system.OsConstants;
import java.nio.ByteBuffer;

public class StructNdaCacheInfo {
    public static final int STRUCT_SIZE = 16;
    private static final long CLOCK_TICKS_PER_SECOND = Os.sysconf(OsConstants._SC_CLK_TCK);
    public int ndm_used;
    public int ndm_confirmed;
    public int ndm_updated;
    public int ndm_refcnt;

    private static boolean hasAvailableSpace(ByteBuffer byteBuffer) {
        return byteBuffer != null && byteBuffer.remaining() >= 16;
    }

    public static StructNdaCacheInfo parse(ByteBuffer byteBuffer) {
        if (!StructNdaCacheInfo.hasAvailableSpace(byteBuffer)) {
            return null;
        }
        StructNdaCacheInfo struct = new StructNdaCacheInfo();
        struct.ndm_used = byteBuffer.getInt();
        struct.ndm_confirmed = byteBuffer.getInt();
        struct.ndm_updated = byteBuffer.getInt();
        struct.ndm_refcnt = byteBuffer.getInt();
        return struct;
    }

    private static long ticksToMilliSeconds(int intClockTicks) {
        long longClockTicks = (long)intClockTicks & 0xFFFFFFFFFFFFFFFFL;
        return longClockTicks * 1000L / CLOCK_TICKS_PER_SECOND;
    }

    public long lastUsed() {
        return StructNdaCacheInfo.ticksToMilliSeconds(this.ndm_used);
    }

    public long lastConfirmed() {
        return StructNdaCacheInfo.ticksToMilliSeconds(this.ndm_confirmed);
    }

    public long lastUpdated() {
        return StructNdaCacheInfo.ticksToMilliSeconds(this.ndm_updated);
    }

    public String toString() {
        return "NdaCacheInfo{ ndm_used{" + this.lastUsed() + "}, ndm_confirmed{" + this.lastConfirmed() + "}, ndm_updated{" + this.lastUpdated() + "}, ndm_refcnt{" + this.ndm_refcnt + "} }";
    }
}

