/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import java.io.FileDescriptor;
import java.io.IOException;
import libcore.io.IoBridge;

public abstract class BlockingSocketReader {
    public static final int DEFAULT_RECV_BUF_SIZE = 2048;
    private final byte[] mPacket;
    private final Thread mThread;
    private volatile FileDescriptor mSocket;
    private volatile boolean mRunning;
    private volatile long mPacketsReceived;

    public static final void closeSocket(FileDescriptor fd) {
        try {
            IoBridge.closeAndSignalBlockedThreads(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected BlockingSocketReader() {
        this(2048);
    }

    protected BlockingSocketReader(int recvbufsize) {
        if (recvbufsize < 2048) {
            recvbufsize = 2048;
        }
        this.mPacket = new byte[recvbufsize];
        this.mThread = new Thread(() -> this.mainLoop());
    }

    public final boolean start() {
        if (this.mSocket != null) {
            return false;
        }
        try {
            this.mSocket = this.createSocket();
        }
        catch (Exception e) {
            this.logError("Failed to create socket: ", e);
            return false;
        }
        if (this.mSocket == null) {
            return false;
        }
        this.mRunning = true;
        this.mThread.start();
        return true;
    }

    public final void stop() {
        this.mRunning = false;
        BlockingSocketReader.closeSocket(this.mSocket);
        this.mSocket = null;
    }

    public final boolean isRunning() {
        return this.mRunning;
    }

    public final long numPacketsReceived() {
        return this.mPacketsReceived;
    }

    protected abstract FileDescriptor createSocket();

    protected void handlePacket(byte[] recvbuf, int length) {
    }

    protected void logError(String msg, Exception e) {
    }

    protected void onExit() {
    }

    private final void mainLoop() {
        while (this.isRunning()) {
            int bytesRead;
            try {
                bytesRead = Os.read(this.mSocket, this.mPacket, 0, this.mPacket.length);
                if (bytesRead < 1) {
                    if (!this.isRunning()) break;
                    this.logError("Socket closed, exiting", null);
                    break;
                }
                ++this.mPacketsReceived;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EINTR) continue;
                if (!this.isRunning()) break;
                this.logError("read error: ", e);
                break;
            }
            catch (IOException ioe) {
                if (!this.isRunning()) continue;
                this.logError("read error: ", ioe);
                continue;
            }
            try {
                this.handlePacket(this.mPacket, bytesRead);
            }
            catch (Exception e) {
                this.logError("Unexpected exception: ", e);
                break;
            }
        }
        this.stop();
        this.onExit();
    }
}

