/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PrefixUtils {
    private static final IpPrefix[] MIN_NON_FORWARDABLE_PREFIXES = new IpPrefix[]{PrefixUtils.pfx("127.0.0.0/8"), PrefixUtils.pfx("169.254.0.0/16"), PrefixUtils.pfx("::/3"), PrefixUtils.pfx("fe80::/64"), PrefixUtils.pfx("fc00::/7"), PrefixUtils.pfx("ff02::/8")};
    public static final IpPrefix DEFAULT_WIFI_P2P_PREFIX = PrefixUtils.pfx("192.168.49.0/24");

    public static Set<IpPrefix> getNonForwardablePrefixes() {
        HashSet<IpPrefix> prefixes = new HashSet<IpPrefix>();
        PrefixUtils.addNonForwardablePrefixes(prefixes);
        return prefixes;
    }

    public static void addNonForwardablePrefixes(Set<IpPrefix> prefixes) {
        Collections.addAll(prefixes, MIN_NON_FORWARDABLE_PREFIXES);
    }

    public static Set<IpPrefix> localPrefixesFrom(LinkProperties lp) {
        HashSet<IpPrefix> localPrefixes = new HashSet<IpPrefix>();
        if (lp == null) {
            return localPrefixes;
        }
        for (LinkAddress addr : lp.getAllLinkAddresses()) {
            if (addr.getAddress().isLinkLocalAddress()) continue;
            localPrefixes.add(PrefixUtils.asIpPrefix(addr));
        }
        return localPrefixes;
    }

    public static IpPrefix asIpPrefix(LinkAddress addr) {
        return new IpPrefix(addr.getAddress(), addr.getPrefixLength());
    }

    public static IpPrefix ipAddressAsPrefix(InetAddress ip) {
        int bitLength = ip instanceof Inet4Address ? 32 : 128;
        return new IpPrefix(ip, bitLength);
    }

    private static IpPrefix pfx(String prefixStr) {
        return new IpPrefix(prefixStr);
    }
}

