/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.hotspot2.omadm;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class XMLNode {
    private final String mTag;
    private final List<XMLNode> mChildren;
    private final XMLNode mParent;
    private StringBuilder mTextBuilder;
    private String mText;

    public XMLNode(XMLNode parent, String tag) {
        this.mTag = tag;
        this.mParent = parent;
        this.mChildren = new ArrayList<XMLNode>();
        this.mTextBuilder = new StringBuilder();
        this.mText = null;
    }

    public void addText(String text) {
        this.mTextBuilder.append(text);
    }

    public void addChild(XMLNode child) {
        this.mChildren.add(child);
    }

    public void close() {
        this.mText = this.mTextBuilder.toString().trim();
        this.mTextBuilder = null;
    }

    public String getTag() {
        return this.mTag;
    }

    public XMLNode getParent() {
        return this.mParent;
    }

    public String getText() {
        return this.mText;
    }

    public List<XMLNode> getChildren() {
        return this.mChildren;
    }

    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof XMLNode)) {
            return false;
        }
        XMLNode that = (XMLNode)thatObject;
        return TextUtils.equals(this.mTag, that.mTag) && TextUtils.equals(this.mText, that.mText) && this.mChildren.equals(that.mChildren);
    }

    public int hashCode() {
        return Objects.hash(this.mTag, this.mText, this.mChildren);
    }
}

