/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Slog;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;

public class SELinux {
    private static final String TAG = "SELinux";
    private static final int SELINUX_ANDROID_RESTORECON_NOCHANGE = 1;
    private static final int SELINUX_ANDROID_RESTORECON_VERBOSE = 2;
    private static final int SELINUX_ANDROID_RESTORECON_RECURSE = 4;
    private static final int SELINUX_ANDROID_RESTORECON_FORCE = 8;
    private static final int SELINUX_ANDROID_RESTORECON_DATADATA = 16;

    public static final native boolean isSELinuxEnabled();

    public static final native boolean isSELinuxEnforced();

    public static final native boolean setFSCreateContext(String var0);

    public static final native boolean setFileContext(String var0, String var1);

    public static final native String getFileContext(String var0);

    public static final native String getPeerContext(FileDescriptor var0);

    public static final native String getContext();

    public static final native String getPidContext(int var0);

    public static final native boolean checkSELinuxAccess(String var0, String var1, String var2, String var3);

    public static boolean restorecon(String pathname) throws NullPointerException {
        if (pathname == null) {
            throw new NullPointerException();
        }
        return SELinux.native_restorecon(pathname, 0);
    }

    private static native boolean native_restorecon(String var0, int var1);

    public static boolean restorecon(File file) throws NullPointerException {
        try {
            return SELinux.native_restorecon(file.getCanonicalPath(), 0);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), e);
            return false;
        }
    }

    public static boolean restoreconRecursive(File file) {
        try {
            return SELinux.native_restorecon(file.getCanonicalPath(), 4);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error getting canonical path. Restorecon failed for " + file.getPath(), e);
            return false;
        }
    }
}

