/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;
import dalvik.annotation.optimization.CriticalNative;

public final class SystemClock {
    private static final String TAG = "SystemClock";

    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IBinder b = ServiceManager.getService("alarm");
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(b);
        if (mgr == null) {
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    @CriticalNative
    public static native long uptimeMillis();

    @CriticalNative
    public static native long elapsedRealtime();

    @CriticalNative
    public static native long elapsedRealtimeNanos();

    @CriticalNative
    public static native long currentThreadTimeMillis();

    @CriticalNative
    public static native long currentThreadTimeMicro();

    @CriticalNative
    public static native long currentTimeMicro();
}

