/*
 * Decompiled with CFR 0.152.
 */
package android.permissionpresenterservice;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.permission.IRuntimePermissionPresenter;
import android.content.pm.permission.RuntimePermissionPresentationInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallback;
import com.android.internal.os.SomeArgs;
import java.util.List;

public abstract class RuntimePermissionPresenterService
extends Service {
    public static final String SERVICE_INTERFACE = "android.permissionpresenterservice.RuntimePermissionPresenterService";
    private Handler mHandler;

    @Override
    public final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(base.getMainLooper());
    }

    public abstract List<RuntimePermissionPresentationInfo> onGetAppPermissions(String var1);

    public abstract void onRevokeRuntimePermission(String var1, String var2);

    @Override
    public final IBinder onBind(Intent intent) {
        return new IRuntimePermissionPresenter.Stub(){

            @Override
            public void getAppPermissions(String packageName, RemoteCallback callback) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = packageName;
                args.arg2 = callback;
                RuntimePermissionPresenterService.this.mHandler.obtainMessage(1, args).sendToTarget();
            }

            @Override
            public void revokeRuntimePermission(String packageName, String permissionName) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = packageName;
                args.arg2 = permissionName;
                RuntimePermissionPresenterService.this.mHandler.obtainMessage(3, args).sendToTarget();
            }
        };
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_GET_APP_PERMISSIONS = 1;
        public static final int MSG_GET_APPS_USING_PERMISSIONS = 2;
        public static final int MSG_REVOKE_APP_PERMISSION = 3;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String packageName = (String)args.arg1;
                    RemoteCallback callback = (RemoteCallback)args.arg2;
                    args.recycle();
                    List<RuntimePermissionPresentationInfo> permissions = RuntimePermissionPresenterService.this.onGetAppPermissions(packageName);
                    if (permissions != null && !permissions.isEmpty()) {
                        Bundle result = new Bundle();
                        result.putParcelableList("android.content.pm.permission.RuntimePermissionPresenter.key.result", permissions);
                        callback.sendResult(result);
                        break;
                    }
                    callback.sendResult(null);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String packageName = (String)args.arg1;
                    String permissionName = (String)args.arg2;
                    args.recycle();
                    RuntimePermissionPresenterService.this.onRevokeRuntimePermission(packageName, permissionName);
                }
            }
        }
    }
}

