/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.OperationResult;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.ProviderException;
import libcore.util.EmptyArray;

class KeyStoreCryptoOperationChunkedStreamer
implements KeyStoreCryptoOperationStreamer {
    private static final int DEFAULT_MAX_CHUNK_SIZE = 65536;
    private final Stream mKeyStoreStream;
    private final int mMaxChunkSize;
    private byte[] mBuffered = EmptyArray.BYTE;
    private int mBufferedOffset;
    private int mBufferedLength;
    private long mConsumedInputSizeBytes;
    private long mProducedOutputSizeBytes;

    public KeyStoreCryptoOperationChunkedStreamer(Stream operation) {
        this(operation, 65536);
    }

    public KeyStoreCryptoOperationChunkedStreamer(Stream operation, int maxChunkSize) {
        this.mKeyStoreStream = operation;
        this.mMaxChunkSize = maxChunkSize;
    }

    @Override
    public byte[] update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
        if (inputLength == 0) {
            return EmptyArray.BYTE;
        }
        ByteArrayOutputStream bufferedOutput = null;
        while (inputLength > 0) {
            byte[] result;
            byte[] chunk;
            int inputBytesInChunk;
            if (this.mBufferedLength + inputLength > this.mMaxChunkSize) {
                inputBytesInChunk = this.mMaxChunkSize - this.mBufferedLength;
                chunk = ArrayUtils.concat(this.mBuffered, this.mBufferedOffset, this.mBufferedLength, input, inputOffset, inputBytesInChunk);
            } else if (this.mBufferedLength == 0 && inputOffset == 0 && inputLength == input.length) {
                chunk = input;
                inputBytesInChunk = input.length;
            } else {
                inputBytesInChunk = inputLength;
                chunk = ArrayUtils.concat(this.mBuffered, this.mBufferedOffset, this.mBufferedLength, input, inputOffset, inputBytesInChunk);
            }
            inputOffset += inputBytesInChunk;
            inputLength -= inputBytesInChunk;
            this.mConsumedInputSizeBytes += (long)inputBytesInChunk;
            OperationResult opResult = this.mKeyStoreStream.update(chunk);
            if (opResult == null) {
                throw new KeyStoreConnectException();
            }
            if (opResult.resultCode != 1) {
                throw KeyStore.getKeyStoreException(opResult.resultCode);
            }
            if (opResult.inputConsumed == chunk.length) {
                this.mBuffered = EmptyArray.BYTE;
                this.mBufferedOffset = 0;
                this.mBufferedLength = 0;
            } else if (opResult.inputConsumed <= 0) {
                if (inputLength > 0) {
                    throw new KeyStoreException(-1000, "Keystore consumed nothing from max-sized chunk: " + chunk.length + " bytes");
                }
                this.mBuffered = chunk;
                this.mBufferedOffset = 0;
                this.mBufferedLength = chunk.length;
            } else if (opResult.inputConsumed < chunk.length) {
                this.mBuffered = chunk;
                this.mBufferedOffset = opResult.inputConsumed;
                this.mBufferedLength = chunk.length - opResult.inputConsumed;
            } else {
                throw new KeyStoreException(-1000, "Keystore consumed more input than provided. Provided: " + chunk.length + ", consumed: " + opResult.inputConsumed);
            }
            if (opResult.output == null || opResult.output.length <= 0) continue;
            if (inputLength > 0) {
                if (bufferedOutput != null) continue;
                bufferedOutput = new ByteArrayOutputStream();
                try {
                    bufferedOutput.write(opResult.output);
                    continue;
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            if (bufferedOutput == null) {
                result = opResult.output;
            } else {
                try {
                    bufferedOutput.write(opResult.output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
                result = bufferedOutput.toByteArray();
            }
            this.mProducedOutputSizeBytes += (long)result.length;
            return result;
        }
        byte[] result = bufferedOutput == null ? EmptyArray.BYTE : bufferedOutput.toByteArray();
        this.mProducedOutputSizeBytes += (long)result.length;
        return result;
    }

    @Override
    public byte[] doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature, byte[] additionalEntropy) throws KeyStoreException {
        if (inputLength == 0) {
            input = EmptyArray.BYTE;
            inputOffset = 0;
        }
        byte[] output = this.update(input, inputOffset, inputLength);
        output = ArrayUtils.concat(output, this.flush());
        OperationResult opResult = this.mKeyStoreStream.finish(signature, additionalEntropy);
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        if (opResult.resultCode != 1) {
            throw KeyStore.getKeyStoreException(opResult.resultCode);
        }
        this.mProducedOutputSizeBytes += (long)opResult.output.length;
        return ArrayUtils.concat(output, opResult.output);
    }

    public byte[] flush() throws KeyStoreException {
        if (this.mBufferedLength <= 0) {
            return EmptyArray.BYTE;
        }
        ByteArrayOutputStream bufferedOutput = null;
        while (this.mBufferedLength > 0) {
            byte[] chunk = ArrayUtils.subarray(this.mBuffered, this.mBufferedOffset, this.mBufferedLength);
            OperationResult opResult = this.mKeyStoreStream.update(chunk);
            if (opResult == null) {
                throw new KeyStoreConnectException();
            }
            if (opResult.resultCode != 1) {
                throw KeyStore.getKeyStoreException(opResult.resultCode);
            }
            if (opResult.inputConsumed <= 0) break;
            if (opResult.inputConsumed >= chunk.length) {
                this.mBuffered = EmptyArray.BYTE;
                this.mBufferedOffset = 0;
                this.mBufferedLength = 0;
            } else {
                this.mBuffered = chunk;
                this.mBufferedOffset = opResult.inputConsumed;
                this.mBufferedLength = chunk.length - opResult.inputConsumed;
            }
            if (opResult.inputConsumed > chunk.length) {
                throw new KeyStoreException(-1000, "Keystore consumed more input than provided. Provided: " + chunk.length + ", consumed: " + opResult.inputConsumed);
            }
            if (opResult.output == null || opResult.output.length <= 0) continue;
            if (bufferedOutput == null) {
                if (this.mBufferedLength == 0) {
                    this.mProducedOutputSizeBytes += (long)opResult.output.length;
                    return opResult.output;
                }
                bufferedOutput = new ByteArrayOutputStream();
            }
            try {
                bufferedOutput.write(opResult.output);
            }
            catch (IOException e) {
                throw new ProviderException("Failed to buffer output", e);
            }
        }
        if (this.mBufferedLength > 0) {
            throw new KeyStoreException(-21, "Keystore failed to consume last " + (this.mBufferedLength != 1 ? this.mBufferedLength + " bytes" : "byte") + " of input");
        }
        byte[] result = bufferedOutput != null ? bufferedOutput.toByteArray() : EmptyArray.BYTE;
        this.mProducedOutputSizeBytes += (long)result.length;
        return result;
    }

    @Override
    public long getConsumedInputSizeBytes() {
        return this.mConsumedInputSizeBytes;
    }

    @Override
    public long getProducedOutputSizeBytes() {
        return this.mProducedOutputSizeBytes;
    }

    public static class MainDataStream
    implements Stream {
        private final KeyStore mKeyStore;
        private final IBinder mOperationToken;

        public MainDataStream(KeyStore keyStore, IBinder operationToken) {
            this.mKeyStore = keyStore;
            this.mOperationToken = operationToken;
        }

        @Override
        public OperationResult update(byte[] input) {
            return this.mKeyStore.update(this.mOperationToken, null, input);
        }

        @Override
        public OperationResult finish(byte[] signature, byte[] additionalEntropy) {
            return this.mKeyStore.finish(this.mOperationToken, null, signature, additionalEntropy);
        }
    }

    static interface Stream {
        public OperationResult update(byte[] var1);

        public OperationResult finish(byte[] var1, byte[] var2);
    }
}

