/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CharSequenceTransformation
extends InternalTransformation
implements Transformation,
Parcelable {
    private static final String TAG = "CharSequenceTransformation";
    private final ArrayMap<AutofillId, Pair<Pattern, String>> mFields;
    public static final Parcelable.Creator<CharSequenceTransformation> CREATOR = new Parcelable.Creator<CharSequenceTransformation>(){

        @Override
        public CharSequenceTransformation createFromParcel(Parcel parcel) {
            AutofillId[] ids = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class);
            Pattern[] regexs = (Pattern[])parcel.readSerializable();
            String[] substs = parcel.createStringArray();
            Builder builder = new Builder(ids[0], regexs[0], substs[0]);
            int size = ids.length;
            for (int i = 1; i < size; ++i) {
                builder.addField(ids[i], regexs[i], substs[i]);
            }
            return builder.build();
        }

        public CharSequenceTransformation[] newArray(int size) {
            return new CharSequenceTransformation[size];
        }
    };

    private CharSequenceTransformation(Builder builder) {
        this.mFields = builder.mFields;
    }

    @Override
    public void apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        StringBuilder converted = new StringBuilder();
        int size = this.mFields.size();
        if (Helper.sDebug) {
            Log.d(TAG, size + " multiple fields on id " + childViewId);
        }
        for (int i = 0; i < size; ++i) {
            AutofillId id2 = this.mFields.keyAt(i);
            Pair<Pattern, String> field = this.mFields.valueAt(i);
            String value = finder.findByAutofillId(id2);
            if (value == null) {
                Log.w(TAG, "No value for id " + id2);
                return;
            }
            try {
                Matcher matcher = ((Pattern)field.first).matcher(value);
                if (!matcher.find()) {
                    if (Helper.sDebug) {
                        Log.d(TAG, "match for " + field.first + " failed on id " + id2);
                    }
                    return;
                }
                String convertedValue = matcher.replaceAll((String)field.second);
                converted.append(convertedValue);
                continue;
            }
            catch (Exception e) {
                Log.w(TAG, "Cannot apply " + ((Pattern)field.first).pattern() + "->" + (String)field.second + " to field with autofill id" + id2 + ": " + e.getClass());
                throw e;
            }
        }
        parentTemplate.setCharSequence(childViewId, "setText", converted);
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "MultipleViewsCharSequenceTransformation: [fields=" + this.mFields + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        int size = this.mFields.size();
        Parcelable[] ids = new AutofillId[size];
        Pattern[] regexs = new Pattern[size];
        String[] substs = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = this.mFields.keyAt(i);
            Pair<Pattern, String> pair = this.mFields.valueAt(i);
            regexs[i] = (Pattern)pair.first;
            substs[i] = (String)pair.second;
        }
        parcel.writeParcelableArray(ids, flags);
        parcel.writeSerializable((Serializable)regexs);
        parcel.writeStringArray(substs);
    }

    public static class Builder {
        private final ArrayMap<AutofillId, Pair<Pattern, String>> mFields = new ArrayMap();
        private boolean mDestroyed;

        public Builder(AutofillId id2, Pattern regex, String subst) {
            this.addField(id2, regex, subst);
        }

        public Builder addField(AutofillId id2, Pattern regex, String subst) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(id2);
            Preconditions.checkNotNull(regex);
            Preconditions.checkNotNull(subst);
            this.mFields.put(id2, new Pair<Pattern, String>(regex, subst));
            return this;
        }

        public CharSequenceTransformation build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new CharSequenceTransformation(this);
        }

        private void throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called build()");
        }
    }
}

