/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public final class Dataset
implements Parcelable {
    private final ArrayList<AutofillId> mFieldIds;
    private final ArrayList<AutofillValue> mFieldValues;
    private final ArrayList<RemoteViews> mFieldPresentations;
    private final RemoteViews mPresentation;
    private final IntentSender mAuthentication;
    String mId;
    public static final Parcelable.Creator<Dataset> CREATOR = new Parcelable.Creator<Dataset>(){

        @Override
        public Dataset createFromParcel(Parcel parcel) {
            RemoteViews presentation = (RemoteViews)parcel.readParcelable(null);
            Builder builder = presentation == null ? new Builder() : new Builder(presentation);
            ArrayList ids = parcel.readTypedArrayList(null);
            ArrayList values = parcel.readTypedArrayList(null);
            ArrayList presentations = new ArrayList();
            parcel.readParcelableList(presentations, null);
            int idCount = ids != null ? ids.size() : 0;
            int valueCount = values != null ? values.size() : 0;
            for (int i = 0; i < idCount; ++i) {
                AutofillId id2 = (AutofillId)ids.get(i);
                AutofillValue value = valueCount > i ? (AutofillValue)values.get(i) : null;
                RemoteViews fieldPresentation = presentations.isEmpty() ? null : (RemoteViews)presentations.get(i);
                builder.setValueAndPresentation(id2, value, fieldPresentation);
            }
            builder.setAuthentication((IntentSender)parcel.readParcelable(null));
            builder.setId(parcel.readString());
            return builder.build();
        }

        public Dataset[] newArray(int size) {
            return new Dataset[size];
        }
    };

    private Dataset(Builder builder) {
        this.mFieldIds = builder.mFieldIds;
        this.mFieldValues = builder.mFieldValues;
        this.mFieldPresentations = builder.mFieldPresentations;
        this.mPresentation = builder.mPresentation;
        this.mAuthentication = builder.mAuthentication;
        this.mId = builder.mId;
    }

    public ArrayList<AutofillId> getFieldIds() {
        return this.mFieldIds;
    }

    public ArrayList<AutofillValue> getFieldValues() {
        return this.mFieldValues;
    }

    public RemoteViews getFieldPresentation(int index) {
        RemoteViews customPresentation = this.mFieldPresentations.get(index);
        return customPresentation != null ? customPresentation : this.mPresentation;
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public boolean isEmpty() {
        return this.mFieldIds == null || this.mFieldIds.isEmpty();
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "Dataset " + this.mId + " [" + "fieldIds=" + this.mFieldIds + ", fieldValues=" + this.mFieldValues + ", fieldPresentations=" + (this.mFieldPresentations == null ? 0 : this.mFieldPresentations.size()) + ", hasPresentation=" + (this.mPresentation != null) + ", hasAuthentication=" + (this.mAuthentication != null) + ']';
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mPresentation, flags);
        parcel.writeTypedArrayList(this.mFieldIds, flags);
        parcel.writeTypedArrayList(this.mFieldValues, flags);
        parcel.writeParcelableList(this.mFieldPresentations, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
        parcel.writeString(this.mId);
    }

    public static final class Builder {
        private ArrayList<AutofillId> mFieldIds;
        private ArrayList<AutofillValue> mFieldValues;
        private ArrayList<RemoteViews> mFieldPresentations;
        private RemoteViews mPresentation;
        private IntentSender mAuthentication;
        private boolean mDestroyed;
        private String mId;

        public Builder(RemoteViews presentation) {
            Preconditions.checkNotNull(presentation, "presentation must be non-null");
            this.mPresentation = presentation;
        }

        public Builder() {
        }

        public Builder setAuthentication(IntentSender authentication) {
            this.throwIfDestroyed();
            this.mAuthentication = authentication;
            return this;
        }

        public Builder setId(String id2) {
            this.throwIfDestroyed();
            this.mId = id2;
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value) {
            this.throwIfDestroyed();
            if (this.mPresentation == null) {
                throw new IllegalStateException("Dataset presentation not set on constructor");
            }
            this.setValueAndPresentation(id2, value, null);
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value, RemoteViews presentation) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(presentation, "presentation cannot be null");
            this.setValueAndPresentation(id2, value, presentation);
            return this;
        }

        private void setValueAndPresentation(AutofillId id2, AutofillValue value, RemoteViews presentation) {
            Preconditions.checkNotNull(id2, "id cannot be null");
            if (this.mFieldIds != null) {
                int existingIdx = this.mFieldIds.indexOf(id2);
                if (existingIdx >= 0) {
                    this.mFieldValues.set(existingIdx, value);
                    this.mFieldPresentations.set(existingIdx, presentation);
                    return;
                }
            } else {
                this.mFieldIds = new ArrayList();
                this.mFieldValues = new ArrayList();
                this.mFieldPresentations = new ArrayList();
            }
            this.mFieldIds.add(id2);
            this.mFieldValues.add(value);
            this.mFieldPresentations.add(presentation);
        }

        public Dataset build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            if (this.mFieldIds == null) {
                throw new IllegalArgumentException("at least one value must be set");
            }
            return new Dataset(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

