/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.Dataset;
import android.service.autofill.SaveInfo;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FillResponse
implements Parcelable {
    private final ParceledListSlice<Dataset> mDatasets;
    private final SaveInfo mSaveInfo;
    private final Bundle mClientState;
    private final RemoteViews mPresentation;
    private final IntentSender mAuthentication;
    private final AutofillId[] mAuthenticationIds;
    private final AutofillId[] mIgnoredIds;
    private int mRequestId;
    public static final Parcelable.Creator<FillResponse> CREATOR = new Parcelable.Creator<FillResponse>(){

        @Override
        public FillResponse createFromParcel(Parcel parcel) {
            Builder builder = new Builder();
            ParceledListSlice datasetSlice = (ParceledListSlice)parcel.readParcelable(null);
            List datasets = datasetSlice != null ? datasetSlice.getList() : null;
            int datasetCount = datasets != null ? datasets.size() : 0;
            for (int i = 0; i < datasetCount; ++i) {
                builder.addDataset((Dataset)datasets.get(i));
            }
            builder.setSaveInfo((SaveInfo)parcel.readParcelable(null));
            builder.setClientState((Bundle)parcel.readParcelable(null));
            AutofillId[] authenticationIds = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class);
            IntentSender authentication = (IntentSender)parcel.readParcelable(null);
            RemoteViews presentation = (RemoteViews)parcel.readParcelable(null);
            if (authenticationIds != null) {
                builder.setAuthentication(authenticationIds, authentication, presentation);
            }
            builder.setIgnoredIds((AutofillId[])parcel.readParcelableArray(null, AutofillId.class));
            FillResponse response = builder.build();
            response.setRequestId(parcel.readInt());
            return response;
        }

        public FillResponse[] newArray(int size) {
            return new FillResponse[size];
        }
    };

    private FillResponse(Builder builder) {
        this.mDatasets = builder.mDatasets != null ? new ParceledListSlice(builder.mDatasets) : null;
        this.mSaveInfo = builder.mSaveInfo;
        this.mClientState = builder.mCLientState;
        this.mPresentation = builder.mPresentation;
        this.mAuthentication = builder.mAuthentication;
        this.mAuthenticationIds = builder.mAuthenticationIds;
        this.mIgnoredIds = builder.mIgnoredIds;
        this.mRequestId = Integer.MIN_VALUE;
    }

    public Bundle getClientState() {
        return this.mClientState;
    }

    public List<Dataset> getDatasets() {
        return this.mDatasets != null ? this.mDatasets.getList() : null;
    }

    public SaveInfo getSaveInfo() {
        return this.mSaveInfo;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public AutofillId[] getAuthenticationIds() {
        return this.mAuthenticationIds;
    }

    public AutofillId[] getIgnoredIds() {
        return this.mIgnoredIds;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "FillResponse : [mRequestId=" + this.mRequestId + ", datasets=" + (this.mDatasets == null ? "N/A" : this.mDatasets.getList()) + ", saveInfo=" + this.mSaveInfo + ", clientState=" + (this.mClientState != null) + ", hasPresentation=" + (this.mPresentation != null) + ", hasAuthentication=" + (this.mAuthentication != null) + ", authenticationIds=" + Arrays.toString(this.mAuthenticationIds) + ", ignoredIds=" + Arrays.toString(this.mIgnoredIds) + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mDatasets, flags);
        parcel.writeParcelable(this.mSaveInfo, flags);
        parcel.writeParcelable(this.mClientState, flags);
        parcel.writeParcelableArray(this.mAuthenticationIds, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
        parcel.writeParcelable(this.mPresentation, flags);
        parcel.writeParcelableArray(this.mIgnoredIds, flags);
        parcel.writeInt(this.mRequestId);
    }

    public static final class Builder {
        private ArrayList<Dataset> mDatasets;
        private SaveInfo mSaveInfo;
        private Bundle mCLientState;
        private RemoteViews mPresentation;
        private IntentSender mAuthentication;
        private AutofillId[] mAuthenticationIds;
        private AutofillId[] mIgnoredIds;
        private boolean mDestroyed;

        public Builder setAuthentication(AutofillId[] ids, IntentSender authentication, RemoteViews presentation) {
            this.throwIfDestroyed();
            if (ids == null || ids.length == 0) {
                throw new IllegalArgumentException("ids cannot be null or empry");
            }
            if (authentication == null ^ presentation == null) {
                throw new IllegalArgumentException("authentication and presentation must be both non-null or null");
            }
            this.mAuthentication = authentication;
            this.mPresentation = presentation;
            this.mAuthenticationIds = ids;
            return this;
        }

        public Builder setIgnoredIds(AutofillId ... ids) {
            this.mIgnoredIds = ids;
            return this;
        }

        public Builder addDataset(Dataset dataset) {
            this.throwIfDestroyed();
            if (dataset == null) {
                return this;
            }
            if (this.mDatasets == null) {
                this.mDatasets = new ArrayList();
            }
            if (!this.mDatasets.add(dataset)) {
                return this;
            }
            return this;
        }

        public Builder setSaveInfo(SaveInfo saveInfo) {
            this.throwIfDestroyed();
            this.mSaveInfo = saveInfo;
            return this;
        }

        public Builder setClientState(Bundle clientState) {
            this.throwIfDestroyed();
            this.mCLientState = clientState;
            return this;
        }

        public FillResponse build() {
            this.throwIfDestroyed();
            if (this.mAuthentication == null && this.mDatasets == null && this.mSaveInfo == null) {
                throw new IllegalArgumentException("need to provide at least one DataSet or a SaveInfo or an authentication with a presentation");
            }
            this.mDestroyed = true;
            return new FillResponse(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

