/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.RemoteException;
import android.service.autofill.ISaveCallback;

public final class SaveCallback {
    private final ISaveCallback mCallback;
    private boolean mCalled;

    SaveCallback(ISaveCallback callback) {
        this.mCallback = callback;
    }

    public void onSuccess() {
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onSuccess();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void onFailure(CharSequence message) {
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onFailure(message);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void assertNotCalled() {
        if (this.mCalled) {
            throw new IllegalStateException("Already called");
        }
    }
}

