/*
 * Decompiled with CFR 0.152.
 */
package android.service.quicksettings;

import android.app.Dialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Icon;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.quicksettings.IQSService;
import android.service.quicksettings.IQSTileService;
import android.service.quicksettings.Tile;
import android.view.View;

public class TileService
extends Service {
    public static final String ACTION_QS_TILE_PREFERENCES = "android.service.quicksettings.action.QS_TILE_PREFERENCES";
    public static final String ACTION_QS_TILE = "android.service.quicksettings.action.QS_TILE";
    public static final String META_DATA_ACTIVE_TILE = "android.service.quicksettings.ACTIVE_TILE";
    public static final String ACTION_REQUEST_LISTENING = "android.service.quicksettings.action.REQUEST_LISTENING";
    public static final String EXTRA_SERVICE = "service";
    public static final String EXTRA_TOKEN = "token";
    public static final String EXTRA_STATE = "state";
    private final H mHandler = new H(Looper.getMainLooper());
    private boolean mListening = false;
    private Tile mTile;
    private IBinder mToken;
    private IQSService mService;
    private Runnable mUnlockRunnable;
    private IBinder mTileToken;

    @Override
    public void onDestroy() {
        if (this.mListening) {
            this.onStopListening();
            this.mListening = false;
        }
        super.onDestroy();
    }

    public void onTileAdded() {
    }

    public void onTileRemoved() {
    }

    public void onStartListening() {
    }

    public void onStopListening() {
    }

    public void onClick() {
    }

    public final void setStatusIcon(Icon icon, String contentDescription) {
        if (this.mService != null) {
            try {
                this.mService.updateStatusIcon(this.mTileToken, icon, contentDescription);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public final void showDialog(Dialog dialog) {
        dialog.getWindow().getAttributes().token = this.mToken;
        dialog.getWindow().setType(2035);
        dialog.getWindow().getDecorView().addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            @Override
            public void onViewAttachedToWindow(View v) {
            }

            @Override
            public void onViewDetachedFromWindow(View v) {
                try {
                    TileService.this.mService.onDialogHidden(TileService.this.mTileToken);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        dialog.show();
        try {
            this.mService.onShowDialog(this.mTileToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final void unlockAndRun(Runnable runnable) {
        this.mUnlockRunnable = runnable;
        try {
            this.mService.startUnlockAndRun(this.mTileToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final boolean isSecure() {
        try {
            return this.mService.isSecure();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    public final boolean isLocked() {
        try {
            return this.mService.isLocked();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    public final void startActivityAndCollapse(Intent intent) {
        this.startActivity(intent);
        try {
            this.mService.onStartActivity(this.mTileToken);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public final Tile getQsTile() {
        return this.mTile;
    }

    @Override
    public IBinder onBind(Intent intent) {
        this.mService = IQSService.Stub.asInterface(intent.getIBinderExtra(EXTRA_SERVICE));
        this.mTileToken = intent.getIBinderExtra(EXTRA_TOKEN);
        try {
            this.mTile = this.mService.getTile(this.mTileToken);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Unable to reach IQSService", e);
        }
        if (this.mTile != null) {
            this.mTile.setService(this.mService, this.mTileToken);
            this.mHandler.sendEmptyMessage(7);
        }
        return new IQSTileService.Stub(){

            @Override
            public void onTileRemoved() throws RemoteException {
                TileService.this.mHandler.sendEmptyMessage(4);
            }

            @Override
            public void onTileAdded() throws RemoteException {
                TileService.this.mHandler.sendEmptyMessage(3);
            }

            @Override
            public void onStopListening() throws RemoteException {
                TileService.this.mHandler.sendEmptyMessage(2);
            }

            @Override
            public void onStartListening() throws RemoteException {
                TileService.this.mHandler.sendEmptyMessage(1);
            }

            @Override
            public void onClick(IBinder wtoken) throws RemoteException {
                TileService.this.mHandler.obtainMessage(5, wtoken).sendToTarget();
            }

            @Override
            public void onUnlockComplete() throws RemoteException {
                TileService.this.mHandler.sendEmptyMessage(6);
            }
        };
    }

    public static boolean isQuickSettingsSupported() {
        return Resources.getSystem().getBoolean(17956995);
    }

    public static final void requestListeningState(Context context, ComponentName component) {
        Intent intent = new Intent(ACTION_REQUEST_LISTENING);
        intent.putExtra("android.intent.extra.COMPONENT_NAME", component);
        intent.setPackage("com.android.systemui");
        context.sendBroadcast(intent, "android.permission.BIND_QUICK_SETTINGS_TILE");
    }

    private class H
    extends Handler {
        private static final int MSG_START_LISTENING = 1;
        private static final int MSG_STOP_LISTENING = 2;
        private static final int MSG_TILE_ADDED = 3;
        private static final int MSG_TILE_REMOVED = 4;
        private static final int MSG_TILE_CLICKED = 5;
        private static final int MSG_UNLOCK_COMPLETE = 6;
        private static final int MSG_START_SUCCESS = 7;

        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    TileService.this.onTileAdded();
                    break;
                }
                case 4: {
                    if (TileService.this.mListening) {
                        TileService.this.mListening = false;
                        TileService.this.onStopListening();
                    }
                    TileService.this.onTileRemoved();
                    break;
                }
                case 2: {
                    if (!TileService.this.mListening) break;
                    TileService.this.mListening = false;
                    TileService.this.onStopListening();
                    break;
                }
                case 1: {
                    if (TileService.this.mListening) break;
                    TileService.this.mListening = true;
                    TileService.this.onStartListening();
                    break;
                }
                case 5: {
                    TileService.this.mToken = (IBinder)msg.obj;
                    TileService.this.onClick();
                    break;
                }
                case 6: {
                    if (TileService.this.mUnlockRunnable == null) break;
                    TileService.this.mUnlockRunnable.run();
                    break;
                }
                case 7: {
                    try {
                        TileService.this.mService.onStartSuccessful(TileService.this.mTileToken);
                        break;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

