/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.content.Intent;
import android.hardware.soundtrigger.IRecognitionStatusCallback;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.hardware.soundtrigger.KeyphraseMetadata;
import android.hardware.soundtrigger.SoundTrigger;
import android.media.AudioFormat;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.service.voice.IVoiceInteractionService;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractionManagerService;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;

public class AlwaysOnHotwordDetector {
    private static final int STATE_INVALID = -3;
    public static final int STATE_HARDWARE_UNAVAILABLE = -2;
    public static final int STATE_KEYPHRASE_UNSUPPORTED = -1;
    public static final int STATE_KEYPHRASE_UNENROLLED = 1;
    public static final int STATE_KEYPHRASE_ENROLLED = 2;
    private static final int STATE_NOT_READY = 0;
    public static final int MANAGE_ACTION_ENROLL = 0;
    public static final int MANAGE_ACTION_RE_ENROLL = 1;
    public static final int MANAGE_ACTION_UN_ENROLL = 2;
    public static final int RECOGNITION_FLAG_NONE = 0;
    public static final int RECOGNITION_FLAG_CAPTURE_TRIGGER_AUDIO = 1;
    public static final int RECOGNITION_FLAG_ALLOW_MULTIPLE_TRIGGERS = 2;
    public static final int RECOGNITION_MODE_VOICE_TRIGGER = 1;
    public static final int RECOGNITION_MODE_USER_IDENTIFICATION = 2;
    static final String TAG = "AlwaysOnHotwordDetector";
    static final boolean DBG = false;
    private static final int STATUS_ERROR = Integer.MIN_VALUE;
    private static final int STATUS_OK = 0;
    private static final int MSG_AVAILABILITY_CHANGED = 1;
    private static final int MSG_HOTWORD_DETECTED = 2;
    private static final int MSG_DETECTION_ERROR = 3;
    private static final int MSG_DETECTION_PAUSE = 4;
    private static final int MSG_DETECTION_RESUME = 5;
    private final String mText;
    private final Locale mLocale;
    private final KeyphraseMetadata mKeyphraseMetadata;
    private final KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private final IVoiceInteractionService mVoiceInteractionService;
    private final IVoiceInteractionManagerService mModelManagementService;
    private final SoundTriggerListener mInternalCallback;
    private final Callback mExternalCallback;
    private final Object mLock = new Object();
    private final Handler mHandler;
    private int mAvailability = 0;

    public AlwaysOnHotwordDetector(String text, Locale locale, Callback callback, KeyphraseEnrollmentInfo keyphraseEnrollmentInfo, IVoiceInteractionService voiceInteractionService, IVoiceInteractionManagerService modelManagementService) {
        this.mText = text;
        this.mLocale = locale;
        this.mKeyphraseEnrollmentInfo = keyphraseEnrollmentInfo;
        this.mKeyphraseMetadata = this.mKeyphraseEnrollmentInfo.getKeyphraseMetadata(text, locale);
        this.mExternalCallback = callback;
        this.mHandler = new MyHandler();
        this.mInternalCallback = new SoundTriggerListener(this.mHandler);
        this.mVoiceInteractionService = voiceInteractionService;
        this.mModelManagementService = modelManagementService;
        new RefreshAvailabiltyTask().execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSupportedRecognitionModes() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getSupportedRecognitionModesLocked();
        }
    }

    private int getSupportedRecognitionModesLocked() {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getSupportedRecognitionModes called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Getting supported recognition modes for the keyphrase is not supported");
        }
        return this.mKeyphraseMetadata.recognitionModeFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startRecognition(int recognitionFlags) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("startRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            return this.startRecognitionLocked(recognitionFlags) == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopRecognition() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3) {
                throw new IllegalStateException("stopRecognition called on an invalid detector");
            }
            if (this.mAvailability != 2) {
                throw new UnsupportedOperationException("Recognition for the given keyphrase is not supported");
            }
            return this.stopRecognitionLocked() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent createEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent createUnEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent createReEnrollIntent() {
        Object object = this.mLock;
        synchronized (object) {
            return this.getManageIntentLocked(1);
        }
    }

    private Intent getManageIntentLocked(int action) {
        if (this.mAvailability == -3) {
            throw new IllegalStateException("getManageIntent called on an invalid detector");
        }
        if (this.mAvailability != 2 && this.mAvailability != 1) {
            throw new UnsupportedOperationException("Managing the given keyphrase is not supported");
        }
        return this.mKeyphraseEnrollmentInfo.getManageKeyphraseIntent(action, this.mText, this.mLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mAvailability = -3;
            this.notifyStateChangedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSoundModelsChanged() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailability == -3 || this.mAvailability == -2 || this.mAvailability == -1) {
                Slog.w(TAG, "Received onSoundModelsChanged for an unsupported keyphrase/config");
                return;
            }
            this.stopRecognitionLocked();
            new RefreshAvailabiltyTask().execute(new Void[0]);
        }
    }

    private int startRecognitionLocked(int recognitionFlags) {
        SoundTrigger.KeyphraseRecognitionExtra[] recognitionExtra = new SoundTrigger.KeyphraseRecognitionExtra[]{new SoundTrigger.KeyphraseRecognitionExtra(this.mKeyphraseMetadata.id, this.mKeyphraseMetadata.recognitionModeFlags, 0, new SoundTrigger.ConfidenceLevel[0])};
        boolean captureTriggerAudio = (recognitionFlags & 1) != 0;
        boolean allowMultipleTriggers = (recognitionFlags & 2) != 0;
        int code = Integer.MIN_VALUE;
        try {
            code = this.mModelManagementService.startRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mLocale.toLanguageTag(), this.mInternalCallback, new SoundTrigger.RecognitionConfig(captureTriggerAudio, allowMultipleTriggers, recognitionExtra, null));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in startRecognition!", e);
        }
        if (code != 0) {
            Slog.w(TAG, "startRecognition() failed with error code " + code);
        }
        return code;
    }

    private int stopRecognitionLocked() {
        int code = Integer.MIN_VALUE;
        try {
            code = this.mModelManagementService.stopRecognition(this.mVoiceInteractionService, this.mKeyphraseMetadata.id, this.mInternalCallback);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "RemoteException in stopRecognition!", e);
        }
        if (code != 0) {
            Slog.w(TAG, "stopRecognition() failed with error code " + code);
        }
        return code;
    }

    private void notifyStateChangedLocked() {
        Message message = Message.obtain(this.mHandler, 1);
        message.arg1 = this.mAvailability;
        message.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.print("Text=");
            pw.println(this.mText);
            pw.print(prefix);
            pw.print("Locale=");
            pw.println(this.mLocale);
            pw.print(prefix);
            pw.print("Availability=");
            pw.println(this.mAvailability);
            pw.print(prefix);
            pw.print("KeyphraseMetadata=");
            pw.println(this.mKeyphraseMetadata);
            pw.print(prefix);
            pw.print("EnrollmentInfo=");
            pw.println(this.mKeyphraseEnrollmentInfo);
        }
    }

    class RefreshAvailabiltyTask
    extends AsyncTask<Void, Void, Void> {
        RefreshAvailabiltyTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void doInBackground(Void ... params) {
            int availability = this.internalGetInitialAvailability();
            boolean enrolled = false;
            if (availability == 0 || availability == 1 || availability == 2) {
                enrolled = this.internalGetIsEnrolled(((AlwaysOnHotwordDetector)AlwaysOnHotwordDetector.this).mKeyphraseMetadata.id, AlwaysOnHotwordDetector.this.mLocale);
                availability = !enrolled ? 1 : 2;
            }
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                AlwaysOnHotwordDetector.this.mAvailability = availability;
                AlwaysOnHotwordDetector.this.notifyStateChangedLocked();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int internalGetInitialAvailability() {
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                if (AlwaysOnHotwordDetector.this.mAvailability == -3) {
                    return -3;
                }
            }
            SoundTrigger.ModuleProperties dspModuleProperties = null;
            try {
                dspModuleProperties = AlwaysOnHotwordDetector.this.mModelManagementService.getDspModuleProperties(AlwaysOnHotwordDetector.this.mVoiceInteractionService);
            }
            catch (RemoteException e) {
                Slog.w(AlwaysOnHotwordDetector.TAG, "RemoteException in getDspProperties!", e);
            }
            if (dspModuleProperties == null) {
                return -2;
            }
            if (AlwaysOnHotwordDetector.this.mKeyphraseMetadata == null) {
                return -1;
            }
            return 0;
        }

        private boolean internalGetIsEnrolled(int keyphraseId, Locale locale) {
            try {
                return AlwaysOnHotwordDetector.this.mModelManagementService.isEnrolledForKeyphrase(AlwaysOnHotwordDetector.this.mVoiceInteractionService, keyphraseId, locale.toLanguageTag());
            }
            catch (RemoteException e) {
                Slog.w(AlwaysOnHotwordDetector.TAG, "RemoteException in listRegisteredKeyphraseSoundModels!", e);
                return false;
            }
        }
    }

    class MyHandler
    extends Handler {
        MyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Object object = AlwaysOnHotwordDetector.this.mLock;
            synchronized (object) {
                if (AlwaysOnHotwordDetector.this.mAvailability == -3) {
                    Slog.w(AlwaysOnHotwordDetector.TAG, "Received message: " + msg.what + " for an invalid detector");
                    return;
                }
            }
            switch (msg.what) {
                case 1: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onAvailabilityChanged(msg.arg1);
                    break;
                }
                case 2: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onDetected((EventPayload)msg.obj);
                    break;
                }
                case 3: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onError();
                    break;
                }
                case 4: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onRecognitionPaused();
                    break;
                }
                case 5: {
                    AlwaysOnHotwordDetector.this.mExternalCallback.onRecognitionResumed();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    static final class SoundTriggerListener
    extends IRecognitionStatusCallback.Stub {
        private final Handler mHandler;

        public SoundTriggerListener(Handler handler) {
            this.mHandler = handler;
        }

        @Override
        public void onKeyphraseDetected(SoundTrigger.KeyphraseRecognitionEvent event) {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onDetected");
            Message.obtain(this.mHandler, 2, new EventPayload(event.triggerInData, event.captureAvailable, event.captureFormat, event.captureSession, event.data)).sendToTarget();
        }

        @Override
        public void onGenericSoundTriggerDetected(SoundTrigger.GenericRecognitionEvent event) {
            Slog.w(AlwaysOnHotwordDetector.TAG, "Generic sound trigger event detected at AOHD: " + event);
        }

        @Override
        public void onError(int status) {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onError: " + status);
            this.mHandler.sendEmptyMessage(3);
        }

        @Override
        public void onRecognitionPaused() {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onRecognitionPaused");
            this.mHandler.sendEmptyMessage(4);
        }

        @Override
        public void onRecognitionResumed() {
            Slog.i(AlwaysOnHotwordDetector.TAG, "onRecognitionResumed");
            this.mHandler.sendEmptyMessage(5);
        }
    }

    public static abstract class Callback {
        public abstract void onAvailabilityChanged(int var1);

        public abstract void onDetected(EventPayload var1);

        public abstract void onError();

        public abstract void onRecognitionPaused();

        public abstract void onRecognitionResumed();
    }

    public static class EventPayload {
        private final boolean mTriggerAvailable;
        private final boolean mCaptureAvailable;
        private final int mCaptureSession;
        private final AudioFormat mAudioFormat;
        private final byte[] mData;

        private EventPayload(boolean triggerAvailable, boolean captureAvailable, AudioFormat audioFormat, int captureSession, byte[] data) {
            this.mTriggerAvailable = triggerAvailable;
            this.mCaptureAvailable = captureAvailable;
            this.mCaptureSession = captureSession;
            this.mAudioFormat = audioFormat;
            this.mData = data;
        }

        public AudioFormat getCaptureAudioFormat() {
            return this.mAudioFormat;
        }

        public byte[] getTriggerAudio() {
            if (this.mTriggerAvailable) {
                return this.mData;
            }
            return null;
        }

        public Integer getCaptureSession() {
            if (this.mCaptureAvailable) {
                return this.mCaptureSession;
            }
            return null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecognitionModes {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecognitionFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ManageActions {
    }
}

