/*
 * Decompiled with CFR 0.152.
 */
package android.service.vr;

import android.app.ActivityManager;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.service.vr.IVrListener;

public abstract class VrListenerService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.vr.VrListenerService";
    private final Handler mHandler;
    private static final int MSG_ON_CURRENT_VR_ACTIVITY_CHANGED = 1;
    private final IVrListener.Stub mBinder = new IVrListener.Stub(){

        @Override
        public void focusedActivityChanged(ComponentName component, boolean running2dInVr, int pid) {
            VrListenerService.this.mHandler.obtainMessage(1, running2dInVr ? 1 : 0, pid, component).sendToTarget();
        }
    };

    @Override
    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public VrListenerService() {
        this.mHandler = new VrListenerHandler(Looper.getMainLooper());
    }

    public void onCurrentVrActivityChanged(ComponentName component) {
    }

    public void onCurrentVrActivityChanged(ComponentName component, boolean running2dInVr, int pid) {
        this.onCurrentVrActivityChanged(running2dInVr ? null : component);
    }

    public static final boolean isVrModePackageEnabled(Context context, ComponentName requestedComponent) {
        ActivityManager am = context.getSystemService(ActivityManager.class);
        if (am == null) {
            return false;
        }
        return am.isVrModePackageEnabled(requestedComponent);
    }

    private final class VrListenerHandler
    extends Handler {
        public VrListenerHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    VrListenerService.this.onCurrentVrActivityChanged((ComponentName)msg.obj, msg.arg1 == 1, msg.arg2);
                }
            }
        }
    }
}

