/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.text.TextUtils;
import android.util.Log;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class SpeechRecognizer {
    private static final boolean DBG = false;
    private static final String TAG = "SpeechRecognizer";
    public static final String RESULTS_RECOGNITION = "results_recognition";
    public static final String CONFIDENCE_SCORES = "confidence_scores";
    public static final int ERROR_NETWORK_TIMEOUT = 1;
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_AUDIO = 3;
    public static final int ERROR_SERVER = 4;
    public static final int ERROR_CLIENT = 5;
    public static final int ERROR_SPEECH_TIMEOUT = 6;
    public static final int ERROR_NO_MATCH = 7;
    public static final int ERROR_RECOGNIZER_BUSY = 8;
    public static final int ERROR_INSUFFICIENT_PERMISSIONS = 9;
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final int MSG_CANCEL = 3;
    private static final int MSG_CHANGE_LISTENER = 4;
    private IRecognitionService mService;
    private Connection mConnection;
    private final Context mContext;
    private final ComponentName mServiceComponent;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SpeechRecognizer.this.handleStartListening((Intent)msg.obj);
                    break;
                }
                case 2: {
                    SpeechRecognizer.this.handleStopMessage();
                    break;
                }
                case 3: {
                    SpeechRecognizer.this.handleCancelMessage();
                    break;
                }
                case 4: {
                    SpeechRecognizer.this.handleChangeListener((RecognitionListener)msg.obj);
                }
            }
        }
    };
    private final Queue<Message> mPendingTasks = new LinkedList<Message>();
    private final InternalListener mListener = new InternalListener();

    private SpeechRecognizer(Context context, ComponentName serviceComponent) {
        this.mContext = context;
        this.mServiceComponent = serviceComponent;
    }

    public static boolean isRecognitionAvailable(Context context) {
        List<ResolveInfo> list = context.getPackageManager().queryIntentServices(new Intent("android.speech.RecognitionService"), 0);
        return list != null && list.size() != 0;
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context) {
        return SpeechRecognizer.createSpeechRecognizer(context, null);
    }

    public static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null)");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        return new SpeechRecognizer(context, serviceComponent);
    }

    public void setRecognitionListener(RecognitionListener listener) {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 4, listener));
    }

    public void startListening(Intent recognizerIntent) {
        if (recognizerIntent == null) {
            throw new IllegalArgumentException("intent must not be null");
        }
        SpeechRecognizer.checkIsCalledFromMainThread();
        if (this.mConnection == null) {
            this.mConnection = new Connection();
            Intent serviceIntent = new Intent("android.speech.RecognitionService");
            if (this.mServiceComponent == null) {
                String serviceComponent = Settings.Secure.getString(this.mContext.getContentResolver(), "voice_recognition_service");
                if (TextUtils.isEmpty(serviceComponent)) {
                    Log.e(TAG, "no selected voice recognition service");
                    this.mListener.onError(5);
                    return;
                }
                serviceIntent.setComponent(ComponentName.unflattenFromString(serviceComponent));
            } else {
                serviceIntent.setComponent(this.mServiceComponent);
            }
            if (!this.mContext.bindService(serviceIntent, this.mConnection, 1)) {
                Log.e(TAG, "bind to recognition service failed");
                this.mConnection = null;
                this.mService = null;
                this.mListener.onError(5);
                return;
            }
        }
        this.putMessage(Message.obtain(this.mHandler, 1, recognizerIntent));
    }

    public void stopListening() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 2));
    }

    public void cancel() {
        SpeechRecognizer.checkIsCalledFromMainThread();
        this.putMessage(Message.obtain(this.mHandler, 3));
    }

    private static void checkIsCalledFromMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("SpeechRecognizer should be used only from the application's main thread");
        }
    }

    private void putMessage(Message msg) {
        if (this.mService == null) {
            this.mPendingTasks.offer(msg);
        } else {
            this.mHandler.sendMessage(msg);
        }
    }

    private void handleStartListening(Intent recognizerIntent) {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.startListening(recognizerIntent, this.mListener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "startListening() failed", e);
            this.mListener.onError(5);
        }
    }

    private void handleStopMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.stopListening(this.mListener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "stopListening() failed", e);
            this.mListener.onError(5);
        }
    }

    private void handleCancelMessage() {
        if (!this.checkOpenConnection()) {
            return;
        }
        try {
            this.mService.cancel(this.mListener);
        }
        catch (RemoteException e) {
            Log.e(TAG, "cancel() failed", e);
            this.mListener.onError(5);
        }
    }

    private boolean checkOpenConnection() {
        if (this.mService != null) {
            return true;
        }
        this.mListener.onError(5);
        Log.e(TAG, "not connected to the recognition service");
        return false;
    }

    private void handleChangeListener(RecognitionListener listener) {
        this.mListener.mInternalListener = listener;
    }

    public void destroy() {
        if (this.mService != null) {
            try {
                this.mService.cancel(this.mListener);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this.mConnection != null) {
            this.mContext.unbindService(this.mConnection);
        }
        this.mPendingTasks.clear();
        this.mService = null;
        this.mConnection = null;
        this.mListener.mInternalListener = null;
    }

    private static class InternalListener
    extends IRecognitionListener.Stub {
        private RecognitionListener mInternalListener;
        private static final int MSG_BEGINNING_OF_SPEECH = 1;
        private static final int MSG_BUFFER_RECEIVED = 2;
        private static final int MSG_END_OF_SPEECH = 3;
        private static final int MSG_ERROR = 4;
        private static final int MSG_READY_FOR_SPEECH = 5;
        private static final int MSG_RESULTS = 6;
        private static final int MSG_PARTIAL_RESULTS = 7;
        private static final int MSG_RMS_CHANGED = 8;
        private static final int MSG_ON_EVENT = 9;
        private final Handler mInternalHandler = new Handler(){

            @Override
            public void handleMessage(Message msg) {
                if (mInternalListener == null) {
                    return;
                }
                switch (msg.what) {
                    case 1: {
                        mInternalListener.onBeginningOfSpeech();
                        break;
                    }
                    case 2: {
                        mInternalListener.onBufferReceived((byte[])msg.obj);
                        break;
                    }
                    case 3: {
                        mInternalListener.onEndOfSpeech();
                        break;
                    }
                    case 4: {
                        mInternalListener.onError((Integer)msg.obj);
                        break;
                    }
                    case 5: {
                        mInternalListener.onReadyForSpeech((Bundle)msg.obj);
                        break;
                    }
                    case 6: {
                        mInternalListener.onResults((Bundle)msg.obj);
                        break;
                    }
                    case 7: {
                        mInternalListener.onPartialResults((Bundle)msg.obj);
                        break;
                    }
                    case 8: {
                        mInternalListener.onRmsChanged(((Float)msg.obj).floatValue());
                        break;
                    }
                    case 9: {
                        mInternalListener.onEvent(msg.arg1, (Bundle)msg.obj);
                    }
                }
            }
        };

        private InternalListener() {
        }

        @Override
        public void onBeginningOfSpeech() {
            Message.obtain(this.mInternalHandler, 1).sendToTarget();
        }

        @Override
        public void onBufferReceived(byte[] buffer) {
            Message.obtain(this.mInternalHandler, 2, buffer).sendToTarget();
        }

        @Override
        public void onEndOfSpeech() {
            Message.obtain(this.mInternalHandler, 3).sendToTarget();
        }

        @Override
        public void onError(int error) {
            Message.obtain(this.mInternalHandler, 4, error).sendToTarget();
        }

        @Override
        public void onReadyForSpeech(Bundle noiseParams) {
            Message.obtain(this.mInternalHandler, 5, noiseParams).sendToTarget();
        }

        @Override
        public void onResults(Bundle results) {
            Message.obtain(this.mInternalHandler, 6, results).sendToTarget();
        }

        @Override
        public void onPartialResults(Bundle results) {
            Message.obtain(this.mInternalHandler, 7, results).sendToTarget();
        }

        @Override
        public void onRmsChanged(float rmsdB) {
            Message.obtain(this.mInternalHandler, 8, Float.valueOf(rmsdB)).sendToTarget();
        }

        @Override
        public void onEvent(int eventType, Bundle params) {
            Message.obtain(this.mInternalHandler, 9, eventType, eventType, params).sendToTarget();
        }
    }

    private class Connection
    implements ServiceConnection {
        private Connection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            SpeechRecognizer.this.mService = IRecognitionService.Stub.asInterface(service);
            while (!SpeechRecognizer.this.mPendingTasks.isEmpty()) {
                SpeechRecognizer.this.mHandler.sendMessage((Message)SpeechRecognizer.this.mPendingTasks.poll());
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            SpeechRecognizer.this.mService = null;
            SpeechRecognizer.this.mConnection = null;
            SpeechRecognizer.this.mPendingTasks.clear();
        }
    }
}

