/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.AudioState;
import java.util.Locale;

public final class CallAudioState
implements Parcelable {
    public static final int ROUTE_EARPIECE = 1;
    public static final int ROUTE_BLUETOOTH = 2;
    public static final int ROUTE_WIRED_HEADSET = 4;
    public static final int ROUTE_SPEAKER = 8;
    public static final int ROUTE_WIRED_OR_EARPIECE = 5;
    public static final int ROUTE_ALL = 15;
    private final boolean isMuted;
    private final int route;
    private final int supportedRouteMask;
    public static final Parcelable.Creator<CallAudioState> CREATOR = new Parcelable.Creator<CallAudioState>(){

        @Override
        public CallAudioState createFromParcel(Parcel source) {
            boolean isMuted = source.readByte() != 0;
            int route = source.readInt();
            int supportedRouteMask = source.readInt();
            return new CallAudioState(isMuted, route, supportedRouteMask);
        }

        public CallAudioState[] newArray(int size) {
            return new CallAudioState[size];
        }
    };

    public CallAudioState(boolean muted, int route, int supportedRouteMask) {
        this.isMuted = muted;
        this.route = route;
        this.supportedRouteMask = supportedRouteMask;
    }

    public CallAudioState(CallAudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
    }

    public CallAudioState(AudioState state) {
        this.isMuted = state.isMuted();
        this.route = state.getRoute();
        this.supportedRouteMask = state.getSupportedRouteMask();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAudioState)) {
            return false;
        }
        CallAudioState state = (CallAudioState)obj;
        return this.isMuted() == state.isMuted() && this.getRoute() == state.getRoute() && this.getSupportedRouteMask() == state.getSupportedRouteMask();
    }

    public String toString() {
        return String.format(Locale.US, "[AudioState isMuted: %b, route: %s, supportedRouteMask: %s]", this.isMuted, CallAudioState.audioRouteToString(this.route), CallAudioState.audioRouteToString(this.supportedRouteMask));
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getRoute() {
        return this.route;
    }

    public int getSupportedRouteMask() {
        return this.supportedRouteMask;
    }

    public static String audioRouteToString(int route) {
        if (route == 0 || (route & 0xFFFFFFF0) != 0) {
            return "UNKNOWN";
        }
        StringBuffer buffer = new StringBuffer();
        if ((route & 1) == 1) {
            CallAudioState.listAppend(buffer, "EARPIECE");
        }
        if ((route & 2) == 2) {
            CallAudioState.listAppend(buffer, "BLUETOOTH");
        }
        if ((route & 4) == 4) {
            CallAudioState.listAppend(buffer, "WIRED_HEADSET");
        }
        if ((route & 8) == 8) {
            CallAudioState.listAppend(buffer, "SPEAKER");
        }
        return buffer.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeByte((byte)(this.isMuted ? 1 : 0));
        destination.writeInt(this.route);
        destination.writeInt(this.supportedRouteMask);
    }

    private static void listAppend(StringBuffer buffer, String str) {
        if (buffer.length() > 0) {
            buffer.append(", ");
        }
        buffer.append(str);
    }
}

