/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.PhoneAccountHandle;

public class Voicemail
implements Parcelable {
    private final Long mTimestamp;
    private final String mNumber;
    private final PhoneAccountHandle mPhoneAccount;
    private final Long mId;
    private final Long mDuration;
    private final String mSource;
    private final String mProviderData;
    private final Uri mUri;
    private final Boolean mIsRead;
    private final Boolean mHasContent;
    private final String mTranscription;
    public static final Parcelable.Creator<Voicemail> CREATOR = new Parcelable.Creator<Voicemail>(){

        @Override
        public Voicemail createFromParcel(Parcel in) {
            return new Voicemail(in);
        }

        public Voicemail[] newArray(int size) {
            return new Voicemail[size];
        }
    };

    private Voicemail(Long timestamp, String number, PhoneAccountHandle phoneAccountHandle, Long id2, Long duration, String source, String providerData, Uri uri, Boolean isRead, Boolean hasContent, String transcription) {
        this.mTimestamp = timestamp;
        this.mNumber = number;
        this.mPhoneAccount = phoneAccountHandle;
        this.mId = id2;
        this.mDuration = duration;
        this.mSource = source;
        this.mProviderData = providerData;
        this.mUri = uri;
        this.mIsRead = isRead;
        this.mHasContent = hasContent;
        this.mTranscription = transcription;
    }

    public static Builder createForInsertion(long timestamp, String number) {
        return new Builder().setNumber(number).setTimestamp(timestamp);
    }

    public static Builder createForUpdate(long id2, String sourceData) {
        return new Builder().setId(id2).setSourceData(sourceData);
    }

    public long getId() {
        return this.mId;
    }

    public String getNumber() {
        return this.mNumber;
    }

    public PhoneAccountHandle getPhoneAccount() {
        return this.mPhoneAccount;
    }

    public long getTimestampMillis() {
        return this.mTimestamp;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public String getSourcePackage() {
        return this.mSource;
    }

    public String getSourceData() {
        return this.mProviderData;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public boolean isRead() {
        return this.mIsRead;
    }

    public boolean hasContent() {
        return this.mHasContent;
    }

    public String getTranscription() {
        return this.mTranscription;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeCharSequence(this.mNumber);
        if (this.mPhoneAccount == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mPhoneAccount.writeToParcel(dest, flags);
        }
        dest.writeLong(this.mId);
        dest.writeLong(this.mDuration);
        dest.writeCharSequence(this.mSource);
        dest.writeCharSequence(this.mProviderData);
        if (this.mUri == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
            this.mUri.writeToParcel(dest, flags);
        }
        if (this.mIsRead.booleanValue()) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        if (this.mHasContent.booleanValue()) {
            dest.writeInt(1);
        } else {
            dest.writeInt(0);
        }
        dest.writeCharSequence(this.mTranscription);
    }

    private Voicemail(Parcel in) {
        this.mTimestamp = in.readLong();
        this.mNumber = (String)in.readCharSequence();
        this.mPhoneAccount = in.readInt() > 0 ? PhoneAccountHandle.CREATOR.createFromParcel(in) : null;
        this.mId = in.readLong();
        this.mDuration = in.readLong();
        this.mSource = (String)in.readCharSequence();
        this.mProviderData = (String)in.readCharSequence();
        this.mUri = in.readInt() > 0 ? Uri.CREATOR.createFromParcel(in) : null;
        this.mIsRead = in.readInt() > 0;
        this.mHasContent = in.readInt() > 0;
        this.mTranscription = (String)in.readCharSequence();
    }

    public static class Builder {
        private Long mBuilderTimestamp;
        private String mBuilderNumber;
        private PhoneAccountHandle mBuilderPhoneAccount;
        private Long mBuilderId;
        private Long mBuilderDuration;
        private String mBuilderSourcePackage;
        private String mBuilderSourceData;
        private Uri mBuilderUri;
        private Boolean mBuilderIsRead;
        private boolean mBuilderHasContent;
        private String mBuilderTranscription;

        private Builder() {
        }

        public Builder setNumber(String number) {
            this.mBuilderNumber = number;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.mBuilderTimestamp = timestamp;
            return this;
        }

        public Builder setPhoneAccount(PhoneAccountHandle phoneAccount) {
            this.mBuilderPhoneAccount = phoneAccount;
            return this;
        }

        public Builder setId(long id2) {
            this.mBuilderId = id2;
            return this;
        }

        public Builder setDuration(long duration) {
            this.mBuilderDuration = duration;
            return this;
        }

        public Builder setSourcePackage(String sourcePackage) {
            this.mBuilderSourcePackage = sourcePackage;
            return this;
        }

        public Builder setSourceData(String sourceData) {
            this.mBuilderSourceData = sourceData;
            return this;
        }

        public Builder setUri(Uri uri) {
            this.mBuilderUri = uri;
            return this;
        }

        public Builder setIsRead(boolean isRead) {
            this.mBuilderIsRead = isRead;
            return this;
        }

        public Builder setHasContent(boolean hasContent) {
            this.mBuilderHasContent = hasContent;
            return this;
        }

        public Builder setTranscription(String transcription) {
            this.mBuilderTranscription = transcription;
            return this;
        }

        public Voicemail build() {
            this.mBuilderId = this.mBuilderId == null ? -1L : this.mBuilderId;
            this.mBuilderTimestamp = this.mBuilderTimestamp == null ? 0L : this.mBuilderTimestamp;
            this.mBuilderDuration = this.mBuilderDuration == null ? 0L : this.mBuilderDuration;
            this.mBuilderIsRead = this.mBuilderIsRead == null ? false : this.mBuilderIsRead;
            return new Voicemail(this.mBuilderTimestamp, this.mBuilderNumber, this.mBuilderPhoneAccount, this.mBuilderId, this.mBuilderDuration, this.mBuilderSourcePackage, this.mBuilderSourceData, this.mBuilderUri, this.mBuilderIsRead, this.mBuilderHasContent, this.mBuilderTranscription);
        }
    }
}

