/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.telecom.PhoneAccountHandle;
import android.telecom.TelecomManager;
import android.telephony.TelephonyManager;
import android.telephony.VisualVoicemailSms;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.util.Log;

public abstract class VisualVoicemailService
extends Service {
    private static final String TAG = "VvmService";
    public static final String SERVICE_INTERFACE = "android.telephony.VisualVoicemailService";
    public static final int MSG_ON_CELL_SERVICE_CONNECTED = 1;
    public static final int MSG_ON_SMS_RECEIVED = 2;
    public static final int MSG_ON_SIM_REMOVED = 3;
    public static final int MSG_TASK_ENDED = 4;
    public static final int MSG_TASK_STOPPED = 5;
    public static final String DATA_PHONE_ACCOUNT_HANDLE = "data_phone_account_handle";
    public static final String DATA_SMS = "data_sms";
    private final Messenger mMessenger = new Messenger(new Handler(){

        @Override
        public void handleMessage(Message msg) {
            PhoneAccountHandle handle = (PhoneAccountHandle)msg.getData().getParcelable(VisualVoicemailService.DATA_PHONE_ACCOUNT_HANDLE);
            VisualVoicemailTask task = new VisualVoicemailTask(msg.replyTo, msg.arg1);
            switch (msg.what) {
                case 1: {
                    VisualVoicemailService.this.onCellServiceConnected(task, handle);
                    break;
                }
                case 2: {
                    VisualVoicemailSms sms = (VisualVoicemailSms)msg.getData().getParcelable(VisualVoicemailService.DATA_SMS);
                    VisualVoicemailService.this.onSmsReceived(task, sms);
                    break;
                }
                case 3: {
                    VisualVoicemailService.this.onSimRemoved(task, handle);
                    break;
                }
                case 5: {
                    VisualVoicemailService.this.onStopped(task);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    });

    @Override
    public IBinder onBind(Intent intent) {
        return this.mMessenger.getBinder();
    }

    public abstract void onCellServiceConnected(VisualVoicemailTask var1, PhoneAccountHandle var2);

    public abstract void onSmsReceived(VisualVoicemailTask var1, VisualVoicemailSms var2);

    public abstract void onSimRemoved(VisualVoicemailTask var1, PhoneAccountHandle var2);

    public abstract void onStopped(VisualVoicemailTask var1);

    public static final void setSmsFilterSettings(Context context, PhoneAccountHandle phoneAccountHandle, VisualVoicemailSmsFilterSettings settings) {
        TelephonyManager telephonyManager = context.getSystemService(TelephonyManager.class);
        int subId = VisualVoicemailService.getSubId(context, phoneAccountHandle);
        if (settings == null) {
            telephonyManager.disableVisualVoicemailSmsFilter(subId);
        } else {
            telephonyManager.enableVisualVoicemailSmsFilter(subId, settings);
        }
    }

    public static final void sendVisualVoicemailSms(Context context, PhoneAccountHandle phoneAccountHandle, String number, short port, String text, PendingIntent sentIntent) {
        TelephonyManager telephonyManager = context.getSystemService(TelephonyManager.class);
        telephonyManager.sendVisualVoicemailSmsForSubscriber(VisualVoicemailService.getSubId(context, phoneAccountHandle), number, port, text, sentIntent);
    }

    private static int getSubId(Context context, PhoneAccountHandle phoneAccountHandle) {
        TelephonyManager telephonyManager = context.getSystemService(TelephonyManager.class);
        TelecomManager telecomManager = context.getSystemService(TelecomManager.class);
        return telephonyManager.getSubIdForPhoneAccount(telecomManager.getPhoneAccount(phoneAccountHandle));
    }

    public static class VisualVoicemailTask {
        private final int mTaskId;
        private final Messenger mReplyTo;

        private VisualVoicemailTask(Messenger replyTo, int taskId) {
            this.mTaskId = taskId;
            this.mReplyTo = replyTo;
        }

        public final void finish() {
            Message message = Message.obtain();
            try {
                message.what = 4;
                message.arg1 = this.mTaskId;
                this.mReplyTo.send(message);
            }
            catch (RemoteException e) {
                Log.e(VisualVoicemailService.TAG, "Cannot send MSG_TASK_ENDED, remote handler no longer exist");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof VisualVoicemailTask)) {
                return false;
            }
            return this.mTaskId == ((VisualVoicemailTask)obj).mTaskId;
        }

        public int hashCode() {
            return this.mTaskId;
        }
    }
}

