/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.feature.IMMTelFeature;
import com.android.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsCallSessionListener;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsService;
import com.android.ims.internal.IImsUt;

public class ImsServiceProxyCompat
implements IMMTelFeature {
    private static final int SERVICE_ID = 1;
    protected final int mSlotId;
    protected IBinder mBinder;

    public ImsServiceProxyCompat(int slotId, IBinder binder) {
        this.mSlotId = slotId;
        this.mBinder = binder;
    }

    @Override
    public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).open(this.mSlotId, 1, incomingCallIntent, listener);
    }

    @Override
    public void endSession(int sessionId) throws RemoteException {
        this.checkBinderConnection();
        this.getServiceInterface(this.mBinder).close(sessionId);
    }

    @Override
    public boolean isConnected(int callServiceType, int callType) throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).isConnected(1, callServiceType, callType);
    }

    @Override
    public boolean isOpened() throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).isOpened(1);
    }

    @Override
    public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        this.checkBinderConnection();
        this.getServiceInterface(this.mBinder).addRegistrationListener(this.mSlotId, 1, listener);
    }

    @Override
    public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
    }

    @Override
    public ImsCallProfile createCallProfile(int sessionId, int callServiceType, int callType) throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).createCallProfile(sessionId, callServiceType, callType);
    }

    @Override
    public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile, IImsCallSessionListener listener) throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).createCallSession(sessionId, profile, listener);
    }

    @Override
    public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).getPendingCallSession(sessionId, callId);
    }

    @Override
    public IImsUt getUtInterface() throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).getUtInterface(1);
    }

    @Override
    public IImsConfig getConfigInterface() throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).getConfigInterface(this.mSlotId);
    }

    @Override
    public void turnOnIms() throws RemoteException {
        this.checkBinderConnection();
        this.getServiceInterface(this.mBinder).turnOnIms(this.mSlotId);
    }

    @Override
    public void turnOffIms() throws RemoteException {
        this.checkBinderConnection();
        this.getServiceInterface(this.mBinder).turnOffIms(this.mSlotId);
    }

    @Override
    public IImsEcbm getEcbmInterface() throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).getEcbmInterface(1);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        this.checkBinderConnection();
        this.getServiceInterface(this.mBinder).setUiTTYMode(1, uiTtyMode, onComplete);
    }

    @Override
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        this.checkBinderConnection();
        return this.getServiceInterface(this.mBinder).getMultiEndpointInterface(1);
    }

    public int getFeatureStatus() {
        return 2;
    }

    public boolean isBinderAlive() {
        return this.mBinder != null && this.mBinder.isBinderAlive();
    }

    private IImsService getServiceInterface(IBinder b) {
        return IImsService.Stub.asInterface(b);
    }

    protected void checkBinderConnection() throws RemoteException {
        if (!this.isBinderAlive()) {
            throw new RemoteException("ImsServiceProxy is not available for that feature.");
        }
    }
}

