/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.os.Handler;
import android.os.RemoteException;
import android.telephony.mbms.FileServiceInfo;
import android.telephony.mbms.IMbmsDownloadSessionCallback;
import android.telephony.mbms.MbmsDownloadSessionCallback;
import java.util.List;

public class InternalDownloadSessionCallback
extends IMbmsDownloadSessionCallback.Stub {
    private final Handler mHandler;
    private final MbmsDownloadSessionCallback mAppCallback;
    private volatile boolean mIsStopped = false;

    public InternalDownloadSessionCallback(MbmsDownloadSessionCallback appCallback, Handler handler) {
        this.mAppCallback = appCallback;
        this.mHandler = handler;
    }

    @Override
    public void onError(final int errorCode, final String message) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalDownloadSessionCallback.this.mAppCallback.onError(errorCode, message);
            }
        });
    }

    @Override
    public void onFileServicesUpdated(final List<FileServiceInfo> services) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalDownloadSessionCallback.this.mAppCallback.onFileServicesUpdated(services);
            }
        });
    }

    @Override
    public void onMiddlewareReady() throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalDownloadSessionCallback.this.mAppCallback.onMiddlewareReady();
            }
        });
    }

    public Handler getHandler() {
        return this.mHandler;
    }

    public void stop() {
        this.mIsStopped = true;
    }
}

