/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms;

import android.os.Handler;
import android.os.RemoteException;
import android.telephony.mbms.IStreamingServiceCallback;
import android.telephony.mbms.StreamingServiceCallback;

public class InternalStreamingServiceCallback
extends IStreamingServiceCallback.Stub {
    private final StreamingServiceCallback mAppCallback;
    private final Handler mHandler;
    private volatile boolean mIsStopped = false;

    public InternalStreamingServiceCallback(StreamingServiceCallback appCallback, Handler handler) {
        this.mAppCallback = appCallback;
        this.mHandler = handler;
    }

    @Override
    public void onError(final int errorCode, final String message) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingServiceCallback.this.mAppCallback.onError(errorCode, message);
            }
        });
    }

    @Override
    public void onStreamStateUpdated(final int state, final int reason) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingServiceCallback.this.mAppCallback.onStreamStateUpdated(state, reason);
            }
        });
    }

    @Override
    public void onMediaDescriptionUpdated() throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingServiceCallback.this.mAppCallback.onMediaDescriptionUpdated();
            }
        });
    }

    @Override
    public void onBroadcastSignalStrengthUpdated(final int signalStrength) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingServiceCallback.this.mAppCallback.onBroadcastSignalStrengthUpdated(signalStrength);
            }
        });
    }

    @Override
    public void onStreamMethodUpdated(final int methodType) throws RemoteException {
        if (this.mIsStopped) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                InternalStreamingServiceCallback.this.mAppCallback.onStreamMethodUpdated(methodType);
            }
        });
    }

    public void stop() {
        this.mIsStopped = true;
    }
}

