/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public final class Scene {
    private Context mContext;
    private int mLayoutId = -1;
    private ViewGroup mSceneRoot;
    private View mLayout;
    Runnable mEnterAction;
    Runnable mExitAction;

    public static Scene getSceneForLayout(ViewGroup sceneRoot, int layoutId, Context context) {
        Scene scene;
        SparseArray<Scene> scenes = (SparseArray<Scene>)sceneRoot.getTag(16909218);
        if (scenes == null) {
            scenes = new SparseArray<Scene>();
            sceneRoot.setTagInternal(16909218, scenes);
        }
        if ((scene = (Scene)scenes.get(layoutId)) != null) {
            return scene;
        }
        scene = new Scene(sceneRoot, layoutId, context);
        scenes.put(layoutId, scene);
        return scene;
    }

    public Scene(ViewGroup sceneRoot) {
        this.mSceneRoot = sceneRoot;
    }

    private Scene(ViewGroup sceneRoot, int layoutId, Context context) {
        this.mContext = context;
        this.mSceneRoot = sceneRoot;
        this.mLayoutId = layoutId;
    }

    public Scene(ViewGroup sceneRoot, View layout2) {
        this.mSceneRoot = sceneRoot;
        this.mLayout = layout2;
    }

    @Deprecated
    public Scene(ViewGroup sceneRoot, ViewGroup layout2) {
        this.mSceneRoot = sceneRoot;
        this.mLayout = layout2;
    }

    public ViewGroup getSceneRoot() {
        return this.mSceneRoot;
    }

    public void exit() {
        if (Scene.getCurrentScene(this.mSceneRoot) == this && this.mExitAction != null) {
            this.mExitAction.run();
        }
    }

    public void enter() {
        if (this.mLayoutId > 0 || this.mLayout != null) {
            this.getSceneRoot().removeAllViews();
            if (this.mLayoutId > 0) {
                LayoutInflater.from(this.mContext).inflate(this.mLayoutId, this.mSceneRoot);
            } else {
                this.mSceneRoot.addView(this.mLayout);
            }
        }
        if (this.mEnterAction != null) {
            this.mEnterAction.run();
        }
        Scene.setCurrentScene(this.mSceneRoot, this);
    }

    static void setCurrentScene(View view, Scene scene) {
        view.setTagInternal(16908807, scene);
    }

    static Scene getCurrentScene(View view) {
        return (Scene)view.getTag(16908807);
    }

    public void setEnterAction(Runnable action) {
        this.mEnterAction = action;
    }

    public void setExitAction(Runnable action) {
        this.mExitAction = action;
    }

    boolean isCreatedFromLayoutResource() {
        return this.mLayoutId > 0;
    }
}

