/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

public final class LocalLog {
    private final Deque<String> mLog;
    private final int mMaxLines;

    public LocalLog(int maxLines) {
        this.mMaxLines = Math.max(0, maxLines);
        this.mLog = new ArrayDeque<String>(this.mMaxLines);
    }

    public void log(String msg) {
        if (this.mMaxLines <= 0) {
            return;
        }
        this.append(String.format("%s - %s", LocalDateTime.now(), msg));
    }

    private synchronized void append(String logLine) {
        while (this.mLog.size() >= this.mMaxLines) {
            this.mLog.remove();
        }
        this.mLog.add(logLine);
    }

    public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        Iterator<String> itr = this.mLog.iterator();
        while (itr.hasNext()) {
            pw.println(itr.next());
        }
    }

    public synchronized void reverseDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        Iterator<String> itr = this.mLog.descendingIterator();
        while (itr.hasNext()) {
            pw.println(itr.next());
        }
    }

    public ReadOnlyLocalLog readOnlyLocalLog() {
        return new ReadOnlyLocalLog(this);
    }

    public static class ReadOnlyLocalLog {
        private final LocalLog mLog;

        ReadOnlyLocalLog(LocalLog log) {
            this.mLog = log;
        }

        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            this.mLog.dump(fd, pw, args);
        }

        public void reverseDump(FileDescriptor fd, PrintWriter pw, String[] args) {
            this.mLog.reverseDump(fd, pw, args);
        }
    }
}

