/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.pm.Signature;
import android.util.ByteStringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class PackageUtils {
    private PackageUtils() {
    }

    public static String[] computeSignaturesSha256Digests(Signature[] signatures) {
        int signatureCount = signatures.length;
        String[] digests = new String[signatureCount];
        for (int i = 0; i < signatureCount; ++i) {
            digests[i] = PackageUtils.computeSha256Digest(signatures[i].toByteArray());
        }
        return digests;
    }

    public static String computeSignaturesSha256Digest(Signature[] signatures) {
        if (signatures.length == 1) {
            return PackageUtils.computeSha256Digest(signatures[0].toByteArray());
        }
        String[] sha256Digests = PackageUtils.computeSignaturesSha256Digests(signatures);
        return PackageUtils.computeSignaturesSha256Digest(sha256Digests);
    }

    public static String computeSignaturesSha256Digest(String[] sha256Digests) {
        if (sha256Digests.length == 1) {
            return sha256Digests[0];
        }
        Arrays.sort(sha256Digests);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (String sha256Digest : sha256Digests) {
            try {
                bytes.write(sha256Digest.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return PackageUtils.computeSha256Digest(bytes.toByteArray());
    }

    public static String computeSha256Digest(byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(data);
        return ByteStringUtils.toHexString(messageDigest.digest());
    }
}

