/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.view.Choreographer;
import android.view.InputChannel;
import android.view.InputEventReceiver;

public class BatchedInputEventReceiver
extends InputEventReceiver {
    Choreographer mChoreographer;
    private boolean mBatchedInputScheduled;
    private final BatchedInputRunnable mBatchedInputRunnable = new BatchedInputRunnable();

    public BatchedInputEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer) {
        super(inputChannel, looper);
        this.mChoreographer = choreographer;
    }

    @Override
    public void onBatchedInputEventPending() {
        this.scheduleBatchedInput();
    }

    @Override
    public void dispose() {
        this.unscheduleBatchedInput();
        super.dispose();
    }

    void doConsumeBatchedInput(long frameTimeNanos) {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            if (this.consumeBatchedInputEvents(frameTimeNanos) && frameTimeNanos != -1L) {
                this.scheduleBatchedInput();
            }
        }
    }

    private void scheduleBatchedInput() {
        if (!this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = true;
            this.mChoreographer.postCallback(0, this.mBatchedInputRunnable, null);
        }
    }

    private void unscheduleBatchedInput() {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            this.mChoreographer.removeCallbacks(0, this.mBatchedInputRunnable, null);
        }
    }

    private final class BatchedInputRunnable
    implements Runnable {
        private BatchedInputRunnable() {
        }

        @Override
        public void run() {
            BatchedInputEventReceiver.this.doConsumeBatchedInput(BatchedInputEventReceiver.this.mChoreographer.getFrameTimeNanos());
        }
    }
}

