/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Handler;
import com.android.internal.util.GrowingArrayUtils;

public class HandlerActionQueue {
    private HandlerAction[] mActions;
    private int mCount;

    public void post(Runnable action) {
        this.postDelayed(action, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDelayed(Runnable action, long delayMillis) {
        HandlerAction handlerAction = new HandlerAction(action, delayMillis);
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            if (this.mActions == null) {
                this.mActions = new HandlerAction[4];
            }
            this.mActions = GrowingArrayUtils.append(this.mActions, this.mCount, handlerAction);
            ++this.mCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbacks(Runnable action) {
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            int count = this.mCount;
            int j = 0;
            HandlerAction[] actions = this.mActions;
            for (int i = 0; i < count; ++i) {
                if (actions[i].matches(action)) continue;
                if (j != i) {
                    actions[j] = actions[i];
                }
                ++j;
            }
            this.mCount = j;
            while (j < count) {
                actions[j] = null;
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeActions(Handler handler) {
        HandlerActionQueue handlerActionQueue = this;
        synchronized (handlerActionQueue) {
            HandlerAction[] actions = this.mActions;
            int count = this.mCount;
            for (int i = 0; i < count; ++i) {
                HandlerAction handlerAction = actions[i];
                handler.postDelayed(handlerAction.action, handlerAction.delay);
            }
            this.mActions = null;
            this.mCount = 0;
        }
    }

    public int size() {
        return this.mCount;
    }

    public Runnable getRunnable(int index) {
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.mActions[index].action;
    }

    public long getDelay(int index) {
        if (index >= this.mCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.mActions[index].delay;
    }

    private static class HandlerAction {
        final Runnable action;
        final long delay;

        public HandlerAction(Runnable action, long delay) {
            this.action = action;
            this.delay = delay;
        }

        public boolean matches(Runnable otherAction) {
            return otherAction == null && this.action == null || this.action != null && this.action.equals(otherAction);
        }
    }
}

