/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.BaseInterpolator;
import com.android.internal.R;
import com.android.internal.view.animation.HasNativeInterpolator;
import com.android.internal.view.animation.NativeInterpolatorFactory;
import com.android.internal.view.animation.NativeInterpolatorFactoryHelper;

@HasNativeInterpolator
public class AnticipateOvershootInterpolator
extends BaseInterpolator
implements NativeInterpolatorFactory {
    private final float mTension;

    public AnticipateOvershootInterpolator() {
        this.mTension = 3.0f;
    }

    public AnticipateOvershootInterpolator(float tension) {
        this.mTension = tension * 1.5f;
    }

    public AnticipateOvershootInterpolator(float tension, float extraTension) {
        this.mTension = tension * extraTension;
    }

    public AnticipateOvershootInterpolator(Context context, AttributeSet attrs) {
        this(context.getResources(), context.getTheme(), attrs);
    }

    public AnticipateOvershootInterpolator(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.AnticipateOvershootInterpolator, 0, 0) : res.obtainAttributes(attrs, R.styleable.AnticipateOvershootInterpolator);
        this.mTension = a.getFloat(0, 2.0f) * a.getFloat(1, 1.5f);
        this.setChangingConfiguration(a.getChangingConfigurations());
        a.recycle();
    }

    private static float a(float t, float s) {
        return t * t * ((s + 1.0f) * t - s);
    }

    private static float o(float t, float s) {
        return t * t * ((s + 1.0f) * t + s);
    }

    @Override
    public float getInterpolation(float t) {
        if (t < 0.5f) {
            return 0.5f * AnticipateOvershootInterpolator.a(t * 2.0f, this.mTension);
        }
        return 0.5f * (AnticipateOvershootInterpolator.o(t * 2.0f - 2.0f, this.mTension) + 2.0f);
    }

    @Override
    public long createNativeInterpolator() {
        return NativeInterpolatorFactoryHelper.createAnticipateOvershootInterpolator(this.mTension);
    }
}

