/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.provider.Settings;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.ClickableSpan;
import android.text.util.Linkify;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.view.textclassifier.LinksInfo;
import android.view.textclassifier.SmartSelection;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierConstants;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TextClassifierImpl
implements TextClassifier {
    private static final String LOG_TAG = "TextClassifierImpl";
    private static final String MODEL_DIR = "/etc/textclassifier/";
    private static final String MODEL_FILE_REGEX = "textclassifier\\.smartselection\\.(.*)\\.model";
    private static final String UPDATED_MODEL_FILE_PATH = "/data/misc/textclassifier/textclassifier.smartselection.model";
    private final Context mContext;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private final Object mSmartSelectionLock = new Object();
    @GuardedBy(value="mSmartSelectionLock")
    private Map<Locale, String> mModelFilePaths;
    @GuardedBy(value="mSmartSelectionLock")
    private Locale mLocale;
    @GuardedBy(value="mSmartSelectionLock")
    private int mVersion;
    @GuardedBy(value="mSmartSelectionLock")
    private SmartSelection mSmartSelection;
    private TextClassifierConstants mSettings;

    TextClassifierImpl(Context context) {
        this.mContext = Preconditions.checkNotNull(context);
    }

    @Override
    public TextSelection suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextClassifierImpl.validateInput(text, selectionStartIndex, selectionEndIndex);
        try {
            if (text.length() > 0) {
                int end;
                String string2;
                SmartSelection smartSelection = this.getSmartSelection(defaultLocales);
                int[] startEnd = smartSelection.suggest(string2 = text.toString(), selectionStartIndex, selectionEndIndex);
                int start = startEnd[0];
                if (start <= (end = startEnd[1]) && start >= 0 && end <= string2.length() && start <= selectionStartIndex && end >= selectionEndIndex) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end);
                    SmartSelection.ClassificationResult[] results = smartSelection.classifyText(string2, start, end, TextClassifierImpl.getHintFlags(string2, start, end));
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].mCollection, results[i].mScore);
                    }
                    return tsBuilder.setLogSource(LOG_TAG).setVersionInfo(this.getVersionInfo()).build();
                }
                Log.d(LOG_TAG, "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return TextClassifier.NO_OP.suggestSelection(text, selectionStartIndex, selectionEndIndex, defaultLocales);
    }

    @Override
    public TextClassification classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassifierImpl.validateInput(text, startIndex, endIndex);
        try {
            if (text.length() > 0) {
                String string2 = text.toString();
                SmartSelection.ClassificationResult[] results = this.getSmartSelection(defaultLocales).classifyText(string2, startIndex, endIndex, TextClassifierImpl.getHintFlags(string2, startIndex, endIndex));
                if (results.length > 0) {
                    TextClassification classificationResult = this.createClassificationResult(results, string2.subSequence(startIndex, endIndex));
                    return classificationResult;
                }
            }
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting assist info.", t);
        }
        return TextClassifier.NO_OP.classifyText(text, startIndex, endIndex, defaultLocales);
    }

    @Override
    public LinksInfo getLinks(CharSequence text, int linkMask, LocaleList defaultLocales) {
        Preconditions.checkArgument(text != null);
        try {
            return LinksInfoFactory.create(this.mContext, this.getSmartSelection(defaultLocales), text.toString(), linkMask);
        }
        catch (Throwable t) {
            Log.e(LOG_TAG, "Error getting links info.", t);
            return TextClassifier.NO_OP.getLinks(text, linkMask, defaultLocales);
        }
    }

    @Override
    public void logEvent(String source, String event) {
        if (LOG_TAG.equals(source)) {
            this.mMetricsLogger.count(event, 1);
        }
    }

    @Override
    public TextClassifierConstants getSettings() {
        if (this.mSettings == null) {
            this.mSettings = TextClassifierConstants.loadFromString(Settings.Global.getString(this.mContext.getContentResolver(), "text_classifier_constants"));
        }
        return this.mSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmartSelection getSmartSelection(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mSmartSelectionLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getEmptyLocaleList() : localeList;
            Locale locale = this.findBestSupportedLocaleLocked(localeList);
            if (locale == null) {
                throw new FileNotFoundException("No file for null locale");
            }
            if (this.mSmartSelection == null || !Objects.equals(this.mLocale, locale)) {
                this.destroySmartSelectionIfExistsLocked();
                ParcelFileDescriptor fd = this.getFdLocked(locale);
                this.mSmartSelection = new SmartSelection(fd.getFd());
                TextClassifierImpl.closeAndLogError(fd);
                this.mLocale = locale;
            }
            return this.mSmartSelection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersionInfo() {
        Object object = this.mSmartSelectionLock;
        synchronized (object) {
            if (this.mLocale != null) {
                return String.format("%s_v%d", this.mLocale.toLanguageTag(), this.mVersion);
            }
            return "";
        }
    }

    @GuardedBy(value="mSmartSelectionLock")
    private ParcelFileDescriptor getFdLocked(Locale locale) throws FileNotFoundException {
        int factoryVersion;
        ParcelFileDescriptor factoryFd;
        ParcelFileDescriptor updateFd;
        try {
            updateFd = ParcelFileDescriptor.open(new File(UPDATED_MODEL_FILE_PATH), 0x10000000);
        }
        catch (FileNotFoundException e) {
            updateFd = null;
        }
        try {
            String factoryModelFilePath = this.getFactoryModelFilePathsLocked().get(locale);
            factoryFd = factoryModelFilePath != null ? ParcelFileDescriptor.open(new File(factoryModelFilePath), 0x10000000) : null;
        }
        catch (FileNotFoundException e) {
            factoryFd = null;
        }
        if (updateFd == null) {
            if (factoryFd != null) {
                return factoryFd;
            }
            throw new FileNotFoundException(String.format("No model file found for %s", locale));
        }
        int updateFdInt = updateFd.getFd();
        boolean localeMatches = Objects.equals(locale.getLanguage().trim().toLowerCase(), SmartSelection.getLanguage(updateFdInt).trim().toLowerCase());
        if (factoryFd == null) {
            if (localeMatches) {
                return updateFd;
            }
            TextClassifierImpl.closeAndLogError(updateFd);
            throw new FileNotFoundException(String.format("No model file found for %s", locale));
        }
        if (!localeMatches) {
            TextClassifierImpl.closeAndLogError(updateFd);
            return factoryFd;
        }
        int updateVersion = SmartSelection.getVersion(updateFdInt);
        if (updateVersion > (factoryVersion = SmartSelection.getVersion(factoryFd.getFd()))) {
            TextClassifierImpl.closeAndLogError(factoryFd);
            this.mVersion = updateVersion;
            return updateFd;
        }
        TextClassifierImpl.closeAndLogError(updateFd);
        this.mVersion = factoryVersion;
        return factoryFd;
    }

    @GuardedBy(value="mSmartSelectionLock")
    private void destroySmartSelectionIfExistsLocked() {
        if (this.mSmartSelection != null) {
            this.mSmartSelection.close();
            this.mSmartSelection = null;
        }
    }

    @GuardedBy(value="mSmartSelectionLock")
    private Locale findBestSupportedLocaleLocked(LocaleList localeList) {
        String languages = localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags() + "," + LocaleList.getDefault().toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>(this.getFactoryModelFilePathsLocked().keySet());
        Locale updatedModelLocale = this.getUpdatedModelLocale();
        if (updatedModelLocale != null) {
            supportedLocales.add(updatedModelLocale);
        }
        return Locale.lookup(languageRangeList, supportedLocales);
    }

    @GuardedBy(value="mSmartSelectionLock")
    private Map<Locale, String> getFactoryModelFilePathsLocked() {
        if (this.mModelFilePaths == null) {
            HashMap<Locale, String> modelFilePaths = new HashMap<Locale, String>();
            File modelsDir = new File(MODEL_DIR);
            if (modelsDir.exists() && modelsDir.isDirectory()) {
                File[] models = modelsDir.listFiles();
                Pattern modelFilenamePattern = Pattern.compile(MODEL_FILE_REGEX);
                for (File modelFile : models) {
                    Matcher matcher = modelFilenamePattern.matcher(modelFile.getName());
                    if (!matcher.matches() || !modelFile.isFile()) continue;
                    String language = matcher.group(1);
                    Locale locale = Locale.forLanguageTag(language);
                    modelFilePaths.put(locale, modelFile.getAbsolutePath());
                }
            }
            this.mModelFilePaths = modelFilePaths;
        }
        return this.mModelFilePaths;
    }

    private Locale getUpdatedModelLocale() {
        try {
            ParcelFileDescriptor updateFd = ParcelFileDescriptor.open(new File(UPDATED_MODEL_FILE_PATH), 0x10000000);
            Locale locale = Locale.forLanguageTag(SmartSelection.getLanguage(updateFd.getFd()));
            TextClassifierImpl.closeAndLogError(updateFd);
            return locale;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private TextClassification createClassificationResult(SmartSelection.ClassificationResult[] classifications, CharSequence text) {
        ResolveInfo resolveInfo;
        PackageManager pm;
        TextClassification.Builder builder = new TextClassification.Builder().setText(text.toString());
        int size = classifications.length;
        for (int i = 0; i < size; ++i) {
            builder.setEntityType(classifications[i].mCollection, classifications[i].mScore);
        }
        String type = TextClassifierImpl.getHighestScoringType(classifications);
        builder.setLogType(IntentFactory.getLogType(type));
        Intent intent = IntentFactory.create(this.mContext, type, text.toString());
        if (intent != null) {
            pm = this.mContext.getPackageManager();
            resolveInfo = pm.resolveActivity(intent, 0);
        } else {
            pm = null;
            resolveInfo = null;
        }
        if (resolveInfo != null && resolveInfo.activityInfo != null) {
            builder.setIntent(intent).setOnClickListener(TextClassification.createStartActivityOnClickListener(this.mContext, intent));
            String packageName = resolveInfo.activityInfo.packageName;
            if ("android".equals(packageName)) {
                builder.setLabel(IntentFactory.getLabel(this.mContext, type));
            } else {
                intent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                Drawable icon = resolveInfo.activityInfo.loadIcon(pm);
                if (icon == null) {
                    icon = resolveInfo.loadIcon(pm);
                }
                builder.setIcon(icon);
                CharSequence label = resolveInfo.activityInfo.loadLabel(pm);
                if (label == null) {
                    label = resolveInfo.loadLabel(pm);
                }
                builder.setLabel(label != null ? label.toString() : null);
            }
        }
        return builder.setVersionInfo(this.getVersionInfo()).build();
    }

    private static int getHintFlags(CharSequence text, int start, int end) {
        int flag = 0;
        CharSequence subText = text.subSequence(start, end);
        if (Patterns.AUTOLINK_EMAIL_ADDRESS.matcher(subText).matches()) {
            flag |= 2;
        }
        if (Patterns.AUTOLINK_WEB_URL.matcher(subText).matches() && Linkify.sUrlMatchFilter.acceptMatch(text, start, end)) {
            flag |= 1;
        }
        return flag;
    }

    private static String getHighestScoringType(SmartSelection.ClassificationResult[] types) {
        if (types.length < 1) {
            return "";
        }
        String type = types[0].mCollection;
        float highestScore = types[0].mScore;
        int size = types.length;
        for (int i = 1; i < size; ++i) {
            if (!(types[i].mScore > highestScore)) continue;
            type = types[i].mCollection;
            highestScore = types[i].mScore;
        }
        return type;
    }

    private static void closeAndLogError(ParcelFileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e(LOG_TAG, "Error closing file.", e);
        }
    }

    private static void validateInput(CharSequence text, int startIndex, int endIndex) {
        Preconditions.checkArgument(text != null);
        Preconditions.checkArgument(startIndex >= 0);
        Preconditions.checkArgument(endIndex <= text.length());
        Preconditions.checkArgument(endIndex > startIndex);
    }

    private static final class IntentFactory {
        private IntentFactory() {
        }

        public static Intent create(Context context, String type, String text) {
            type = type.trim().toLowerCase(Locale.ENGLISH);
            text = text.trim();
            switch (type) {
                case "email": {
                    return new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text)));
                }
                case "phone": {
                    return new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text)));
                }
                case "address": {
                    return new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", text)));
                }
                case "url": {
                    String httpPrefix = "http://";
                    String httpsPrefix = "https://";
                    text = text.toLowerCase().startsWith("http://") ? "http://" + text.substring("http://".length()) : (text.toLowerCase().startsWith("https://") ? "https://" + text.substring("https://".length()) : "http://" + text);
                    return new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName());
                }
            }
            return null;
        }

        public static String getLabel(Context context, String type) {
            switch (type = type.trim().toLowerCase(Locale.ENGLISH)) {
                case "email": {
                    return context.getString(17039783);
                }
                case "phone": {
                    return context.getString(17039765);
                }
                case "address": {
                    return context.getString(17040145);
                }
                case "url": {
                    return context.getString(17039573);
                }
            }
            return null;
        }

        public static int getLogType(String type) {
            switch (type = type.trim().toLowerCase(Locale.ENGLISH)) {
                case "email": {
                    return 1;
                }
                case "phone": {
                    return 2;
                }
                case "address": {
                    return 3;
                }
                case "url": {
                    return 4;
                }
            }
            return 0;
        }
    }

    private static final class LinksInfoFactory {
        private LinksInfoFactory() {
        }

        public static LinksInfo create(Context context, SmartSelection smartSelection, String text, int linkMask) {
            int end;
            WordIterator wordIterator = new WordIterator();
            wordIterator.setCharSequence(text, 0, text.length());
            ArrayList<SpanSpec> spans = new ArrayList<SpanSpec>();
            int start = 0;
            while ((end = wordIterator.nextBoundary(start)) != -1) {
                Intent intent;
                String type;
                SmartSelection.ClassificationResult[] results;
                String token = text.substring(start, end);
                if (TextUtils.isEmpty(token)) continue;
                int[] selection = smartSelection.suggest(text, start, end);
                int selectionStart = selection[0];
                int selectionEnd = selection[1];
                if (selectionStart >= 0 && selectionEnd <= text.length() && selectionStart <= selectionEnd && (results = smartSelection.classifyText(text, selectionStart, selectionEnd, TextClassifierImpl.getHintFlags(text, selectionStart, selectionEnd))).length > 0 && LinksInfoFactory.matches(type = TextClassifierImpl.getHighestScoringType(results), linkMask) && LinksInfoFactory.hasActivityHandler(context, intent = IntentFactory.create(context, type, text.substring(selectionStart, selectionEnd)))) {
                    ClickableSpan span = LinksInfoFactory.createSpan(context, intent);
                    spans.add(new SpanSpec(selectionStart, selectionEnd, span));
                }
                start = end;
            }
            return new LinksInfoImpl(text, LinksInfoFactory.avoidOverlaps(spans, text));
        }

        private static boolean matches(String type, int linkMask) {
            type = type.trim().toLowerCase(Locale.ENGLISH);
            if ((linkMask & 4) != 0 && "phone".equals(type)) {
                return true;
            }
            if ((linkMask & 2) != 0 && "email".equals(type)) {
                return true;
            }
            if ((linkMask & 8) != 0 && "address".equals(type)) {
                return true;
            }
            return (linkMask & 1) != 0 && "url".equals(type);
        }

        private static List<SpanSpec> avoidOverlaps(List<SpanSpec> spans, String text) {
            Collections.sort(spans, Comparator.comparingInt(span -> ((SpanSpec)span).mStart));
            LinkedHashMap<Integer, SpanSpec> reps = new LinkedHashMap<Integer, SpanSpec>();
            int size = spans.size();
            for (int i = 0; i < size; ++i) {
                SpanSpec span2 = spans.get(i);
                SpanSpec rep = (SpanSpec)reps.get(span2.mStart);
                if (rep != null && rep.mEnd >= span2.mEnd) continue;
                reps.put(span2.mStart, span2);
            }
            LinkedList<SpanSpec> result = new LinkedList<SpanSpec>();
            for (SpanSpec rep : reps.values()) {
                if (result.isEmpty()) {
                    result.add(rep);
                    continue;
                }
                SpanSpec last = result.getLast();
                if (rep.mStart < last.mEnd) {
                    if (rep.mEnd - rep.mStart <= last.mEnd - last.mStart) continue;
                    result.set(result.size() - 1, rep);
                    continue;
                }
                result.add(rep);
            }
            return result;
        }

        private static ClickableSpan createSpan(final Context context, final Intent intent) {
            return new ClickableSpan(){

                @Override
                public void onClick(View widget) {
                    context.startActivity(intent);
                }
            };
        }

        private static boolean hasActivityHandler(Context context, Intent intent) {
            if (intent == null) {
                return false;
            }
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
            return resolveInfo != null && resolveInfo.activityInfo != null;
        }

        private static final class SpanSpec {
            private final int mStart;
            private final int mEnd;
            private final ClickableSpan mSpan;

            SpanSpec(int start, int end, ClickableSpan span) {
                this.mStart = start;
                this.mEnd = end;
                this.mSpan = span;
            }
        }

        private static final class LinksInfoImpl
        implements LinksInfo {
            private final CharSequence mOriginalText;
            private final List<SpanSpec> mSpans;

            LinksInfoImpl(CharSequence originalText, List<SpanSpec> spans) {
                this.mOriginalText = originalText;
                this.mSpans = spans;
            }

            @Override
            public boolean apply(CharSequence text) {
                Preconditions.checkArgument(text != null);
                if (text instanceof Spannable && this.mOriginalText.toString().equals(text.toString())) {
                    Spannable spannable = (Spannable)text;
                    int size = this.mSpans.size();
                    for (int i = 0; i < size; ++i) {
                        SpanSpec span = this.mSpans.get(i);
                        spannable.setSpan(span.mSpan, span.mStart, span.mEnd, 0);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

