/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.content.res.Resources;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

public class DateSorter {
    private static final String LOGTAG = "webkit";
    public static final int DAY_COUNT = 5;
    private long[] mBins = new long[4];
    private String[] mLabels = new String[5];
    private static final int NUM_DAYS_AGO = 7;

    public DateSorter(Context context) {
        Resources resources = context.getResources();
        Calendar c = Calendar.getInstance();
        this.beginningOfDay(c);
        this.mBins[0] = c.getTimeInMillis();
        c.add(6, -1);
        this.mBins[1] = c.getTimeInMillis();
        c.add(6, -6);
        this.mBins[2] = c.getTimeInMillis();
        c.add(6, 7);
        c.add(2, -1);
        this.mBins[3] = c.getTimeInMillis();
        Locale locale = resources.getConfiguration().locale;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        LocaleData localeData = LocaleData.get(locale);
        this.mLabels[0] = localeData.today;
        this.mLabels[1] = localeData.yesterday;
        int resId = 18153490;
        String format = resources.getQuantityString(resId, 7);
        this.mLabels[2] = String.format(format, 7);
        this.mLabels[3] = context.getString(17040065);
        this.mLabels[4] = context.getString(17040326);
    }

    public int getIndex(long time) {
        int lastDay = 4;
        for (int i = 0; i < lastDay; ++i) {
            if (time <= this.mBins[i]) continue;
            return i;
        }
        return lastDay;
    }

    public String getLabel(int index) {
        if (index < 0 || index >= 5) {
            return "";
        }
        return this.mLabels[index];
    }

    public long getBoundary(int index) {
        int lastDay = 4;
        if (index < 0 || index > lastDay) {
            index = 0;
        }
        if (index == lastDay) {
            return Long.MIN_VALUE;
        }
        return this.mBins[index];
    }

    private void beginningOfDay(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }
}

