/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.widget.AutoScrollHelper;

public class DropDownListView
extends ListView {
    private boolean mListSelectionHidden;
    private boolean mHijackFocus;
    private boolean mDrawsInPressedState;
    private AutoScrollHelper.AbsListViewAutoScroller mScrollHelper;
    private ResolveHoverRunnable mResolveHoverRunnable;

    public DropDownListView(Context context, boolean hijackFocus) {
        this(context, hijackFocus, 16842861);
    }

    public DropDownListView(Context context, boolean hijackFocus, int defStyleAttr) {
        super(context, null, defStyleAttr);
        this.mHijackFocus = hijackFocus;
        this.setCacheColorHint(0);
    }

    @Override
    boolean shouldShowSelector() {
        return this.isHovered() || super.shouldShowSelector();
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mResolveHoverRunnable != null) {
            this.mResolveHoverRunnable.cancel();
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public boolean onHoverEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        if (action == 10 && this.mResolveHoverRunnable == null) {
            this.mResolveHoverRunnable = new ResolveHoverRunnable();
            this.mResolveHoverRunnable.post();
        }
        boolean handled = super.onHoverEvent(ev);
        if (action == 9 || action == 7) {
            int position = this.pointToPosition((int)ev.getX(), (int)ev.getY());
            if (position != -1 && position != this.mSelectedPosition) {
                View hoveredItem = this.getChildAt(position - this.getFirstVisiblePosition());
                if (hoveredItem.isEnabled()) {
                    this.requestFocus();
                    this.positionSelector(position, hoveredItem);
                    this.setSelectedPositionInt(position);
                    this.setNextSelectedPositionInt(position);
                }
                this.updateSelectorState();
            }
        } else if (!super.shouldShowSelector()) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
        }
        return handled;
    }

    @Override
    protected void drawableStateChanged() {
        if (this.mResolveHoverRunnable == null) {
            super.drawableStateChanged();
        }
    }

    public boolean onForwardedEvent(MotionEvent event, int activePointerId) {
        boolean handledEvent = true;
        boolean clearPressedItem = false;
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 3: {
                handledEvent = false;
                break;
            }
            case 1: {
                handledEvent = false;
            }
            case 2: {
                int y;
                int activeIndex = event.findPointerIndex(activePointerId);
                if (activeIndex < 0) {
                    handledEvent = false;
                    break;
                }
                int x = (int)event.getX(activeIndex);
                int position = this.pointToPosition(x, y = (int)event.getY(activeIndex));
                if (position == -1) {
                    clearPressedItem = true;
                    break;
                }
                View child = this.getChildAt(position - this.getFirstVisiblePosition());
                this.setPressedItem(child, position, x, y);
                handledEvent = true;
                if (actionMasked != 1) break;
                long id2 = this.getItemIdAtPosition(position);
                this.performItemClick(child, position, id2);
            }
        }
        if (!handledEvent || clearPressedItem) {
            this.clearPressedItem();
        }
        if (handledEvent) {
            if (this.mScrollHelper == null) {
                this.mScrollHelper = new AutoScrollHelper.AbsListViewAutoScroller(this);
            }
            this.mScrollHelper.setEnabled(true);
            this.mScrollHelper.onTouch(this, event);
        } else if (this.mScrollHelper != null) {
            this.mScrollHelper.setEnabled(false);
        }
        return handledEvent;
    }

    public void setListSelectionHidden(boolean hideListSelection) {
        this.mListSelectionHidden = hideListSelection;
    }

    private void clearPressedItem() {
        this.mDrawsInPressedState = false;
        this.setPressed(false);
        this.updateSelectorState();
        View motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
        if (motionView != null) {
            motionView.setPressed(false);
        }
    }

    private void setPressedItem(View child, int position, float x, float y) {
        View motionView;
        this.mDrawsInPressedState = true;
        this.drawableHotspotChanged(x, y);
        if (!this.isPressed()) {
            this.setPressed(true);
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        if ((motionView = this.getChildAt(this.mMotionPosition - this.mFirstPosition)) != null && motionView != child && motionView.isPressed()) {
            motionView.setPressed(false);
        }
        this.mMotionPosition = position;
        float childX = x - (float)child.getLeft();
        float childY = y - (float)child.getTop();
        child.drawableHotspotChanged(childX, childY);
        if (!child.isPressed()) {
            child.setPressed(true);
        }
        this.setSelectedPositionInt(position);
        this.positionSelectorLikeTouch(position, child, x, y);
        this.refreshDrawableState();
    }

    @Override
    boolean touchModeDrawsInPressedState() {
        return this.mDrawsInPressedState || super.touchModeDrawsInPressedState();
    }

    @Override
    View obtainView(int position, boolean[] isScrap) {
        View view = super.obtainView(position, isScrap);
        if (view instanceof TextView) {
            ((TextView)view).setHorizontallyScrolling(true);
        }
        return view;
    }

    @Override
    public boolean isInTouchMode() {
        return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
    }

    @Override
    public boolean hasWindowFocus() {
        return this.mHijackFocus || super.hasWindowFocus();
    }

    @Override
    public boolean isFocused() {
        return this.mHijackFocus || super.isFocused();
    }

    @Override
    public boolean hasFocus() {
        return this.mHijackFocus || super.hasFocus();
    }

    private class ResolveHoverRunnable
    implements Runnable {
        private ResolveHoverRunnable() {
        }

        @Override
        public void run() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.drawableStateChanged();
        }

        public void cancel() {
            DropDownListView.this.mResolveHoverRunnable = null;
            DropDownListView.this.removeCallbacks(this);
        }

        public void post() {
            DropDownListView.this.post(this);
        }
    }
}

