/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.appwidget.AppWidgetHostView;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.ImageView;
import android.widget.RemoteViewsAdapter;
import android.widget.RemoteViewsListAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.NotificationColorUtil;
import com.android.internal.util.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.Executor;
import libcore.util.Objects;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    private static final String LOG_TAG = "RemoteViews";
    static final String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    private static final int MAX_NESTED_VIEWS = 10;
    private static final int SET_ON_CLICK_PENDING_INTENT_TAG = 1;
    private static final int REFLECTION_ACTION_TAG = 2;
    private static final int SET_DRAWABLE_PARAMETERS_TAG = 3;
    private static final int VIEW_GROUP_ACTION_ADD_TAG = 4;
    private static final int SET_REFLECTION_ACTION_WITHOUT_PARAMS_TAG = 5;
    private static final int SET_EMPTY_VIEW_ACTION_TAG = 6;
    private static final int VIEW_GROUP_ACTION_REMOVE_TAG = 7;
    private static final int SET_PENDING_INTENT_TEMPLATE_TAG = 8;
    private static final int SET_ON_CLICK_FILL_IN_INTENT_TAG = 9;
    private static final int SET_REMOTE_VIEW_ADAPTER_INTENT_TAG = 10;
    private static final int TEXT_VIEW_DRAWABLE_ACTION_TAG = 11;
    private static final int BITMAP_REFLECTION_ACTION_TAG = 12;
    private static final int TEXT_VIEW_SIZE_ACTION_TAG = 13;
    private static final int VIEW_PADDING_ACTION_TAG = 14;
    private static final int SET_REMOTE_VIEW_ADAPTER_LIST_TAG = 15;
    private static final int TEXT_VIEW_DRAWABLE_COLOR_FILTER_ACTION_TAG = 17;
    private static final int SET_REMOTE_INPUTS_ACTION_TAG = 18;
    private static final int LAYOUT_PARAM_ACTION_TAG = 19;
    private static final int OVERRIDE_TEXT_COLORS_TAG = 20;
    private ApplicationInfo mApplication;
    private final int mLayoutId;
    private ArrayList<Action> mActions;
    private MemoryUsageCounter mMemoryUsageCounter;
    private BitmapCache mBitmapCache;
    private boolean mIsRoot = true;
    private boolean mReapplyDisallowed;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private RemoteViews mLandscape = null;
    private RemoteViews mPortrait = null;
    private boolean mIsWidgetCollectionChild = false;
    private static final OnClickHandler DEFAULT_ON_CLICK_HANDLER = new OnClickHandler();
    private static final Object[] sMethodsLock = new Object[0];
    private static final ArrayMap<Class<? extends View>, ArrayMap<MutablePair<String, Class<?>>, Method>> sMethods = new ArrayMap();
    private static final ArrayMap<Method, Method> sAsyncMethods = new ArrayMap();
    private static final ThreadLocal<Object[]> sInvokeArgsTls = new ThreadLocal<Object[]>(){

        @Override
        protected Object[] initialValue() {
            return new Object[1];
        }
    };
    private final MutablePair<String, Class<?>> mPair = new MutablePair<Object, Object>(null, null);
    private static final Action ACTION_NOOP = new RuntimeAction(){

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
        }
    };
    public static final Parcelable.Creator<RemoteViews> CREATOR = new Parcelable.Creator<RemoteViews>(){

        @Override
        public RemoteViews createFromParcel(Parcel parcel) {
            return new RemoteViews(parcel);
        }

        public RemoteViews[] newArray(int size) {
            return new RemoteViews[size];
        }
    };

    public void setRemoteInputs(int viewId, RemoteInput[] remoteInputs) {
        this.mActions.add(new SetRemoteInputsAction(viewId, remoteInputs));
    }

    public void reduceImageSizes(int maxWidth, int maxHeight) {
        ArrayList<Bitmap> cache = this.mBitmapCache.mBitmaps;
        for (int i = 0; i < cache.size(); ++i) {
            Bitmap bitmap = cache.get(i);
            cache.set(i, Icon.scaleDownIfNecessary(bitmap, maxWidth, maxHeight));
        }
    }

    public void overrideTextColors(int textColor) {
        this.addAction(new OverrideTextColorsAction(textColor));
    }

    public void setReapplyDisallowed() {
        this.mReapplyDisallowed = true;
    }

    public boolean isReapplyDisallowed() {
        return this.mReapplyDisallowed;
    }

    public void mergeRemoteViews(RemoteViews newRv) {
        if (newRv == null) {
            return;
        }
        RemoteViews copy = newRv.clone();
        HashMap<String, Action> map = new HashMap<String, Action>();
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        int count = this.mActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            map.put(a.getUniqueKey(), a);
        }
        ArrayList<Action> newActions = copy.mActions;
        if (newActions == null) {
            return;
        }
        count = newActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = newActions.get(i);
            String key = newActions.get(i).getUniqueKey();
            int mergeBehavior = newActions.get(i).mergeBehavior();
            if (map.containsKey(key) && mergeBehavior == 0) {
                this.mActions.remove(map.get(key));
                map.remove(key);
            }
            if (mergeBehavior != 0 && mergeBehavior != 1) continue;
            this.mActions.add(a);
        }
        this.mBitmapCache = new BitmapCache();
        this.setBitmapCache(this.mBitmapCache);
        this.recalculateMemoryUsage();
    }

    private static Rect getSourceBounds(View v) {
        float appScale = v.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        Rect rect = new Rect();
        rect.left = (int)((float)pos[0] * appScale + 0.5f);
        rect.top = (int)((float)pos[1] * appScale + 0.5f);
        rect.right = (int)((float)(pos[0] + v.getWidth()) * appScale + 0.5f);
        rect.bottom = (int)((float)(pos[1] + v.getHeight()) * appScale + 0.5f);
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getMethod(View view, String methodName, Class<?> paramType) {
        Class<?> klass = view.getClass();
        Object[] objectArray = sMethodsLock;
        synchronized (sMethodsLock) {
            ArrayMap<MutablePair<String, Class<Object>>, Method> methods = sMethods.get(klass);
            if (methods == null) {
                methods = new ArrayMap();
                sMethods.put(klass, methods);
            }
            this.mPair.first = methodName;
            this.mPair.second = paramType;
            Method method = methods.get(this.mPair);
            if (method == null) {
                try {
                    method = paramType == null ? klass.getMethod(methodName, new Class[0]) : klass.getMethod(methodName, paramType);
                }
                catch (NoSuchMethodException ex) {
                    throw new ActionException("view: " + klass.getName() + " doesn't have method: " + methodName + RemoteViews.getParameters(paramType));
                }
                if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                    throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + methodName + RemoteViews.getParameters(paramType));
                }
                methods.put(new MutablePair(methodName, paramType), method);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return method;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method getAsyncMethod(Method method) {
        ArrayMap<Method, Method> arrayMap = sAsyncMethods;
        synchronized (arrayMap) {
            int valueIndex = sAsyncMethods.indexOfKey(method);
            if (valueIndex >= 0) {
                return sAsyncMethods.valueAt(valueIndex);
            }
            RemotableViewMethod annotation = method.getAnnotation(RemotableViewMethod.class);
            Method asyncMethod = null;
            if (!annotation.asyncImpl().isEmpty()) {
                try {
                    asyncMethod = method.getDeclaringClass().getMethod(annotation.asyncImpl(), method.getParameterTypes());
                    if (!asyncMethod.getReturnType().equals(Runnable.class)) {
                        throw new ActionException("Async implementation for " + method.getName() + " does not return a Runnable");
                    }
                }
                catch (NoSuchMethodException ex) {
                    throw new ActionException("Async implementation declared but not defined for " + method.getName());
                }
            }
            sAsyncMethods.put(method, asyncMethod);
            return asyncMethod;
        }
    }

    private static String getParameters(Class<?> paramType) {
        if (paramType == null) {
            return "()";
        }
        return "(" + paramType + ")";
    }

    private static Object[] wrapArg(Object value) {
        Object[] args = sInvokeArgsTls.get();
        args[0] = value;
        return args;
    }

    private void configureRemoteViewsAsChild(RemoteViews rv) {
        this.mBitmapCache.assimilate(rv.mBitmapCache);
        rv.setBitmapCache(this.mBitmapCache);
        rv.setNotRoot();
    }

    void setNotRoot() {
        this.mIsRoot = false;
    }

    public RemoteViews(String packageName, int layoutId) {
        this(RemoteViews.getApplicationInfo(packageName, UserHandle.myUserId()), layoutId);
    }

    public RemoteViews(String packageName, int userId, int layoutId) {
        this(RemoteViews.getApplicationInfo(packageName, userId), layoutId);
    }

    protected RemoteViews(ApplicationInfo application, int layoutId) {
        this.mApplication = application;
        this.mLayoutId = layoutId;
        this.mBitmapCache = new BitmapCache();
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.recalculateMemoryUsage();
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    public RemoteViews(RemoteViews landscape, RemoteViews portrait) {
        if (landscape == null || portrait == null) {
            throw new RuntimeException("Both RemoteViews must be non-null");
        }
        if (landscape.mApplication.uid != portrait.mApplication.uid || !landscape.mApplication.packageName.equals(portrait.mApplication.packageName)) {
            throw new RuntimeException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = portrait.mApplication;
        this.mLayoutId = portrait.getLayoutId();
        this.mLandscape = landscape;
        this.mPortrait = portrait;
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.mBitmapCache = new BitmapCache();
        this.configureRemoteViewsAsChild(landscape);
        this.configureRemoteViewsAsChild(portrait);
        this.recalculateMemoryUsage();
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null, null, 0);
    }

    private RemoteViews(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo info, int depth) {
        if (depth > 10 && UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new IllegalArgumentException("Too many nested views.");
        }
        ++depth;
        int mode = parcel.readInt();
        if (bitmapCache == null) {
            this.mBitmapCache = new BitmapCache(parcel);
        } else {
            this.setBitmapCache(bitmapCache);
            this.setNotRoot();
        }
        if (mode == 0) {
            this.mApplication = parcel.readInt() == 0 ? info : ApplicationInfo.CREATOR.createFromParcel(parcel);
            this.mLayoutId = parcel.readInt();
            this.mIsWidgetCollectionChild = parcel.readInt() == 1;
            int count = parcel.readInt();
            if (count > 0) {
                this.mActions = new ArrayList(count);
                block21: for (int i = 0; i < count; ++i) {
                    int tag = parcel.readInt();
                    switch (tag) {
                        case 1: {
                            this.mActions.add(new SetOnClickPendingIntent(parcel));
                            continue block21;
                        }
                        case 3: {
                            this.mActions.add(new SetDrawableParameters(parcel));
                            continue block21;
                        }
                        case 2: {
                            this.mActions.add(new ReflectionAction(parcel));
                            continue block21;
                        }
                        case 4: {
                            this.mActions.add(new ViewGroupActionAdd(parcel, this.mBitmapCache, this.mApplication, depth));
                            continue block21;
                        }
                        case 7: {
                            this.mActions.add(new ViewGroupActionRemove(parcel));
                            continue block21;
                        }
                        case 5: {
                            this.mActions.add(new ReflectionActionWithoutParams(parcel));
                            continue block21;
                        }
                        case 6: {
                            this.mActions.add(new SetEmptyView(parcel));
                            continue block21;
                        }
                        case 8: {
                            this.mActions.add(new SetPendingIntentTemplate(parcel));
                            continue block21;
                        }
                        case 9: {
                            this.mActions.add(new SetOnClickFillInIntent(parcel));
                            continue block21;
                        }
                        case 10: {
                            this.mActions.add(new SetRemoteViewsAdapterIntent(parcel));
                            continue block21;
                        }
                        case 11: {
                            this.mActions.add(new TextViewDrawableAction(parcel));
                            continue block21;
                        }
                        case 13: {
                            this.mActions.add(new TextViewSizeAction(parcel));
                            continue block21;
                        }
                        case 14: {
                            this.mActions.add(new ViewPaddingAction(parcel));
                            continue block21;
                        }
                        case 12: {
                            this.mActions.add(new BitmapReflectionAction(parcel));
                            continue block21;
                        }
                        case 15: {
                            this.mActions.add(new SetRemoteViewsAdapterList(parcel));
                            continue block21;
                        }
                        case 17: {
                            this.mActions.add(new TextViewDrawableColorFilterAction(parcel));
                            continue block21;
                        }
                        case 18: {
                            this.mActions.add(new SetRemoteInputsAction(parcel));
                            continue block21;
                        }
                        case 19: {
                            this.mActions.add(new LayoutParamAction(parcel));
                            continue block21;
                        }
                        case 20: {
                            this.mActions.add(new OverrideTextColorsAction(parcel));
                            continue block21;
                        }
                        default: {
                            throw new ActionException("Tag " + tag + " not found");
                        }
                    }
                }
            }
        } else {
            this.mLandscape = new RemoteViews(parcel, this.mBitmapCache, info, depth);
            this.mPortrait = new RemoteViews(parcel, this.mBitmapCache, this.mLandscape.mApplication, depth);
            this.mApplication = this.mPortrait.mApplication;
            this.mLayoutId = this.mPortrait.getLayoutId();
        }
        this.mReapplyDisallowed = parcel.readInt() == 0;
        this.mMemoryUsageCounter = new MemoryUsageCounter();
        this.recalculateMemoryUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViews clone() {
        RemoteViews remoteViews = this;
        synchronized (remoteViews) {
            Preconditions.checkState(this.mIsRoot, "RemoteView has been attached to another RemoteView. May only clone the root of a RemoteView hierarchy.");
            Parcel p = Parcel.obtain();
            this.mIsRoot = false;
            this.writeToParcel(p, 2);
            p.setDataPosition(0);
            this.mIsRoot = true;
            RemoteViews rv = new RemoteViews(p, this.mBitmapCache.clone(), this.mApplication, 0);
            rv.mIsRoot = true;
            p.recycle();
            return rv;
        }
    }

    public String getPackage() {
        return this.mApplication != null ? this.mApplication.packageName : null;
    }

    public int getLayoutId() {
        return this.mLayoutId;
    }

    void setIsWidgetCollectionChild(boolean isWidgetCollectionChild) {
        this.mIsWidgetCollectionChild = isWidgetCollectionChild;
    }

    private void recalculateMemoryUsage() {
        this.mMemoryUsageCounter.clear();
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int count = this.mActions.size();
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).updateMemoryUsageEstimate(this.mMemoryUsageCounter);
                }
            }
            if (this.mIsRoot) {
                this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
            }
        } else {
            this.mMemoryUsageCounter.increment(this.mLandscape.estimateMemoryUsage());
            this.mMemoryUsageCounter.increment(this.mPortrait.estimateMemoryUsage());
            this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
        }
    }

    private void setBitmapCache(BitmapCache bitmapCache) {
        this.mBitmapCache = bitmapCache;
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int count = this.mActions.size();
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).setBitmapCache(bitmapCache);
                }
            }
        } else {
            this.mLandscape.setBitmapCache(bitmapCache);
            this.mPortrait.setBitmapCache(bitmapCache);
        }
    }

    public int estimateMemoryUsage() {
        return this.mMemoryUsageCounter.getMemoryUsage();
    }

    private void addAction(Action a) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate landscape and portrait layouts cannot be modified. Instead, fully configure the landscape and portrait layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
        a.updateMemoryUsageEstimate(this.mMemoryUsageCounter);
    }

    public void addView(int viewId, RemoteViews nestedView) {
        this.addAction(nestedView == null ? new ViewGroupActionRemove(viewId) : new ViewGroupActionAdd(viewId, nestedView));
    }

    public void addView(int viewId, RemoteViews nestedView, int index) {
        this.addAction(new ViewGroupActionAdd(viewId, nestedView, index));
    }

    public void removeAllViews(int viewId) {
        this.addAction(new ViewGroupActionRemove(viewId));
    }

    public void removeAllViewsExceptId(int viewId, int viewIdToKeep) {
        this.addAction(new ViewGroupActionRemove(viewId, viewIdToKeep));
    }

    public void showNext(int viewId) {
        this.addAction(new ReflectionActionWithoutParams(viewId, "showNext"));
    }

    public void showPrevious(int viewId) {
        this.addAction(new ReflectionActionWithoutParams(viewId, "showPrevious"));
    }

    public void setDisplayedChild(int viewId, int childIndex) {
        this.setInt(viewId, "setDisplayedChild", childIndex);
    }

    public void setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    public void setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    public void setTextViewTextSize(int viewId, int units, float size) {
        this.addAction(new TextViewSizeAction(viewId, units, size));
    }

    public void setTextViewCompoundDrawables(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, int start, int top, int end, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setTextViewCompoundDrawablesRelativeColorFilter(int viewId, int index, int color2, PorterDuff.Mode mode) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException("index must be in range [0, 3].");
        }
        this.addAction(new TextViewDrawableColorFilterAction(viewId, true, index, color2, mode));
    }

    public void setTextViewCompoundDrawables(int viewId, Icon left, Icon top, Icon right, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, Icon start, Icon top, Icon end, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    public void setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    public void setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    public void setImageViewIcon(int viewId, Icon icon) {
        this.setIcon(viewId, "setImageIcon", icon);
    }

    public void setEmptyView(int viewId, int emptyViewId) {
        this.addAction(new SetEmptyView(viewId, emptyViewId));
    }

    public void setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    public void setChronometerCountDown(int viewId, boolean isCountDown) {
        this.setBoolean(viewId, "setCountDown", isCountDown);
    }

    public void setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    public void setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.addAction(new SetOnClickPendingIntent(viewId, pendingIntent));
    }

    public void setPendingIntentTemplate(int viewId, PendingIntent pendingIntentTemplate) {
        this.addAction(new SetPendingIntentTemplate(viewId, pendingIntentTemplate));
    }

    public void setOnClickFillInIntent(int viewId, Intent fillInIntent) {
        this.addAction(new SetOnClickFillInIntent(viewId, fillInIntent));
    }

    public void setDrawableParameters(int viewId, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
        this.addAction(new SetDrawableParameters(viewId, targetBackground, alpha, colorFilter, mode, level));
    }

    public void setProgressTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressTintList", 15, tint));
    }

    public void setProgressBackgroundTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressBackgroundTintList", 15, tint));
    }

    public void setProgressIndeterminateTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setIndeterminateTintList", 15, tint));
    }

    public void setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    public void setTextColor(int viewId, ColorStateList colors) {
        this.addAction(new ReflectionAction(viewId, "setTextColor", 15, colors));
    }

    @Deprecated
    public void setRemoteAdapter(int appWidgetId, int viewId, Intent intent) {
        this.setRemoteAdapter(viewId, intent);
    }

    public void setRemoteAdapter(int viewId, Intent intent) {
        this.addAction(new SetRemoteViewsAdapterIntent(viewId, intent));
    }

    public void setRemoteAdapter(int viewId, ArrayList<RemoteViews> list, int viewTypeCount) {
        this.addAction(new SetRemoteViewsAdapterList(viewId, list, viewTypeCount));
    }

    public void setScrollPosition(int viewId, int position) {
        this.setInt(viewId, "smoothScrollToPosition", position);
    }

    public void setRelativeScrollPosition(int viewId, int offset) {
        this.setInt(viewId, "smoothScrollByOffset", offset);
    }

    public void setViewPadding(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new ViewPaddingAction(viewId, left, top, right, bottom));
    }

    public void setViewLayoutMarginEndDimen(int viewId, int endMarginDimen) {
        this.addAction(new LayoutParamAction(viewId, 1, endMarginDimen));
    }

    public void setViewLayoutMarginBottomDimen(int viewId, int bottomMarginDimen) {
        this.addAction(new LayoutParamAction(viewId, 3, bottomMarginDimen));
    }

    public void setViewLayoutWidth(int viewId, int layoutWidth) {
        if (layoutWidth != 0 && layoutWidth != -1 && layoutWidth != -2) {
            throw new IllegalArgumentException("Only supports 0, WRAP_CONTENT and MATCH_PARENT");
        }
        this.mActions.add(new LayoutParamAction(viewId, 2, layoutWidth));
    }

    public void setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(viewId, methodName, 1, value));
    }

    public void setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(viewId, methodName, 2, value));
    }

    public void setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(viewId, methodName, 3, value));
    }

    public void setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(viewId, methodName, 4, value));
    }

    public void setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(viewId, methodName, 5, value));
    }

    public void setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(viewId, methodName, 6, Float.valueOf(value)));
    }

    public void setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(viewId, methodName, 7, value));
    }

    public void setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(viewId, methodName, 8, Character.valueOf(value)));
    }

    public void setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(viewId, methodName, 9, value));
    }

    public void setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(viewId, methodName, 10, value));
    }

    public void setUri(int viewId, String methodName, Uri value) {
        if (value != null) {
            value = value.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                value.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(viewId, methodName, 11, value));
    }

    public void setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new BitmapReflectionAction(viewId, methodName, value));
    }

    public void setBundle(int viewId, String methodName, Bundle value) {
        this.addAction(new ReflectionAction(viewId, methodName, 13, value));
    }

    public void setIntent(int viewId, String methodName, Intent value) {
        this.addAction(new ReflectionAction(viewId, methodName, 14, value));
    }

    public void setIcon(int viewId, String methodName, Icon value) {
        this.addAction(new ReflectionAction(viewId, methodName, 16, value));
    }

    public void setContentDescription(int viewId, CharSequence contentDescription) {
        this.setCharSequence(viewId, "setContentDescription", contentDescription);
    }

    public void setAccessibilityTraversalBefore(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalBefore", nextId);
    }

    public void setAccessibilityTraversalAfter(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalAfter", nextId);
    }

    public void setLabelFor(int viewId, int labeledId) {
        this.setInt(viewId, "setLabelFor", labeledId);
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                return this.mLandscape;
            }
            return this.mPortrait;
        }
        return this;
    }

    public View apply(Context context, ViewGroup parent) {
        return this.apply(context, parent, null);
    }

    public View apply(Context context, ViewGroup parent, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        View result = this.inflateView(context, rvToApply, parent);
        RemoteViews.loadTransitionOverride(context, handler);
        rvToApply.performApply(result, parent, handler);
        return result;
    }

    private View inflateView(Context context, RemoteViews rv, ViewGroup parent) {
        Context contextForResources = this.getContextForResources(context);
        RemoteViewsContextWrapper inflationContext = new RemoteViewsContextWrapper(context, contextForResources);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater = inflater.cloneInContext(inflationContext);
        inflater.setFilter(this);
        View v = inflater.inflate(rv.getLayoutId(), parent, false);
        v.setTagInternal(16908312, rv.getLayoutId());
        return v;
    }

    private static void loadTransitionOverride(Context context, OnClickHandler handler) {
        if (handler != null && context.getResources().getBoolean(17956989)) {
            TypedArray windowStyle = context.getTheme().obtainStyledAttributes(R.styleable.Window);
            int windowAnimations = windowStyle.getResourceId(8, 0);
            TypedArray windowAnimationStyle = context.obtainStyledAttributes(windowAnimations, R.styleable.WindowAnimation);
            handler.setEnterAnimationId(windowAnimationStyle.getResourceId(26, 0));
            windowStyle.recycle();
            windowAnimationStyle.recycle();
        }
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener) {
        return this.applyAsync(context, parent, executor, listener, null);
    }

    private CancellationSignal startTaskOnExecutor(AsyncApplyTask task, Executor executor) {
        CancellationSignal cancelSignal = new CancellationSignal();
        cancelSignal.setOnCancelListener(task);
        task.executeOnExecutor(executor == null ? AsyncTask.THREAD_POOL_EXECUTOR : executor, new Void[0]);
        return cancelSignal;
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, OnClickHandler handler) {
        return this.startTaskOnExecutor(this.getAsyncApplyTask(context, parent, listener, handler), executor);
    }

    private AsyncApplyTask getAsyncApplyTask(Context context, ViewGroup parent, OnViewAppliedListener listener, OnClickHandler handler) {
        return new AsyncApplyTask(this.getRemoteViewsToApply(context), parent, context, listener, handler, null);
    }

    public void reapply(Context context, View v) {
        this.reapply(context, v, null);
    }

    public void reapply(Context context, View v, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && ((Integer)v.getTag(16908312)).intValue() != rvToApply.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        rvToApply.performApply(v, (ViewGroup)v.getParent(), handler);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener) {
        return this.reapplyAsync(context, v, executor, listener, null);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && ((Integer)v.getTag(16908312)).intValue() != rvToApply.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        return this.startTaskOnExecutor(new AsyncApplyTask(rvToApply, (ViewGroup)v.getParent(), context, listener, handler, v), executor);
    }

    private void performApply(View v, ViewGroup parent, OnClickHandler handler) {
        if (this.mActions != null) {
            handler = handler == null ? DEFAULT_ON_CLICK_HANDLER : handler;
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.apply(v, parent, handler);
            }
        }
    }

    public boolean prefersAsyncApply() {
        if (this.mActions != null) {
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mActions.get(i).prefersAsyncApply()) continue;
                return true;
            }
        }
        return false;
    }

    private Context getContextForResources(Context context) {
        if (this.mApplication != null) {
            if (context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
                return context;
            }
            try {
                return context.createApplicationContext(this.mApplication, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Package name " + this.mApplication.packageName + " not found");
            }
        }
        return context;
    }

    public int getSequenceNumber() {
        return this.mActions == null ? 0 : this.mActions.size();
    }

    @Override
    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (!this.hasLandscapeAndPortraitLayouts()) {
            dest.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            if (!this.mIsRoot && (flags & 2) != 0) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mApplication.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mLayoutId);
            dest.writeInt(this.mIsWidgetCollectionChild ? 1 : 0);
            int count = this.mActions != null ? this.mActions.size() : 0;
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                Action a;
                a.writeToParcel(dest, (a = this.mActions.get(i)).hasSameAppInfo(this.mApplication) ? 2 : 0);
            }
        } else {
            dest.writeInt(1);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            this.mLandscape.writeToParcel(dest, flags);
            this.mPortrait.writeToParcel(dest, flags | 2);
        }
        dest.writeInt(this.mReapplyDisallowed ? 1 : 0);
    }

    private static ApplicationInfo getApplicationInfo(String packageName, int userId) {
        if (packageName == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) != userId || !applicationInfo.packageName.equals(packageName)) {
            try {
                Context context = application.getBaseContext().createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                applicationInfo = context.getApplicationInfo();
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                throw new IllegalArgumentException("No such package " + packageName);
            }
        }
        return applicationInfo;
    }

    private static class ViewTree {
        private static final int INSERT_AT_END_INDEX = -1;
        private View mRoot;
        private ArrayList<ViewTree> mChildren;

        private ViewTree(View root) {
            this.mRoot = root;
        }

        public void createTree() {
            if (this.mChildren != null) {
                return;
            }
            this.mChildren = new ArrayList();
            if (this.mRoot instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)this.mRoot;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    this.addViewChild(vg.getChildAt(i));
                }
            }
        }

        public ViewTree findViewTreeById(int id2) {
            if (this.mRoot.getId() == id2) {
                return this;
            }
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                ViewTree result = tree.findViewTreeById(id2);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void replaceView(View v) {
            this.mRoot = v;
            this.mChildren = null;
            this.createTree();
        }

        public <T extends View> T findViewById(int id2) {
            if (this.mChildren == null) {
                return this.mRoot.findViewById(id2);
            }
            ViewTree tree = this.findViewTreeById(id2);
            return (T)(tree == null ? null : tree.mRoot);
        }

        public void addChild(ViewTree child) {
            this.addChild(child, -1);
        }

        public void addChild(ViewTree child, int index) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
            child.createTree();
            if (index == -1) {
                this.mChildren.add(child);
                return;
            }
            this.mChildren.add(index, child);
        }

        private void addViewChild(View v) {
            ViewTree target;
            if (v.isRootNamespace()) {
                return;
            }
            if (v.getId() != 0) {
                ViewTree tree = new ViewTree(v);
                this.mChildren.add(tree);
                target = tree;
            } else {
                target = this;
            }
            if (v instanceof ViewGroup && target.mChildren == null) {
                target.mChildren = new ArrayList();
                ViewGroup vg = (ViewGroup)v;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    target.addViewChild(vg.getChildAt(i));
                }
            }
        }
    }

    private class AsyncApplyTask
    extends AsyncTask<Void, Void, ViewTree>
    implements CancellationSignal.OnCancelListener {
        final RemoteViews mRV;
        final ViewGroup mParent;
        final Context mContext;
        final OnViewAppliedListener mListener;
        final OnClickHandler mHandler;
        private View mResult;
        private ViewTree mTree;
        private Action[] mActions;
        private Exception mError;

        private AsyncApplyTask(RemoteViews rv, ViewGroup parent, Context context, OnViewAppliedListener listener, OnClickHandler handler, View result) {
            this.mRV = rv;
            this.mParent = parent;
            this.mContext = context;
            this.mListener = listener;
            this.mHandler = handler;
            this.mResult = result;
            RemoteViews.loadTransitionOverride(context, handler);
        }

        protected ViewTree doInBackground(Void ... params) {
            try {
                if (this.mResult == null) {
                    this.mResult = RemoteViews.this.inflateView(this.mContext, this.mRV, this.mParent);
                }
                this.mTree = new ViewTree(this.mResult);
                if (this.mRV.mActions != null) {
                    int count = this.mRV.mActions.size();
                    this.mActions = new Action[count];
                    for (int i = 0; i < count && !this.isCancelled(); ++i) {
                        this.mActions[i] = ((Action)this.mRV.mActions.get(i)).initActionAsync(this.mTree, this.mParent, this.mHandler);
                    }
                } else {
                    this.mActions = null;
                }
                return this.mTree;
            }
            catch (Exception e) {
                this.mError = e;
                return null;
            }
        }

        @Override
        protected void onPostExecute(ViewTree viewTree) {
            if (this.mError == null) {
                try {
                    if (this.mActions != null) {
                        OnClickHandler handler = this.mHandler == null ? DEFAULT_ON_CLICK_HANDLER : this.mHandler;
                        for (Action a : this.mActions) {
                            a.apply(viewTree.mRoot, this.mParent, handler);
                        }
                    }
                }
                catch (Exception e) {
                    this.mError = e;
                }
            }
            if (this.mListener != null) {
                if (this.mError != null) {
                    this.mListener.onError(this.mError);
                } else {
                    this.mListener.onViewApplied(viewTree.mRoot);
                }
            } else if (this.mError != null) {
                if (this.mError instanceof ActionException) {
                    throw (ActionException)this.mError;
                }
                throw new ActionException(this.mError);
            }
        }

        @Override
        public void onCancel() {
            this.cancel(true);
        }
    }

    public static interface OnViewAppliedListener {
        public void onViewApplied(View var1);

        public void onError(Exception var1);
    }

    private class MemoryUsageCounter {
        int mMemoryUsage;

        private MemoryUsageCounter() {
        }

        public void clear() {
            this.mMemoryUsage = 0;
        }

        public void increment(int numBytes) {
            this.mMemoryUsage += numBytes;
        }

        public int getMemoryUsage() {
            return this.mMemoryUsage;
        }

        public void addBitmapMemory(Bitmap b) {
            this.increment(b.getAllocationByteCount());
        }
    }

    private class OverrideTextColorsAction
    extends Action {
        private final int textColor;

        public OverrideTextColorsAction(int textColor) {
            this.textColor = textColor;
        }

        public OverrideTextColorsAction(Parcel parcel) {
            this.textColor = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(20);
            dest.writeInt(this.textColor);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Stack<View> viewsToProcess = new Stack<View>();
            viewsToProcess.add(root);
            while (!viewsToProcess.isEmpty()) {
                View v = (View)viewsToProcess.pop();
                if (v instanceof TextView) {
                    TextView textView = (TextView)v;
                    textView.setText(NotificationColorUtil.clearColorSpans(textView.getText()));
                    textView.setTextColor(this.textColor);
                }
                if (!(v instanceof ViewGroup)) continue;
                ViewGroup viewGroup = (ViewGroup)v;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    viewsToProcess.push(viewGroup.getChildAt(i));
                }
            }
        }

        @Override
        public String getActionName() {
            return "OverrideTextColorsAction";
        }
    }

    private class SetRemoteInputsAction
    extends Action {
        final Parcelable[] remoteInputs;

        public SetRemoteInputsAction(int viewId, RemoteInput[] remoteInputs) {
            this.viewId = viewId;
            this.remoteInputs = remoteInputs;
        }

        public SetRemoteInputsAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.remoteInputs = parcel.createTypedArray(RemoteInput.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(18);
            dest.writeInt(this.viewId);
            dest.writeTypedArray(this.remoteInputs, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(16909191, this.remoteInputs);
        }

        @Override
        public String getActionName() {
            return "SetRemoteInputsAction";
        }
    }

    private class TextViewDrawableColorFilterAction
    extends Action {
        final boolean isRelative;
        final int index;
        final int color;
        final PorterDuff.Mode mode;

        public TextViewDrawableColorFilterAction(int viewId, boolean isRelative, int index, int color2, PorterDuff.Mode mode) {
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.index = index;
            this.color = color2;
            this.mode = mode;
        }

        public TextViewDrawableColorFilterAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            this.index = parcel.readInt();
            this.color = parcel.readInt();
            this.mode = this.readPorterDuffMode(parcel);
        }

        private PorterDuff.Mode readPorterDuffMode(Parcel parcel) {
            int mode = parcel.readInt();
            if (mode >= 0 && mode < PorterDuff.Mode.values().length) {
                return PorterDuff.Mode.values()[mode];
            }
            return PorterDuff.Mode.CLEAR;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(17);
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.index);
            dest.writeInt(this.color);
            dest.writeInt(this.mode.ordinal());
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Drawable[] drawables;
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable[] drawableArray = drawables = this.isRelative ? target.getCompoundDrawablesRelative() : target.getCompoundDrawables();
            if (this.index < 0 || this.index >= 4) {
                throw new IllegalStateException("index must be in range [0, 3].");
            }
            Drawable d = drawables[this.index];
            if (d != null) {
                d.mutate();
                d.setColorFilter(this.color, this.mode);
            }
        }

        @Override
        public String getActionName() {
            return "TextViewDrawableColorFilterAction";
        }
    }

    private static class LayoutParamAction
    extends Action {
        public static final int LAYOUT_MARGIN_END_DIMEN = 1;
        public static final int LAYOUT_WIDTH = 2;
        public static final int LAYOUT_MARGIN_BOTTOM_DIMEN = 3;
        int property;
        int value;

        public LayoutParamAction(int viewId, int property, int value) {
            this.viewId = viewId;
            this.property = property;
            this.value = value;
        }

        public LayoutParamAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.property = parcel.readInt();
            this.value = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(19);
            dest.writeInt(this.viewId);
            dest.writeInt(this.property);
            dest.writeInt(this.value);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ViewGroup.LayoutParams layoutParams = ((View)target).getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            switch (this.property) {
                case 1: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    int resolved = LayoutParamAction.resolveDimenPixelOffset(target, this.value);
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginEnd(resolved);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 3: {
                    int resolved;
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin = resolved = LayoutParamAction.resolveDimenPixelOffset(target, this.value);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 2: {
                    layoutParams.width = this.value;
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property " + this.property);
                }
            }
        }

        private static int resolveDimenPixelOffset(View target, int value) {
            if (value == 0) {
                return 0;
            }
            return target.getContext().getResources().getDimensionPixelOffset(value);
        }

        @Override
        public String getActionName() {
            return "LayoutParamAction" + this.property + ".";
        }
    }

    private class ViewPaddingAction
    extends Action {
        int left;
        int top;
        int right;
        int bottom;

        public ViewPaddingAction(int viewId, int left, int top, int right, int bottom) {
            this.viewId = viewId;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public ViewPaddingAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.left = parcel.readInt();
            this.top = parcel.readInt();
            this.right = parcel.readInt();
            this.bottom = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(14);
            dest.writeInt(this.viewId);
            dest.writeInt(this.left);
            dest.writeInt(this.top);
            dest.writeInt(this.right);
            dest.writeInt(this.bottom);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            ((View)target).setPadding(this.left, this.top, this.right, this.bottom);
        }

        @Override
        public String getActionName() {
            return "ViewPaddingAction";
        }
    }

    private class TextViewSizeAction
    extends Action {
        int units;
        float size;

        public TextViewSizeAction(int viewId, int units, float size) {
            this.viewId = viewId;
            this.units = units;
            this.size = size;
        }

        public TextViewSizeAction(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.units = parcel.readInt();
            this.size = parcel.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(13);
            dest.writeInt(this.viewId);
            dest.writeInt(this.units);
            dest.writeFloat(this.size);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.setTextSize(this.units, this.size);
        }

        @Override
        public String getActionName() {
            return "TextViewSizeAction";
        }
    }

    private class TextViewDrawableAction
    extends Action {
        boolean isRelative;
        boolean useIcons;
        int d1;
        int d2;
        int d3;
        int d4;
        Icon i1;
        Icon i2;
        Icon i3;
        Icon i4;
        boolean drawablesLoaded;
        Drawable id1;
        Drawable id2;
        Drawable id3;
        Drawable id4;

        public TextViewDrawableAction(int viewId, boolean isRelative, int d1, int d2, int d3, int d4) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = false;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
        }

        public TextViewDrawableAction(int viewId, boolean isRelative, Icon i1, Icon i2, Icon i3, Icon i4) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.useIcons = true;
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }

        public TextViewDrawableAction(Parcel parcel) {
            this.isRelative = false;
            this.useIcons = false;
            this.drawablesLoaded = false;
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            boolean bl = this.useIcons = parcel.readInt() != 0;
            if (this.useIcons) {
                if (parcel.readInt() != 0) {
                    this.i1 = Icon.CREATOR.createFromParcel(parcel);
                }
                if (parcel.readInt() != 0) {
                    this.i2 = Icon.CREATOR.createFromParcel(parcel);
                }
                if (parcel.readInt() != 0) {
                    this.i3 = Icon.CREATOR.createFromParcel(parcel);
                }
                if (parcel.readInt() != 0) {
                    this.i4 = Icon.CREATOR.createFromParcel(parcel);
                }
            } else {
                this.d1 = parcel.readInt();
                this.d2 = parcel.readInt();
                this.d3 = parcel.readInt();
                this.d4 = parcel.readInt();
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(11);
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.useIcons ? 1 : 0);
            if (this.useIcons) {
                if (this.i1 != null) {
                    dest.writeInt(1);
                    this.i1.writeToParcel(dest, 0);
                } else {
                    dest.writeInt(0);
                }
                if (this.i2 != null) {
                    dest.writeInt(1);
                    this.i2.writeToParcel(dest, 0);
                } else {
                    dest.writeInt(0);
                }
                if (this.i3 != null) {
                    dest.writeInt(1);
                    this.i3.writeToParcel(dest, 0);
                } else {
                    dest.writeInt(0);
                }
                if (this.i4 != null) {
                    dest.writeInt(1);
                    this.i4.writeToParcel(dest, 0);
                } else {
                    dest.writeInt(0);
                }
            } else {
                dest.writeInt(this.d1);
                dest.writeInt(this.d2);
                dest.writeInt(this.d3);
                dest.writeInt(this.d4);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.drawablesLoaded) {
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(this.id1, this.id2, this.id3, this.id4);
                }
            } else if (this.useIcons) {
                Drawable id4;
                Context ctx = target.getContext();
                Drawable id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                Drawable id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                Drawable id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                Drawable drawable2 = id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
                if (this.isRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(id1, id2, id3, id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(id1, id2, id3, id4);
                }
            } else if (this.isRelative) {
                target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            } else {
                target.setCompoundDrawablesWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return ACTION_NOOP;
            }
            TextViewDrawableAction copy = this.useIcons ? new TextViewDrawableAction(this.viewId, this.isRelative, this.i1, this.i2, this.i3, this.i4) : new TextViewDrawableAction(this.viewId, this.isRelative, this.d1, this.d2, this.d3, this.d4);
            copy.drawablesLoaded = true;
            Context ctx = target.getContext();
            if (this.useIcons) {
                copy.id1 = this.i1 == null ? null : this.i1.loadDrawable(ctx);
                copy.id2 = this.i2 == null ? null : this.i2.loadDrawable(ctx);
                copy.id3 = this.i3 == null ? null : this.i3.loadDrawable(ctx);
                copy.id4 = this.i4 == null ? null : this.i4.loadDrawable(ctx);
            } else {
                copy.id1 = this.d1 == 0 ? null : ctx.getDrawable(this.d1);
                copy.id2 = this.d2 == 0 ? null : ctx.getDrawable(this.d2);
                copy.id3 = this.d3 == 0 ? null : ctx.getDrawable(this.d3);
                copy.id4 = this.d4 == 0 ? null : ctx.getDrawable(this.d4);
            }
            return copy;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.useIcons;
        }

        @Override
        public String getActionName() {
            return "TextViewDrawableAction";
        }
    }

    private class ViewGroupActionRemove
    extends Action {
        private static final int REMOVE_ALL_VIEWS_ID = -2;
        private int mViewIdToKeep;

        ViewGroupActionRemove(int viewId) {
            this(viewId, -2);
        }

        ViewGroupActionRemove(int viewId, int viewIdToKeep) {
            this.viewId = viewId;
            this.mViewIdToKeep = viewIdToKeep;
        }

        ViewGroupActionRemove(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.mViewIdToKeep = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(7);
            dest.writeInt(this.viewId);
            dest.writeInt(this.mViewIdToKeep);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.mViewIdToKeep == -2) {
                target.removeAllViews();
                return;
            }
            this.removeAllViewsExceptIdToKeep(target);
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            target.mChildren = null;
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
                    if (ViewGroupActionRemove.this.mViewIdToKeep == -2) {
                        targetVg.removeAllViews();
                        return;
                    }
                    ViewGroupActionRemove.this.removeAllViewsExceptIdToKeep(targetVg);
                }
            };
        }

        private void removeAllViewsExceptIdToKeep(ViewGroup viewGroup) {
            for (int index = viewGroup.getChildCount() - 1; index >= 0; --index) {
                if (viewGroup.getChildAt(index).getId() == this.mViewIdToKeep) continue;
                viewGroup.removeViewAt(index);
            }
        }

        @Override
        public String getActionName() {
            return "ViewGroupActionRemove";
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }
    }

    private class ViewGroupActionAdd
    extends Action {
        private RemoteViews mNestedViews;
        private int mIndex;

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews) {
            this(viewId, nestedViews, -1);
        }

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews, int index) {
            this.viewId = viewId;
            this.mNestedViews = nestedViews;
            this.mIndex = index;
            if (nestedViews != null) {
                RemoteViews.this.configureRemoteViewsAsChild(nestedViews);
            }
        }

        ViewGroupActionAdd(Parcel parcel, BitmapCache bitmapCache, ApplicationInfo info, int depth) {
            this.viewId = parcel.readInt();
            this.mIndex = parcel.readInt();
            this.mNestedViews = new RemoteViews(parcel, bitmapCache, info, depth);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(4);
            dest.writeInt(this.viewId);
            dest.writeInt(this.mIndex);
            this.mNestedViews.writeToParcel(dest, flags);
        }

        @Override
        public boolean hasSameAppInfo(ApplicationInfo parentInfo) {
            return ((RemoteViews)this.mNestedViews).mApplication.packageName.equals(parentInfo.packageName) && ((RemoteViews)this.mNestedViews).mApplication.uid == parentInfo.uid;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Context context = root.getContext();
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.addView(this.mNestedViews.apply(context, target, handler), this.mIndex);
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.viewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            Context context = root.mRoot.getContext();
            final AsyncApplyTask task = this.mNestedViews.getAsyncApplyTask(context, targetVg, null, handler);
            final ViewTree tree = task.doInBackground(new Void[0]);
            if (tree == null) {
                throw new ActionException(task.mError);
            }
            target.addChild(tree, this.mIndex);
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
                    task.onPostExecute(tree);
                    targetVg.addView(task.mResult, ViewGroupActionAdd.this.mIndex);
                }
            };
        }

        @Override
        public void updateMemoryUsageEstimate(MemoryUsageCounter counter) {
            counter.increment(this.mNestedViews.estimateMemoryUsage());
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            this.mNestedViews.setBitmapCache(bitmapCache);
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.mNestedViews.prefersAsyncApply();
        }

        @Override
        public String getActionName() {
            return "ViewGroupActionAdd";
        }
    }

    private static final class RunnableAction
    extends RuntimeAction {
        private final Runnable mRunnable;

        RunnableAction(Runnable r) {
            this.mRunnable = r;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            this.mRunnable.run();
        }
    }

    private final class ReflectionAction
    extends Action {
        static final int BOOLEAN = 1;
        static final int BYTE = 2;
        static final int SHORT = 3;
        static final int INT = 4;
        static final int LONG = 5;
        static final int FLOAT = 6;
        static final int DOUBLE = 7;
        static final int CHAR = 8;
        static final int STRING = 9;
        static final int CHAR_SEQUENCE = 10;
        static final int URI = 11;
        static final int BITMAP = 12;
        static final int BUNDLE = 13;
        static final int INTENT = 14;
        static final int COLOR_STATE_LIST = 15;
        static final int ICON = 16;
        String methodName;
        int type;
        Object value;

        ReflectionAction(int viewId, String methodName, int type, Object value) {
            this.viewId = viewId;
            this.methodName = methodName;
            this.type = type;
            this.value = value;
        }

        ReflectionAction(Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.type = in.readInt();
            switch (this.type) {
                case 1: {
                    this.value = in.readInt() != 0;
                    break;
                }
                case 2: {
                    this.value = in.readByte();
                    break;
                }
                case 3: {
                    this.value = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.value = in.readInt();
                    break;
                }
                case 5: {
                    this.value = in.readLong();
                    break;
                }
                case 6: {
                    this.value = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.value = in.readDouble();
                    break;
                }
                case 8: {
                    this.value = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.value = in.readString();
                    break;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    if (in.readInt() == 0) break;
                    this.value = Uri.CREATOR.createFromParcel(in);
                    break;
                }
                case 12: {
                    if (in.readInt() == 0) break;
                    this.value = Bitmap.CREATOR.createFromParcel(in);
                    break;
                }
                case 13: {
                    this.value = in.readBundle();
                    break;
                }
                case 14: {
                    if (in.readInt() == 0) break;
                    this.value = Intent.CREATOR.createFromParcel(in);
                    break;
                }
                case 15: {
                    if (in.readInt() == 0) break;
                    this.value = ColorStateList.CREATOR.createFromParcel(in);
                    break;
                }
                case 16: {
                    if (in.readInt() == 0) break;
                    this.value = Icon.CREATOR.createFromParcel(in);
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
            out.writeInt(this.type);
            switch (this.type) {
                case 1: {
                    out.writeInt((Boolean)this.value != false ? 1 : 0);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.value);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    out.writeString((String)this.value);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, out, flags);
                    break;
                }
                case 11: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Uri)this.value).writeToParcel(out, flags);
                    break;
                }
                case 12: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Bitmap)this.value).writeToParcel(out, flags);
                    break;
                }
                case 13: {
                    out.writeBundle((Bundle)this.value);
                    break;
                }
                case 14: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Intent)this.value).writeToParcel(out, flags);
                    break;
                }
                case 15: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((ColorStateList)this.value).writeToParcel(out, flags);
                    break;
                }
                case 16: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Icon)this.value).writeToParcel(out, flags);
                    break;
                }
            }
        }

        private Class<?> getParameterType() {
            switch (this.type) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Short.TYPE;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 5: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Double.TYPE;
                }
                case 8: {
                    return Character.TYPE;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return CharSequence.class;
                }
                case 11: {
                    return Uri.class;
                }
                case 12: {
                    return Bitmap.class;
                }
                case 13: {
                    return Bundle.class;
                }
                case 14: {
                    return Intent.class;
                }
                case 15: {
                    return ColorStateList.class;
                }
                case 16: {
                    return Icon.class;
                }
            }
            return null;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            Class<?> param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                RemoteViews.this.getMethod(view, this.methodName, param).invoke(view, RemoteViews.wrapArg(this.value));
            }
            catch (ActionException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return ACTION_NOOP;
            }
            Class<?> param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                Method method = RemoteViews.this.getMethod(view, this.methodName, param);
                Method asyncMethod = RemoteViews.this.getAsyncMethod(method);
                if (asyncMethod != null) {
                    Runnable endAction = (Runnable)asyncMethod.invoke(view, RemoteViews.wrapArg(this.value));
                    if (endAction == null) {
                        return ACTION_NOOP;
                    }
                    if (endAction instanceof ViewStub.ViewReplaceRunnable) {
                        root.createTree();
                        root.findViewTreeById(this.viewId).replaceView(((ViewStub.ViewReplaceRunnable)endAction).view);
                    }
                    return new RunnableAction(endAction);
                }
            }
            catch (ActionException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
            return this;
        }

        @Override
        public int mergeBehavior() {
            if (this.methodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        @Override
        public String getActionName() {
            return "ReflectionAction" + this.methodName + this.type;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.type == 11 || this.type == 16;
        }
    }

    private class BitmapReflectionAction
    extends Action {
        int bitmapId;
        Bitmap bitmap;
        String methodName;

        BitmapReflectionAction(int viewId, String methodName, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.viewId = viewId;
            this.methodName = methodName;
            this.bitmapId = RemoteViews.this.mBitmapCache.getBitmapId(bitmap);
        }

        BitmapReflectionAction(Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.bitmapId = in.readInt();
            this.bitmap = RemoteViews.this.mBitmapCache.getBitmapForId(this.bitmapId);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(12);
            dest.writeInt(this.viewId);
            dest.writeString(this.methodName);
            dest.writeInt(this.bitmapId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
            ReflectionAction ra = new ReflectionAction(this.viewId, this.methodName, 12, this.bitmap);
            ra.apply(root, rootParent, handler);
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            this.bitmapId = bitmapCache.getBitmapId(this.bitmap);
        }

        @Override
        public String getActionName() {
            return "BitmapReflectionAction";
        }
    }

    private static class BitmapCache {
        ArrayList<Bitmap> mBitmaps;

        public BitmapCache() {
            this.mBitmaps = new ArrayList();
        }

        public BitmapCache(Parcel source) {
            int count = source.readInt();
            this.mBitmaps = new ArrayList();
            for (int i = 0; i < count; ++i) {
                Bitmap b = Bitmap.CREATOR.createFromParcel(source);
                this.mBitmaps.add(b);
            }
        }

        public int getBitmapId(Bitmap b) {
            if (b == null) {
                return -1;
            }
            if (this.mBitmaps.contains(b)) {
                return this.mBitmaps.indexOf(b);
            }
            this.mBitmaps.add(b);
            return this.mBitmaps.size() - 1;
        }

        public Bitmap getBitmapForId(int id2) {
            if (id2 == -1 || id2 >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(id2);
        }

        public void writeBitmapsToParcel(Parcel dest, int flags) {
            int count = this.mBitmaps.size();
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                this.mBitmaps.get(i).writeToParcel(dest, flags);
            }
        }

        public void assimilate(BitmapCache bitmapCache) {
            ArrayList<Bitmap> bitmapsToBeAdded = bitmapCache.mBitmaps;
            int count = bitmapsToBeAdded.size();
            for (int i = 0; i < count; ++i) {
                Bitmap b = bitmapsToBeAdded.get(i);
                if (this.mBitmaps.contains(b)) continue;
                this.mBitmaps.add(b);
            }
        }

        public void addBitmapMemory(MemoryUsageCounter memoryCounter) {
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                memoryCounter.addBitmapMemory(this.mBitmaps.get(i));
            }
        }

        protected BitmapCache clone() {
            BitmapCache bitmapCache = new BitmapCache();
            bitmapCache.mBitmaps.addAll(this.mBitmaps);
            return bitmapCache;
        }
    }

    private final class ReflectionActionWithoutParams
    extends Action {
        final String methodName;

        ReflectionActionWithoutParams(int viewId, String methodName) {
            this.viewId = viewId;
            this.methodName = methodName;
        }

        ReflectionActionWithoutParams(Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(5);
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            try {
                RemoteViews.this.getMethod(view, this.methodName, null).invoke(view, new Object[0]);
            }
            catch (ActionException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public int mergeBehavior() {
            if (this.methodName.equals("showNext") || this.methodName.equals("showPrevious")) {
                return 2;
            }
            return 0;
        }

        @Override
        public String getActionName() {
            return "ReflectionActionWithoutParams";
        }
    }

    private class SetDrawableParameters
    extends Action {
        boolean targetBackground;
        int alpha;
        int colorFilter;
        PorterDuff.Mode filterMode;
        int level;

        public SetDrawableParameters(int id2, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
            this.viewId = id2;
            this.targetBackground = targetBackground;
            this.alpha = alpha;
            this.colorFilter = colorFilter;
            this.filterMode = mode;
            this.level = level;
        }

        public SetDrawableParameters(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.targetBackground = parcel.readInt() != 0;
            this.alpha = parcel.readInt();
            this.colorFilter = parcel.readInt();
            boolean hasMode = parcel.readInt() != 0;
            this.filterMode = hasMode ? PorterDuff.Mode.valueOf(parcel.readString()) : null;
            this.level = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(3);
            dest.writeInt(this.viewId);
            dest.writeInt(this.targetBackground ? 1 : 0);
            dest.writeInt(this.alpha);
            dest.writeInt(this.colorFilter);
            if (this.filterMode != null) {
                dest.writeInt(1);
                dest.writeString(this.filterMode.toString());
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.level);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.targetBackground) {
                targetDrawable = ((View)target).getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (targetDrawable != null) {
                if (this.alpha != -1) {
                    targetDrawable.mutate().setAlpha(this.alpha);
                }
                if (this.filterMode != null) {
                    targetDrawable.mutate().setColorFilter(this.colorFilter, this.filterMode);
                }
                if (this.level != -1) {
                    targetDrawable.mutate().setLevel(this.level);
                }
            }
        }

        @Override
        public String getActionName() {
            return "SetDrawableParameters";
        }
    }

    private class SetOnClickPendingIntent
    extends Action {
        PendingIntent pendingIntent;

        public SetOnClickPendingIntent(int id2, PendingIntent pendingIntent) {
            this.viewId = id2;
            this.pendingIntent = pendingIntent;
        }

        public SetOnClickPendingIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            if (parcel.readInt() != 0) {
                this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(1);
            dest.writeInt(this.viewId);
            dest.writeInt(this.pendingIntent != null ? 1 : 0);
            if (this.pendingIntent != null) {
                this.pendingIntent.writeToParcel(dest, 0);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, final OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (RemoteViews.this.mIsWidgetCollectionChild) {
                Log.w(RemoteViews.LOG_TAG, "Cannot setOnClickPendingIntent for collection item (id: " + this.viewId + ")");
                ApplicationInfo appInfo = root.getContext().getApplicationInfo();
                if (appInfo != null && appInfo.targetSdkVersion >= 16) {
                    return;
                }
            }
            View.OnClickListener listener = null;
            if (this.pendingIntent != null) {
                listener = new View.OnClickListener(){

                    @Override
                    public void onClick(View v) {
                        Rect rect = RemoteViews.getSourceBounds(v);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        handler.onClickHandler(v, SetOnClickPendingIntent.this.pendingIntent, intent);
                    }
                };
            }
            ((View)target).setOnClickListener(listener);
        }

        @Override
        public String getActionName() {
            return "SetOnClickPendingIntent";
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action {
        Intent intent;
        boolean isAsync;

        public SetRemoteViewsAdapterIntent(int id2, Intent intent) {
            this.isAsync = false;
            this.viewId = id2;
            this.intent = intent;
        }

        public SetRemoteViewsAdapterIntent(Parcel parcel) {
            this.isAsync = false;
            this.viewId = parcel.readInt();
            this.intent = Intent.CREATOR.createFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(10);
            dest.writeInt(this.viewId);
            this.intent.writeToParcel(dest, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            AppWidgetHostView host = (AppWidgetHostView)rootParent;
            this.intent.putExtra(RemoteViews.EXTRA_REMOTEADAPTER_APPWIDGET_ID, host.getAppWidgetId());
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsOnClickHandler(handler);
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                v.setRemoteViewsAdapter(this.intent, this.isAsync);
                v.setRemoteViewsOnClickHandler(handler);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            SetRemoteViewsAdapterIntent copy = new SetRemoteViewsAdapterIntent(this.viewId, this.intent);
            copy.isAsync = true;
            return copy;
        }

        @Override
        public String getActionName() {
            return "SetRemoteViewsAdapterIntent";
        }
    }

    private class SetRemoteViewsAdapterList
    extends Action {
        int viewTypeCount;
        ArrayList<RemoteViews> list;

        public SetRemoteViewsAdapterList(int id2, ArrayList<RemoteViews> list, int viewTypeCount) {
            this.viewId = id2;
            this.list = list;
            this.viewTypeCount = viewTypeCount;
        }

        public SetRemoteViewsAdapterList(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.viewTypeCount = parcel.readInt();
            int count = parcel.readInt();
            this.list = new ArrayList();
            for (int i = 0; i < count; ++i) {
                RemoteViews rv = CREATOR.createFromParcel(parcel);
                this.list.add(rv);
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(15);
            dest.writeInt(this.viewId);
            dest.writeInt(this.viewTypeCount);
            if (this.list == null || this.list.size() == 0) {
                dest.writeInt(0);
            } else {
                int count = this.list.size();
                dest.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    RemoteViews rv = this.list.get(i);
                    rv.writeToParcel(dest, flags);
                }
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                Object a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                Adapter a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            }
        }

        @Override
        public String getActionName() {
            return "SetRemoteViewsAdapterList";
        }
    }

    private class SetPendingIntentTemplate
    extends Action {
        PendingIntent pendingIntentTemplate;

        public SetPendingIntentTemplate(int id2, PendingIntent pendingIntentTemplate) {
            this.viewId = id2;
            this.pendingIntentTemplate = pendingIntentTemplate;
        }

        public SetPendingIntentTemplate(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(8);
            dest.writeInt(this.viewId);
            this.pendingIntentTemplate.writeToParcel(dest, 0);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, final OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.viewId + ")");
                return;
            }
            AdapterView av = (AdapterView)target;
            AdapterView.OnItemClickListener listener = new AdapterView.OnItemClickListener(){

                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (view instanceof ViewGroup) {
                        ViewGroup vg = (ViewGroup)view;
                        if (parent instanceof AdapterViewAnimator) {
                            vg = (ViewGroup)vg.getChildAt(0);
                        }
                        if (vg == null) {
                            return;
                        }
                        Intent fillInIntent = null;
                        int childCount = vg.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            Object tag = vg.getChildAt(i).getTag(16908865);
                            if (!(tag instanceof Intent)) continue;
                            fillInIntent = (Intent)tag;
                            break;
                        }
                        if (fillInIntent == null) {
                            return;
                        }
                        Rect rect = RemoteViews.getSourceBounds(view);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        handler.onClickHandler(view, SetPendingIntentTemplate.this.pendingIntentTemplate, fillInIntent);
                    }
                }
            };
            av.setOnItemClickListener(listener);
            av.setTag(this.pendingIntentTemplate);
        }

        @Override
        public String getActionName() {
            return "SetPendingIntentTemplate";
        }
    }

    private class SetOnClickFillInIntent
    extends Action {
        Intent fillInIntent;

        public SetOnClickFillInIntent(int id2, Intent fillInIntent) {
            this.viewId = id2;
            this.fillInIntent = fillInIntent;
        }

        public SetOnClickFillInIntent(Parcel parcel) {
            this.viewId = parcel.readInt();
            this.fillInIntent = Intent.CREATOR.createFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(9);
            dest.writeInt(this.viewId);
            this.fillInIntent.writeToParcel(dest, 0);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, final OnClickHandler handler) {
            Object target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!RemoteViews.this.mIsWidgetCollectionChild) {
                Log.e(RemoteViews.LOG_TAG, "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                return;
            }
            if (target == root) {
                ((View)target).setTagInternal(16908865, this.fillInIntent);
            } else if (this.fillInIntent != null) {
                View.OnClickListener listener = new View.OnClickListener(){

                    @Override
                    public void onClick(View v) {
                        View parent;
                        for (parent = (View)((Object)v.getParent()); !(parent == null || parent instanceof AdapterView || parent instanceof AppWidgetHostView && !(parent instanceof RemoteViewsAdapter.RemoteViewsFrameLayout)); parent = (View)((Object)parent.getParent())) {
                        }
                        if (!(parent instanceof AdapterView)) {
                            Log.e(RemoteViews.LOG_TAG, "Collection item doesn't have AdapterView parent");
                            return;
                        }
                        if (!(parent.getTag() instanceof PendingIntent)) {
                            Log.e(RemoteViews.LOG_TAG, "Attempting setOnClickFillInIntent without calling setPendingIntentTemplate on parent.");
                            return;
                        }
                        PendingIntent pendingIntent = (PendingIntent)parent.getTag();
                        Rect rect = RemoteViews.getSourceBounds(v);
                        SetOnClickFillInIntent.this.fillInIntent.setSourceBounds(rect);
                        handler.onClickHandler(v, pendingIntent, SetOnClickFillInIntent.this.fillInIntent);
                    }
                };
                ((View)target).setOnClickListener(listener);
            }
        }

        @Override
        public String getActionName() {
            return "SetOnClickFillInIntent";
        }
    }

    private class SetEmptyView
    extends Action {
        int viewId;
        int emptyViewId;

        SetEmptyView(int viewId, int emptyViewId) {
            this.viewId = viewId;
            this.emptyViewId = emptyViewId;
        }

        SetEmptyView(Parcel in) {
            this.viewId = in.readInt();
            this.emptyViewId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(6);
            out.writeInt(this.viewId);
            out.writeInt(this.emptyViewId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Object view = root.findViewById(this.viewId);
            if (!(view instanceof AdapterView)) {
                return;
            }
            AdapterView adapterView = (AdapterView)view;
            Object emptyView = root.findViewById(this.emptyViewId);
            if (emptyView == null) {
                return;
            }
            adapterView.setEmptyView((View)emptyView);
        }

        @Override
        public String getActionName() {
            return "SetEmptyView";
        }
    }

    private static class RemoteViewsContextWrapper
    extends ContextWrapper {
        private final Context mContextForResources;

        RemoteViewsContextWrapper(Context context, Context contextForResources) {
            super(context);
            this.mContextForResources = contextForResources;
        }

        @Override
        public Resources getResources() {
            return this.mContextForResources.getResources();
        }

        @Override
        public Resources.Theme getTheme() {
            return this.mContextForResources.getTheme();
        }

        @Override
        public String getPackageName() {
            return this.mContextForResources.getPackageName();
        }
    }

    private static abstract class RuntimeAction
    extends Action {
        private RuntimeAction() {
        }

        @Override
        public final String getActionName() {
            return "RuntimeAction";
        }

        @Override
        public final void writeToParcel(Parcel dest, int flags) {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class Action
    implements Parcelable {
        public static final int MERGE_REPLACE = 0;
        public static final int MERGE_APPEND = 1;
        public static final int MERGE_IGNORE = 2;
        int viewId;

        private Action() {
        }

        public abstract void apply(View var1, ViewGroup var2, OnClickHandler var3) throws ActionException;

        @Override
        public int describeContents() {
            return 0;
        }

        public void updateMemoryUsageEstimate(MemoryUsageCounter counter) {
        }

        public void setBitmapCache(BitmapCache bitmapCache) {
        }

        public int mergeBehavior() {
            return 0;
        }

        public abstract String getActionName();

        public String getUniqueKey() {
            return this.getActionName() + this.viewId;
        }

        public Action initActionAsync(ViewTree root, ViewGroup rootParent, OnClickHandler handler) {
            return this;
        }

        public boolean prefersAsyncApply() {
            return false;
        }

        public boolean hasSameAppInfo(ApplicationInfo parentInfo) {
            return true;
        }
    }

    public static class OnClickHandler {
        private int mEnterAnimationId;

        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
            return this.onClickHandler(view, pendingIntent, fillInIntent, -1);
        }

        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent, int launchStackId) {
            try {
                Context context = view.getContext();
                ActivityOptions opts = this.mEnterAnimationId != 0 ? ActivityOptions.makeCustomAnimation(context, this.mEnterAnimationId, 0) : ActivityOptions.makeBasic();
                if (launchStackId != -1) {
                    opts.setLaunchStackId(launchStackId);
                }
                context.startIntentSender(pendingIntent.getIntentSender(), fillInIntent, 0x10000000, 0x10000000, 0, opts.toBundle());
            }
            catch (IntentSender.SendIntentException e) {
                Log.e(RemoteViews.LOG_TAG, "Cannot send pending intent: ", e);
                return false;
            }
            catch (Exception e) {
                Log.e(RemoteViews.LOG_TAG, "Cannot send pending intent due to unknown exception: ", e);
                return false;
            }
            return true;
        }

        public void setEnterAnimationId(int enterAnimationId) {
            this.mEnterAnimationId = enterAnimationId;
        }
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception ex) {
            super(ex);
        }

        public ActionException(String message) {
            super(message);
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }

    static class MutablePair<F, S> {
        F first;
        S second;

        MutablePair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MutablePair)) {
                return false;
            }
            MutablePair p = (MutablePair)o;
            return Objects.equal(p.first, this.first) && Objects.equal(p.second, this.second);
        }

        public int hashCode() {
            return (this.first == null ? 0 : this.first.hashCode()) ^ (this.second == null ? 0 : this.second.hashCode());
        }
    }
}

