/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class AlsaCardsParser {
    private static final String TAG = "AlsaCardsParser";
    protected static final boolean DEBUG = false;
    private static final String kCardsFilePath = "/proc/asound/cards";
    private static LineTokenizer mTokenizer = new LineTokenizer(" :[]");
    private ArrayList<AlsaCardRecord> mCardRecords = new ArrayList();

    public void scan() {
        this.mCardRecords = new ArrayList();
        File cardsFile = new File(kCardsFilePath);
        try {
            FileReader reader = new FileReader(cardsFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                AlsaCardRecord cardRecord = new AlsaCardRecord();
                cardRecord.parse(line, 0);
                line = bufferedReader.readLine();
                if (line == null) break;
                cardRecord.parse(line, 1);
                this.mCardRecords.add(cardRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<AlsaCardRecord> getScanRecords() {
        return this.mCardRecords;
    }

    public AlsaCardRecord getCardRecordAt(int index) {
        return this.mCardRecords.get(index);
    }

    public AlsaCardRecord getCardRecordFor(int cardNum) {
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (rec.mCardNum != cardNum) continue;
            return rec;
        }
        return null;
    }

    public int getNumCardRecords() {
        return this.mCardRecords.size();
    }

    public boolean isCardUsb(int cardNum) {
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (rec.mCardNum != cardNum) continue;
            return rec.mIsUsb;
        }
        return false;
    }

    public int getDefaultUsbCard() {
        ArrayList<AlsaCardRecord> prevRecs = this.mCardRecords;
        this.scan();
        ArrayList<AlsaCardRecord> newRecs = this.getNewCardRecords(prevRecs);
        for (AlsaCardRecord rec : newRecs) {
            if (!rec.mIsUsb) continue;
            return rec.mCardNum;
        }
        for (AlsaCardRecord rec : prevRecs) {
            if (!rec.mIsUsb) continue;
            return rec.mCardNum;
        }
        return -1;
    }

    public int getDefaultCard() {
        int card = this.getDefaultUsbCard();
        if (card < 0 && this.getNumCardRecords() > 0) {
            card = this.getCardRecordAt((int)(this.getNumCardRecords() - 1)).mCardNum;
        }
        return card;
    }

    public static boolean hasCardNumber(ArrayList<AlsaCardRecord> recs, int cardNum) {
        for (AlsaCardRecord cardRec : recs) {
            if (cardRec.mCardNum != cardNum) continue;
            return true;
        }
        return false;
    }

    public ArrayList<AlsaCardRecord> getNewCardRecords(ArrayList<AlsaCardRecord> prevScanRecs) {
        ArrayList<AlsaCardRecord> newRecs = new ArrayList<AlsaCardRecord>();
        for (AlsaCardRecord rec : this.mCardRecords) {
            if (AlsaCardsParser.hasCardNumber(prevScanRecs, rec.mCardNum)) continue;
            newRecs.add(rec);
        }
        return newRecs;
    }

    private void Log(String heading) {
    }

    private static void LogDevices(String caption, ArrayList<AlsaCardRecord> deviceList) {
        Slog.d(TAG, caption + " ----------------");
        int listIndex = 0;
        for (AlsaCardRecord device : deviceList) {
            device.log(listIndex++);
        }
        Slog.d(TAG, "----------------");
    }

    public class AlsaCardRecord {
        private static final String TAG = "AlsaCardRecord";
        private static final String kUsbCardKeyStr = "at usb-";
        public int mCardNum = -1;
        public String mField1 = "";
        public String mCardName = "";
        public String mCardDescription = "";
        public boolean mIsUsb = false;

        private boolean parse(String line, int lineIndex) {
            int tokenIndex = 0;
            int delimIndex = 0;
            if (lineIndex == 0) {
                tokenIndex = mTokenizer.nextToken(line, tokenIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                try {
                    this.mCardNum = Integer.parseInt(line.substring(tokenIndex, delimIndex));
                }
                catch (NumberFormatException e) {
                    Slog.e(TAG, "Failed to parse line " + lineIndex + " of " + AlsaCardsParser.kCardsFilePath + ": " + line.substring(tokenIndex, delimIndex));
                    return false;
                }
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                delimIndex = mTokenizer.nextDelimiter(line, tokenIndex);
                this.mField1 = line.substring(tokenIndex, delimIndex);
                tokenIndex = mTokenizer.nextToken(line, delimIndex);
                this.mCardName = line.substring(tokenIndex);
            } else if (lineIndex == 1 && (tokenIndex = mTokenizer.nextToken(line, 0)) != -1) {
                int keyIndex = line.indexOf(kUsbCardKeyStr);
                boolean bl = this.mIsUsb = keyIndex != -1;
                if (this.mIsUsb) {
                    this.mCardDescription = line.substring(tokenIndex, keyIndex - 1);
                }
            }
            return true;
        }

        public String textFormat() {
            return this.mCardName + " : " + this.mCardDescription;
        }

        public void log(int listIndex) {
            Slog.d(TAG, "" + listIndex + " [" + this.mCardNum + " " + this.mCardName + " : " + this.mCardDescription + " usb:" + this.mIsUsb);
        }
    }
}

