/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.UserHandle;
import android.util.TimeUtils;
import com.android.internal.app.procstats.ProcessState;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class DumpUtils {
    public static final String[] STATE_NAMES = new String[]{"Persist", "Top    ", "ImpFg  ", "ImpBg  ", "Backup ", "HeavyWt", "Service", "ServRst", "Receivr", "Home   ", "LastAct", "CchAct ", "CchCAct", "CchEmty"};
    public static final String[] ADJ_SCREEN_NAMES_CSV = new String[]{"off", "on"};
    public static final String[] ADJ_MEM_NAMES_CSV = new String[]{"norm", "mod", "low", "crit"};
    public static final String[] STATE_NAMES_CSV = new String[]{"pers", "top", "impfg", "impbg", "backup", "heavy", "service", "service-rs", "receiver", "home", "lastact", "cch-activity", "cch-aclient", "cch-empty"};
    static final String[] ADJ_SCREEN_TAGS = new String[]{"0", "1"};
    static final String[] ADJ_MEM_TAGS = new String[]{"n", "m", "l", "c"};
    static final String[] STATE_TAGS = new String[]{"p", "t", "f", "b", "u", "w", "s", "x", "r", "h", "l", "a", "c", "e"};
    static final String CSV_SEP = "\t";

    private DumpUtils() {
    }

    public static void printScreenLabel(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                pw.print("     ");
                break;
            }
            case 0: {
                pw.print("SOff/");
                break;
            }
            case 4: {
                pw.print("SOn /");
                break;
            }
            default: {
                pw.print("????/");
            }
        }
    }

    public static void printScreenLabelCsv(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                break;
            }
            case 0: {
                pw.print(ADJ_SCREEN_NAMES_CSV[0]);
                break;
            }
            case 4: {
                pw.print(ADJ_SCREEN_NAMES_CSV[1]);
                break;
            }
            default: {
                pw.print("???");
            }
        }
    }

    public static void printMemLabel(PrintWriter pw, int offset, char sep) {
        switch (offset) {
            case -1: {
                pw.print("    ");
                if (sep == '\u0000') break;
                pw.print(' ');
                break;
            }
            case 0: {
                pw.print("Norm");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 1: {
                pw.print("Mod ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 2: {
                pw.print("Low ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 3: {
                pw.print("Crit");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            default: {
                pw.print("????");
                if (sep == '\u0000') break;
                pw.print(sep);
            }
        }
    }

    public static void printMemLabelCsv(PrintWriter pw, int offset) {
        if (offset >= 0) {
            if (offset <= 3) {
                pw.print(ADJ_MEM_NAMES_CSV[offset]);
            } else {
                pw.print("???");
            }
        }
    }

    public static void printPercent(PrintWriter pw, double fraction2) {
        if ((fraction2 *= 100.0) < 1.0) {
            pw.print(String.format("%.2f", fraction2));
        } else if (fraction2 < 10.0) {
            pw.print(String.format("%.1f", fraction2));
        } else {
            pw.print(String.format("%.0f", fraction2));
        }
        pw.print("%");
    }

    public static void printProcStateTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 56);
        state = DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 14);
        DumpUtils.printArrayEntry(pw, STATE_TAGS, state, 1);
    }

    public static void printAdjTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 4);
        DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 1);
    }

    public static void printProcStateTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printProcStateTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    public static void printAdjTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printAdjTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    public static long dumpSingleTime(PrintWriter pw, String prefix, long[] durations, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                String running = "";
                if (curState == state) {
                    time += now - curStartTime;
                    if (pw != null) {
                        running = " (running)";
                    }
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    public static void dumpAdjTimesCheckin(PrintWriter pw, String sep, long[] durations, int curState, long curStartTime, long now) {
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                if (curState == state) {
                    time += now - curStartTime;
                }
                if (time == 0L) continue;
                DumpUtils.printAdjTagAndValue(pw, state, time);
            }
        }
    }

    private static void dumpStateHeadersCsv(PrintWriter pw, String sep, int[] screenStates, int[] memStates, int[] procStates) {
        int NS = screenStates != null ? screenStates.length : 1;
        int NM = memStates != null ? memStates.length : 1;
        int NP = procStates != null ? procStates.length : 1;
        for (int is = 0; is < NS; ++is) {
            for (int im = 0; im < NM; ++im) {
                for (int ip = 0; ip < NP; ++ip) {
                    pw.print(sep);
                    boolean printed = false;
                    if (screenStates != null && screenStates.length > 1) {
                        DumpUtils.printScreenLabelCsv(pw, screenStates[is]);
                        printed = true;
                    }
                    if (memStates != null && memStates.length > 1) {
                        if (printed) {
                            pw.print("-");
                        }
                        DumpUtils.printMemLabelCsv(pw, memStates[im]);
                        printed = true;
                    }
                    if (procStates == null || procStates.length <= 1) continue;
                    if (printed) {
                        pw.print("-");
                    }
                    pw.print(STATE_NAMES_CSV[procStates[ip]]);
                }
            }
        }
    }

    public static void dumpProcessSummaryLocked(PrintWriter pw, String prefix, ArrayList<ProcessState> procs, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            proc.dumpSummary(pw, prefix, screenStates, memStates, procStates, now, totalTime);
        }
    }

    public static void dumpProcessListCsv(PrintWriter pw, ArrayList<ProcessState> procs, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        pw.print("process");
        pw.print(CSV_SEP);
        pw.print("uid");
        pw.print(CSV_SEP);
        pw.print("vers");
        DumpUtils.dumpStateHeadersCsv(pw, CSV_SEP, (int[])(sepScreenStates ? screenStates : null), (int[])(sepMemStates ? memStates : null), (int[])(sepProcStates ? procStates : null));
        pw.println();
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(proc.getName());
            pw.print(CSV_SEP);
            UserHandle.formatUid(pw, proc.getUid());
            pw.print(CSV_SEP);
            pw.print(proc.getVersion());
            proc.dumpCsv(pw, sepScreenStates, screenStates, sepMemStates, memStates, sepProcStates, procStates, now);
            pw.println();
        }
    }

    public static int printArrayEntry(PrintWriter pw, String[] array2, int value, int mod) {
        int index = value / mod;
        if (index >= 0 && index < array2.length) {
            pw.print(array2[index]);
        } else {
            pw.print('?');
        }
        return value - index * mod;
    }

    public static String collapseString(String pkgName, String itemName) {
        if (itemName.startsWith(pkgName)) {
            int PKGLEN;
            int ITEMLEN = itemName.length();
            if (ITEMLEN == (PKGLEN = pkgName.length())) {
                return "";
            }
            if (ITEMLEN >= PKGLEN && itemName.charAt(PKGLEN) == '.') {
                return itemName.substring(PKGLEN);
            }
        }
        return itemName;
    }
}

