/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupTransport;
import android.app.backup.RestoreDescription;
import android.app.backup.RestoreSet;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.ArrayMap;
import android.util.Log;
import com.android.org.bouncycastle.util.encoders.Base64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;

public class LocalTransport
extends BackupTransport {
    private static final String TAG = "LocalTransport";
    private static final boolean DEBUG = false;
    private static final String TRANSPORT_DIR_NAME = "com.android.internal.backup.LocalTransport";
    private static final String TRANSPORT_DESTINATION_STRING = "Backing up to debug-only private cache";
    private static final String TRANSPORT_DATA_MANAGEMENT_LABEL = "";
    private static final String INCREMENTAL_DIR = "_delta";
    private static final String FULL_DATA_DIR = "_full";
    private static final long CURRENT_SET_TOKEN = 1L;
    private static final long FULL_BACKUP_SIZE_QUOTA = 0x1900000L;
    private static final long KEY_VALUE_BACKUP_SIZE_QUOTA = 0x500000L;
    private Context mContext;
    private File mDataDir = new File(Environment.getDownloadCacheDirectory(), "backup");
    private File mCurrentSetDir = new File(this.mDataDir, Long.toString(1L));
    private File mCurrentSetIncrementalDir = new File(this.mCurrentSetDir, "_delta");
    private File mCurrentSetFullDir = new File(this.mCurrentSetDir, "_full");
    private PackageInfo[] mRestorePackages = null;
    private int mRestorePackage = -1;
    private int mRestoreType;
    private File mRestoreSetDir;
    private File mRestoreSetIncrementalDir;
    private File mRestoreSetFullDir;
    private String mFullTargetPackage;
    private ParcelFileDescriptor mSocket;
    private FileInputStream mSocketInputStream;
    private BufferedOutputStream mFullBackupOutputStream;
    private byte[] mFullBackupBuffer;
    private long mFullBackupSize;
    private FileInputStream mCurFullRestoreStream;
    private FileOutputStream mFullRestoreSocketStream;
    private byte[] mFullRestoreBuffer;
    static final long[] POSSIBLE_SETS = new long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};

    private void makeDataDirs() {
        this.mCurrentSetDir.mkdirs();
        this.mCurrentSetFullDir.mkdir();
        this.mCurrentSetIncrementalDir.mkdir();
    }

    public LocalTransport(Context context) {
        this.mContext = context;
        this.makeDataDirs();
    }

    @Override
    public String name() {
        return new ComponentName(this.mContext, this.getClass()).flattenToShortString();
    }

    @Override
    public Intent configurationIntent() {
        return null;
    }

    @Override
    public String currentDestinationString() {
        return TRANSPORT_DESTINATION_STRING;
    }

    @Override
    public Intent dataManagementIntent() {
        return null;
    }

    @Override
    public String dataManagementLabel() {
        return TRANSPORT_DATA_MANAGEMENT_LABEL;
    }

    @Override
    public String transportDirName() {
        return TRANSPORT_DIR_NAME;
    }

    @Override
    public long requestBackupTime() {
        return 0L;
    }

    @Override
    public int initializeDevice() {
        this.deleteContents(this.mCurrentSetDir);
        this.makeDataDirs();
        return 0;
    }

    @Override
    public int performBackup(PackageInfo packageInfo, ParcelFileDescriptor data) {
        int totalSize;
        ArrayList<KVOperation> changeOps;
        File packageDir = new File(this.mCurrentSetIncrementalDir, packageInfo.packageName);
        packageDir.mkdirs();
        try {
            changeOps = this.parseBackupStream(data);
        }
        catch (IOException e) {
            Log.v(TAG, "Exception reading backup input", e);
            return -1000;
        }
        ArrayMap<String, Integer> datastore = new ArrayMap<String, Integer>();
        int updatedSize = totalSize = this.parseKeySizes(packageDir, datastore);
        for (KVOperation op : changeOps) {
            Integer curSize = datastore.get(op.key);
            if (curSize != null) {
                updatedSize -= curSize.intValue();
            }
            if (op.value == null) continue;
            updatedSize += op.value.length;
        }
        if ((long)updatedSize > 0x500000L) {
            return -1005;
        }
        for (KVOperation op : changeOps) {
            File element = new File(packageDir, op.key);
            element.delete();
            if (op.value == null) continue;
            try {
                FileOutputStream out = new FileOutputStream(element);
                Throwable throwable = null;
                try {
                    out.write(op.value, 0, op.value.length);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to update key file " + element);
                return -1000;
            }
        }
        return 0;
    }

    private ArrayList<KVOperation> parseBackupStream(ParcelFileDescriptor data) throws IOException {
        ArrayList<KVOperation> changeOps = new ArrayList<KVOperation>();
        BackupDataInput changeSet = new BackupDataInput(data.getFileDescriptor());
        while (changeSet.readNextHeader()) {
            byte[] buf;
            String key = changeSet.getKey();
            String base64Key = new String(Base64.encode((byte[])key.getBytes()));
            int dataSize = changeSet.getDataSize();
            byte[] byArray = buf = dataSize >= 0 ? new byte[dataSize] : null;
            if (dataSize >= 0) {
                changeSet.readEntityData(buf, 0, dataSize);
            }
            changeOps.add(new KVOperation(base64Key, buf));
        }
        return changeOps;
    }

    private int parseKeySizes(File packageDir, ArrayMap<String, Integer> datastore) {
        int totalSize = 0;
        String[] elements = packageDir.list();
        if (elements != null) {
            for (String file : elements) {
                File element = new File(packageDir, file);
                String key = file;
                int size = (int)element.length();
                totalSize += size;
                datastore.put(key, size);
            }
        }
        return totalSize;
    }

    private void deleteContents(File dirname) {
        File[] contents = dirname.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (f.isDirectory()) {
                    this.deleteContents(f);
                }
                f.delete();
            }
        }
    }

    @Override
    public int clearBackupData(PackageInfo packageInfo) {
        File[] tarballs;
        File packageDir = new File(this.mCurrentSetIncrementalDir, packageInfo.packageName);
        File[] fileset = packageDir.listFiles();
        if (fileset != null) {
            for (File f : fileset) {
                f.delete();
            }
            packageDir.delete();
        }
        if ((tarballs = (packageDir = new File(this.mCurrentSetFullDir, packageInfo.packageName)).listFiles()) != null) {
            for (File f : tarballs) {
                f.delete();
            }
            packageDir.delete();
        }
        return 0;
    }

    @Override
    public int finishBackup() {
        return this.tearDownFullBackup();
    }

    private int tearDownFullBackup() {
        if (this.mSocket != null) {
            try {
                if (this.mFullBackupOutputStream != null) {
                    this.mFullBackupOutputStream.flush();
                    this.mFullBackupOutputStream.close();
                }
                this.mSocketInputStream = null;
                this.mFullTargetPackage = null;
                this.mSocket.close();
            }
            catch (IOException e) {
                int n = -1000;
                return n;
            }
            finally {
                this.mSocket = null;
                this.mFullBackupOutputStream = null;
            }
        }
        return 0;
    }

    private File tarballFile(String pkgName) {
        return new File(this.mCurrentSetFullDir, pkgName);
    }

    @Override
    public long requestFullBackupTime() {
        return 0L;
    }

    @Override
    public int checkFullBackupSize(long size) {
        int result = 0;
        if (size <= 0L) {
            result = -1002;
        } else if (size > 0x1900000L) {
            result = -1005;
        }
        if (result != 0) {
            // empty if block
        }
        return result;
    }

    @Override
    public int performFullBackup(PackageInfo targetPackage, ParcelFileDescriptor socket) {
        if (this.mSocket != null) {
            Log.e(TAG, "Attempt to initiate full backup while one is in progress");
            return -1000;
        }
        try {
            this.mFullBackupSize = 0L;
            this.mSocket = ParcelFileDescriptor.dup(socket.getFileDescriptor());
            this.mSocketInputStream = new FileInputStream(this.mSocket.getFileDescriptor());
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to process socket for full backup");
            return -1000;
        }
        this.mFullTargetPackage = targetPackage.packageName;
        this.mFullBackupBuffer = new byte[4096];
        return 0;
    }

    @Override
    public int sendBackupData(int numBytes) {
        int nRead;
        if (this.mSocket == null) {
            Log.w(TAG, "Attempted sendBackupData before performFullBackup");
            return -1000;
        }
        this.mFullBackupSize += (long)numBytes;
        if (this.mFullBackupSize > 0x1900000L) {
            return -1005;
        }
        if (numBytes > this.mFullBackupBuffer.length) {
            this.mFullBackupBuffer = new byte[numBytes];
        }
        if (this.mFullBackupOutputStream == null) {
            FileOutputStream tarstream;
            try {
                File tarball = this.tarballFile(this.mFullTargetPackage);
                tarstream = new FileOutputStream(tarball);
            }
            catch (FileNotFoundException e) {
                return -1000;
            }
            this.mFullBackupOutputStream = new BufferedOutputStream(tarstream);
        }
        for (int bytesLeft = numBytes; bytesLeft > 0; bytesLeft -= nRead) {
            try {
                nRead = this.mSocketInputStream.read(this.mFullBackupBuffer, 0, bytesLeft);
                if (nRead < 0) {
                    Log.w(TAG, "Unexpected EOD; failing backup");
                    return -1000;
                }
                this.mFullBackupOutputStream.write(this.mFullBackupBuffer, 0, nRead);
                continue;
            }
            catch (IOException e) {
                Log.e(TAG, "Error handling backup data for " + this.mFullTargetPackage);
                return -1000;
            }
        }
        return 0;
    }

    @Override
    public void cancelFullBackup() {
        File archive = this.tarballFile(this.mFullTargetPackage);
        this.tearDownFullBackup();
        if (archive.exists()) {
            archive.delete();
        }
    }

    @Override
    public RestoreSet[] getAvailableRestoreSets() {
        long[] existing = new long[POSSIBLE_SETS.length + 1];
        int num = 0;
        for (long token : POSSIBLE_SETS) {
            if (!new File(this.mDataDir, Long.toString(token)).exists()) continue;
            existing[num++] = token;
        }
        existing[num++] = 1L;
        RestoreSet[] available = new RestoreSet[num];
        for (int i = 0; i < available.length; ++i) {
            available[i] = new RestoreSet("Local disk image", "flash", existing[i]);
        }
        return available;
    }

    @Override
    public long getCurrentRestoreSet() {
        return 1L;
    }

    @Override
    public int startRestore(long token, PackageInfo[] packages) {
        this.mRestorePackages = packages;
        this.mRestorePackage = -1;
        this.mRestoreSetDir = new File(this.mDataDir, Long.toString(token));
        this.mRestoreSetIncrementalDir = new File(this.mRestoreSetDir, INCREMENTAL_DIR);
        this.mRestoreSetFullDir = new File(this.mRestoreSetDir, FULL_DATA_DIR);
        return 0;
    }

    @Override
    public RestoreDescription nextRestorePackage() {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        boolean found = false;
        while (++this.mRestorePackage < this.mRestorePackages.length) {
            File maybeFullData;
            String name = this.mRestorePackages[this.mRestorePackage].packageName;
            String[] contents = new File(this.mRestoreSetIncrementalDir, name).list();
            if (contents != null && contents.length > 0) {
                this.mRestoreType = 1;
                found = true;
            }
            if (!found && (maybeFullData = new File(this.mRestoreSetFullDir, name)).length() > 0L) {
                this.mRestoreType = 2;
                this.mCurFullRestoreStream = null;
                found = true;
            }
            if (!found) continue;
            return new RestoreDescription(name, this.mRestoreType);
        }
        return RestoreDescription.NO_MORE_PACKAGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRestoreData(ParcelFileDescriptor outFd) {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        if (this.mRestorePackage < 0) {
            throw new IllegalStateException("nextRestorePackage not called");
        }
        if (this.mRestoreType != 1) {
            throw new IllegalStateException("getRestoreData(fd) for non-key/value dataset");
        }
        File packageDir = new File(this.mRestoreSetIncrementalDir, this.mRestorePackages[this.mRestorePackage].packageName);
        ArrayList<DecodedFilename> blobs = this.contentsByKey(packageDir);
        if (blobs == null) {
            Log.e(TAG, "No keys for package: " + packageDir);
            return -1000;
        }
        BackupDataOutput out = new BackupDataOutput(outFd.getFileDescriptor());
        try {
            for (DecodedFilename keyEntry : blobs) {
                File f = keyEntry.file;
                try (FileInputStream in = new FileInputStream(f);){
                    int size = (int)f.length();
                    byte[] buf = new byte[size];
                    in.read(buf);
                    out.writeEntityHeader(keyEntry.key, size);
                    out.writeEntityData(buf, size);
                }
            }
            return 0;
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to read backup records", e);
            return -1000;
        }
    }

    private ArrayList<DecodedFilename> contentsByKey(File dir) {
        File[] allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            return null;
        }
        ArrayList<DecodedFilename> contents = new ArrayList<DecodedFilename>();
        for (File f : allFiles) {
            contents.add(new DecodedFilename(f));
        }
        Collections.sort(contents);
        return contents;
    }

    @Override
    public void finishRestore() {
        if (this.mRestoreType == 2) {
            this.resetFullRestoreState();
        }
        this.mRestoreType = 0;
    }

    private void resetFullRestoreState() {
        IoUtils.closeQuietly(this.mCurFullRestoreStream);
        this.mCurFullRestoreStream = null;
        this.mFullRestoreSocketStream = null;
        this.mFullRestoreBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextFullRestoreDataChunk(ParcelFileDescriptor socket) {
        int nRead;
        if (this.mRestoreType != 2) {
            throw new IllegalStateException("Asked for full restore data for non-stream package");
        }
        if (this.mCurFullRestoreStream == null) {
            String name = this.mRestorePackages[this.mRestorePackage].packageName;
            File dataset = new File(this.mRestoreSetFullDir, name);
            try {
                this.mCurFullRestoreStream = new FileInputStream(dataset);
            }
            catch (IOException e) {
                Log.e(TAG, "Unable to read archive for " + name);
                return -1002;
            }
            this.mFullRestoreSocketStream = new FileOutputStream(socket.getFileDescriptor());
            this.mFullRestoreBuffer = new byte[2048];
        }
        try {
            nRead = this.mCurFullRestoreStream.read(this.mFullRestoreBuffer);
            if (nRead < 0) {
                nRead = -1;
            } else if (nRead == 0) {
                Log.w(TAG, "read() of archive file returned 0; treating as EOF");
                nRead = -1;
            } else {
                this.mFullRestoreSocketStream.write(this.mFullRestoreBuffer, 0, nRead);
            }
        }
        catch (IOException e) {
            int n = -1000;
            return n;
        }
        return nRead;
    }

    @Override
    public int abortFullRestore() {
        if (this.mRestoreType != 2) {
            throw new IllegalStateException("abortFullRestore() but not currently restoring");
        }
        this.resetFullRestoreState();
        this.mRestoreType = 0;
        return 0;
    }

    @Override
    public long getBackupQuota(String packageName, boolean isFullBackup) {
        return isFullBackup ? 0x1900000L : 0x500000L;
    }

    static class DecodedFilename
    implements Comparable<DecodedFilename> {
        public File file;
        public String key;

        public DecodedFilename(File f) {
            this.file = f;
            this.key = new String(Base64.decode((String)f.getName()));
        }

        @Override
        public int compareTo(DecodedFilename other) {
            return this.key.compareTo(other.key);
        }
    }

    private class KVOperation {
        final String key;
        final byte[] value;

        KVOperation(String k, byte[] v) {
            this.key = k;
            this.value = v;
        }
    }
}

