/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.pdf.PdfRenderer;
import android.os.AsyncTask;
import android.os.ParcelFileDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;
import libcore.io.Streams;

public final class PdfUtils {
    private PdfUtils() {
    }

    public static AssetFileDescriptor openPdfThumbnail(File file, Point size) throws IOException {
        final ParcelFileDescriptor pdfDescriptor = ParcelFileDescriptor.open(file, 0x10000000);
        PdfRenderer renderer = new PdfRenderer(pdfDescriptor);
        PdfRenderer.Page frontPage = renderer.openPage(0);
        Bitmap thumbnail = Bitmap.createBitmap(size.x, size.y, Bitmap.Config.ARGB_8888);
        frontPage.render(thumbnail, null, null, 1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int quality = 100;
        thumbnail.compress(Bitmap.CompressFormat.PNG, quality, out);
        final ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        final ParcelFileDescriptor[] fds = ParcelFileDescriptor.createReliablePipe();
        new AsyncTask<Object, Object, Object>(){

            @Override
            protected Object doInBackground(Object ... params) {
                FileOutputStream fos = new FileOutputStream(fds[1].getFileDescriptor());
                try {
                    Streams.copy(in, fos);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                IoUtils.closeQuietly(fds[1]);
                try {
                    pdfDescriptor.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
        pdfDescriptor.close();
        return new AssetFileDescriptor(fds[0], 0L, -1L);
    }
}

