/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.LongSparseLongArray;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class KernelMemoryBandwidthStats {
    private static final String TAG = "KernelMemoryBandwidthStats";
    private static final String mSysfsFile = "/sys/kernel/memory_state_time/show_stat";
    private static final boolean DEBUG = false;
    protected final LongSparseLongArray mBandwidthEntries = new LongSparseLongArray();
    private boolean mStatsDoNotExist = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats() {
        if (this.mStatsDoNotExist) {
            return;
        }
        long startTime = SystemClock.uptimeMillis();
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        try (BufferedReader reader = new BufferedReader(new FileReader(mSysfsFile));){
            this.parseStats(reader);
        }
        catch (FileNotFoundException e) {
            Slog.w(TAG, "No kernel memory bandwidth stats available");
            this.mBandwidthEntries.clear();
            this.mStatsDoNotExist = true;
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read memory bandwidth: " + e.getMessage());
            this.mBandwidthEntries.clear();
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
        long readTime = SystemClock.uptimeMillis() - startTime;
        if (readTime > 100L) {
            Slog.w(TAG, "Reading memory bandwidth file took " + readTime + "ms");
        }
    }

    public void parseStats(BufferedReader reader) throws IOException {
        String line;
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
        this.mBandwidthEntries.clear();
        while ((line = reader.readLine()) != null) {
            splitter.setString(line);
            splitter.next();
            int bandwidth = 0;
            do {
                int index;
                if ((index = this.mBandwidthEntries.indexOfKey(bandwidth)) >= 0) {
                    this.mBandwidthEntries.put(bandwidth, this.mBandwidthEntries.valueAt(index) + Long.parseLong(splitter.next()) / 1000000L);
                } else {
                    this.mBandwidthEntries.put(bandwidth, Long.parseLong(splitter.next()) / 1000000L);
                }
                ++bandwidth;
            } while (splitter.hasNext());
        }
    }

    public LongSparseLongArray getBandwidthEntries() {
        return this.mBandwidthEntries;
    }
}

