/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class KernelUidCpuTimeReader {
    private static final String TAG = "KernelUidCpuTimeReader";
    private static final String sProcFile = "/proc/uid_cputime/show_uid_stat";
    private static final String sRemoveUidProcFile = "/proc/uid_cputime/remove_uid_range";
    private SparseLongArray mLastUserTimeUs = new SparseLongArray();
    private SparseLongArray mLastSystemTimeUs = new SparseLongArray();
    private long mLastTimeReadUs = 0L;

    public void readDelta(Callback callback) {
        long nowUs = SystemClock.elapsedRealtime() * 1000L;
        try (BufferedReader reader = new BufferedReader(new FileReader(sProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            while ((line = reader.readLine()) != null) {
                splitter.setString(line);
                String uidStr = splitter.next();
                int uid = Integer.parseInt(uidStr.substring(0, uidStr.length() - 1), 10);
                long userTimeUs = Long.parseLong(splitter.next(), 10);
                long systemTimeUs = Long.parseLong(splitter.next(), 10);
                if (callback != null && this.mLastTimeReadUs != 0L) {
                    long userTimeDeltaUs = userTimeUs;
                    long systemTimeDeltaUs = systemTimeUs;
                    int index = this.mLastUserTimeUs.indexOfKey(uid);
                    if (index >= 0) {
                        long timeDiffUs = nowUs - this.mLastTimeReadUs;
                        if ((userTimeDeltaUs -= this.mLastUserTimeUs.valueAt(index)) < 0L || (systemTimeDeltaUs -= this.mLastSystemTimeUs.valueAt(index)) < 0L) {
                            StringBuilder sb = new StringBuilder("Malformed cpu data for UID=");
                            sb.append(uid).append("!\n");
                            sb.append("Time between reads: ");
                            TimeUtils.formatDuration(timeDiffUs / 1000L, sb);
                            sb.append("\n");
                            sb.append("Previous times: u=");
                            TimeUtils.formatDuration(this.mLastUserTimeUs.valueAt(index) / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(this.mLastSystemTimeUs.valueAt(index) / 1000L, sb);
                            sb.append("\nCurrent times: u=");
                            TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                            sb.append("\nDelta: u=");
                            TimeUtils.formatDuration(userTimeDeltaUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeDeltaUs / 1000L, sb);
                            Slog.e(TAG, sb.toString());
                            userTimeDeltaUs = 0L;
                            systemTimeDeltaUs = 0L;
                        }
                    }
                    if (userTimeDeltaUs != 0L || systemTimeDeltaUs != 0L) {
                        callback.onUidCpuTime(uid, userTimeDeltaUs, systemTimeDeltaUs);
                    }
                }
                this.mLastUserTimeUs.put(uid, userTimeUs);
                this.mLastSystemTimeUs.put(uid, systemTimeUs);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read uid_cputime: " + e.getMessage());
        }
        this.mLastTimeReadUs = nowUs;
    }

    public void removeUid(int uid) {
        int index = this.mLastSystemTimeUs.indexOfKey(uid);
        if (index >= 0) {
            this.mLastSystemTimeUs.removeAt(index);
            this.mLastUserTimeUs.removeAt(index);
        }
        this.removeUidsFromKernelModule(uid, uid);
    }

    public void removeUidsInRange(int startUid, int endUid) {
        if (endUid < startUid) {
            return;
        }
        this.mLastSystemTimeUs.put(startUid, 0L);
        this.mLastUserTimeUs.put(startUid, 0L);
        this.mLastSystemTimeUs.put(endUid, 0L);
        this.mLastUserTimeUs.put(endUid, 0L);
        int startIndex = this.mLastSystemTimeUs.indexOfKey(startUid);
        int endIndex = this.mLastSystemTimeUs.indexOfKey(endUid);
        this.mLastSystemTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.mLastUserTimeUs.removeAtRange(startIndex, endIndex - startIndex + 1);
        this.removeUidsFromKernelModule(startUid, endUid);
    }

    private void removeUidsFromKernelModule(int startUid, int endUid) {
        Slog.d(TAG, "Removing uids " + startUid + "-" + endUid);
        try (FileWriter writer = new FileWriter(sRemoveUidProcFile);){
            writer.write(startUid + "-" + endUid);
            writer.flush();
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to remove uids " + startUid + " - " + endUid + " from uid_cputime module", e);
        }
    }

    public static interface Callback {
        public void onUidCpuTime(int var1, long var2, long var4);
    }
}

