/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.util.ArrayMap;
import java.util.Map;

public final class RpmStats {
    public Map<String, PowerStatePlatformSleepState> mPlatformLowPowerStats = new ArrayMap<String, PowerStatePlatformSleepState>();
    public Map<String, PowerStateSubsystem> mSubsystemLowPowerStats = new ArrayMap<String, PowerStateSubsystem>();

    public PowerStatePlatformSleepState getAndUpdatePlatformState(String name, long timeMs, int count) {
        PowerStatePlatformSleepState e = this.mPlatformLowPowerStats.get(name);
        if (e == null) {
            e = new PowerStatePlatformSleepState();
            this.mPlatformLowPowerStats.put(name, e);
        }
        e.mTimeMs = timeMs;
        e.mCount = count;
        return e;
    }

    public PowerStateSubsystem getSubsystem(String name) {
        PowerStateSubsystem e = this.mSubsystemLowPowerStats.get(name);
        if (e == null) {
            e = new PowerStateSubsystem();
            this.mSubsystemLowPowerStats.put(name, e);
        }
        return e;
    }

    public static class PowerStateSubsystem {
        public Map<String, PowerStateElement> mStates = new ArrayMap<String, PowerStateElement>();

        public void putState(String name, long timeMs, int count) {
            PowerStateElement e = this.mStates.get(name);
            if (e == null) {
                this.mStates.put(name, new PowerStateElement(timeMs, count));
            } else {
                e.mTimeMs = timeMs;
                e.mCount = count;
            }
        }
    }

    public static class PowerStatePlatformSleepState {
        public long mTimeMs;
        public int mCount;
        public Map<String, PowerStateElement> mVoters = new ArrayMap<String, PowerStateElement>();

        public void putVoter(String name, long timeMs, int count) {
            PowerStateElement e = this.mVoters.get(name);
            if (e == null) {
                this.mVoters.put(name, new PowerStateElement(timeMs, count));
            } else {
                e.mTimeMs = timeMs;
                e.mCount = count;
            }
        }
    }

    public static class PowerStateElement {
        public long mTimeMs;
        public int mCount;

        private PowerStateElement(long timeMs, int count) {
            this.mTimeMs = timeMs;
            this.mCount = count;
        }
    }
}

