/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.graphics.Rect;

public class DockedDividerUtils {
    public static void calculateBoundsForPosition(int position, int dockSide, Rect outRect, int displayWidth, int displayHeight, int dividerSize) {
        outRect.set(0, 0, displayWidth, displayHeight);
        switch (dockSide) {
            case 1: {
                outRect.right = position;
                break;
            }
            case 2: {
                outRect.bottom = position;
                break;
            }
            case 3: {
                outRect.left = position + dividerSize;
                break;
            }
            case 4: {
                outRect.top = position + dividerSize;
            }
        }
        DockedDividerUtils.sanitizeStackBounds(outRect, dockSide == 1 || dockSide == 2);
    }

    public static void sanitizeStackBounds(Rect bounds, boolean topLeft) {
        if (topLeft) {
            if (bounds.left >= bounds.right) {
                bounds.left = bounds.right - 1;
            }
            if (bounds.top >= bounds.bottom) {
                bounds.top = bounds.bottom - 1;
            }
        } else {
            if (bounds.right <= bounds.left) {
                bounds.right = bounds.left + 1;
            }
            if (bounds.bottom <= bounds.top) {
                bounds.bottom = bounds.top + 1;
            }
        }
    }

    public static int calculatePositionForBounds(Rect bounds, int dockSide, int dividerSize) {
        switch (dockSide) {
            case 1: {
                return bounds.right;
            }
            case 2: {
                return bounds.bottom;
            }
            case 3: {
                return bounds.left - dividerSize;
            }
            case 4: {
                return bounds.top - dividerSize;
            }
        }
        return 0;
    }

    public static int calculateMiddlePosition(boolean isHorizontalDivision, Rect insets, int displayWidth, int displayHeight, int dividerSize) {
        int start = isHorizontalDivision ? insets.top : insets.left;
        int end = isHorizontalDivision ? displayHeight - insets.bottom : displayWidth - insets.right;
        return start + (end - start) / 2 - dividerSize / 2;
    }

    public static int getDockSideFromCreatedMode(boolean dockOnTopOrLeft, boolean isHorizontalDivision) {
        if (dockOnTopOrLeft) {
            if (isHorizontalDivision) {
                return 2;
            }
            return 1;
        }
        if (isHorizontalDivision) {
            return 4;
        }
        return 3;
    }

    public static int invertDockSide(int dockSide) {
        switch (dockSide) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return -1;
    }
}

