/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.telephony.Phone;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CarrierSignalAgent
extends Handler {
    private static final String LOG_TAG = CarrierSignalAgent.class.getSimpleName();
    private static final boolean DBG = true;
    private static final boolean VDBG = Rlog.isLoggable(LOG_TAG, 2);
    private static final boolean WAKE = true;
    private static final boolean NO_WAKE = false;
    private static final String COMPONENT_NAME_DELIMITER = "\\s*:\\s*";
    private static final String CARRIER_SIGNAL_DELIMITER = "\\s*,\\s*";
    private final Phone mPhone;
    private boolean mDefaultNetworkAvail;
    private Map<String, Set<ComponentName>> mCachedWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
    private Map<String, Set<ComponentName>> mCachedNoWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
    private static final int EVENT_REGISTER_DEFAULT_NETWORK_AVAIL = 0;
    private final Set<String> mCarrierSignalList = new HashSet<String>(Arrays.asList("com.android.internal.telephony.CARRIER_SIGNAL_PCO_VALUE", "com.android.internal.telephony.CARRIER_SIGNAL_REDIRECTED", "com.android.internal.telephony.CARRIER_SIGNAL_REQUEST_NETWORK_FAILED", "com.android.internal.telephony.CARRIER_SIGNAL_RESET", "com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE"));
    private final LocalLog mErrorLocalLog = new LocalLog(20);
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            CarrierSignalAgent.this.log("CarrierSignalAgent receiver action: " + action);
            if (action.equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                CarrierSignalAgent.this.loadCarrierConfig();
            }
        }
    };
    private ConnectivityManager.NetworkCallback mNetworkCallback;

    public CarrierSignalAgent(Phone phone) {
        this.mPhone = phone;
        this.loadCarrierConfig();
        this.mPhone.getContext().registerReceiver(this.mReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        this.mPhone.getCarrierActionAgent().registerForCarrierAction(3, this, 0, null, false);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.e(LOG_TAG, "Register default network exception: " + ar.exception);
                    return;
                }
                ConnectivityManager connectivityMgr = ConnectivityManager.from(this.mPhone.getContext());
                if (((Boolean)ar.result).booleanValue()) {
                    this.mNetworkCallback = new ConnectivityManager.NetworkCallback(){

                        @Override
                        public void onAvailable(Network network) {
                            if (!CarrierSignalAgent.this.mDefaultNetworkAvail) {
                                CarrierSignalAgent.this.log("Default network available: " + network);
                                Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE");
                                intent.putExtra("defaultNetworkAvailable", true);
                                CarrierSignalAgent.this.notifyCarrierSignalReceivers(intent);
                                CarrierSignalAgent.this.mDefaultNetworkAvail = true;
                            }
                        }

                        @Override
                        public void onLost(Network network) {
                            CarrierSignalAgent.this.log("Default network lost: " + network);
                            Intent intent = new Intent("com.android.internal.telephony.CARRIER_SIGNAL_DEFAULT_NETWORK_AVAILABLE");
                            intent.putExtra("defaultNetworkAvailable", false);
                            CarrierSignalAgent.this.notifyCarrierSignalReceivers(intent);
                            CarrierSignalAgent.this.mDefaultNetworkAvail = false;
                        }
                    };
                    connectivityMgr.registerDefaultNetworkCallback(this.mNetworkCallback, this.mPhone);
                    this.log("Register default network");
                    break;
                }
                if (this.mNetworkCallback == null) break;
                connectivityMgr.unregisterNetworkCallback(this.mNetworkCallback);
                this.mNetworkCallback = null;
                this.mDefaultNetworkAvail = false;
                this.log("unregister default network");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCarrierConfig() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        PersistableBundle b = null;
        if (configManager != null) {
            b = configManager.getConfig();
        }
        if (b != null) {
            Map<String, Set<ComponentName>> config;
            Map<String, Set<ComponentName>> map = this.mCachedWakeSignalConfigs;
            synchronized (map) {
                this.log("Loading carrier config: carrier_app_wake_signal_config");
                config = this.parseAndCache(b.getStringArray("carrier_app_wake_signal_config"));
                if (!this.mCachedWakeSignalConfigs.isEmpty() && !config.equals(this.mCachedWakeSignalConfigs)) {
                    if (VDBG) {
                        this.log("carrier config changed, reset receivers from old config");
                    }
                    this.mPhone.getCarrierActionAgent().sendEmptyMessage(2);
                }
                this.mCachedWakeSignalConfigs = config;
            }
            map = this.mCachedNoWakeSignalConfigs;
            synchronized (map) {
                this.log("Loading carrier config: carrier_app_no_wake_signal_config");
                config = this.parseAndCache(b.getStringArray("carrier_app_no_wake_signal_config"));
                if (!this.mCachedNoWakeSignalConfigs.isEmpty() && !config.equals(this.mCachedNoWakeSignalConfigs)) {
                    if (VDBG) {
                        this.log("carrier config changed, reset receivers from old config");
                    }
                    this.mPhone.getCarrierActionAgent().sendEmptyMessage(2);
                }
                this.mCachedNoWakeSignalConfigs = config;
            }
        }
    }

    private Map<String, Set<ComponentName>> parseAndCache(String[] configs) {
        HashMap<String, Set<ComponentName>> newCachedWakeSignalConfigs = new HashMap<String, Set<ComponentName>>();
        if (!ArrayUtils.isEmpty(configs)) {
            for (String config : configs) {
                if (TextUtils.isEmpty(config)) continue;
                String[] splitStr = config.trim().split(COMPONENT_NAME_DELIMITER, 2);
                if (splitStr.length == 2) {
                    String[] signals;
                    ComponentName componentName = ComponentName.unflattenFromString(splitStr[0]);
                    if (componentName == null) {
                        this.loge("Invalid component name: " + splitStr[0]);
                        continue;
                    }
                    for (String s : signals = splitStr[1].split(CARRIER_SIGNAL_DELIMITER)) {
                        if (!this.mCarrierSignalList.contains(s)) {
                            this.loge("Invalid signal name: " + s);
                            continue;
                        }
                        HashSet<ComponentName> componentList = (HashSet<ComponentName>)newCachedWakeSignalConfigs.get(s);
                        if (componentList == null) {
                            componentList = new HashSet<ComponentName>();
                            newCachedWakeSignalConfigs.put(s, componentList);
                        }
                        componentList.add(componentName);
                        if (!VDBG) continue;
                        this.logv("Add config {signal: " + s + " componentName: " + componentName + "}");
                    }
                    continue;
                }
                this.loge("invalid config format: " + config);
            }
        }
        return newCachedWakeSignalConfigs;
    }

    public boolean hasRegisteredReceivers(String action) {
        return this.mCachedWakeSignalConfigs.containsKey(action) || this.mCachedNoWakeSignalConfigs.containsKey(action);
    }

    private void broadcast(Intent intent, Set<ComponentName> receivers, boolean wakeup) {
        PackageManager packageManager = this.mPhone.getContext().getPackageManager();
        for (ComponentName name : receivers) {
            Intent signal = new Intent(intent);
            signal.setComponent(name);
            if (wakeup && packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Carrier signal receivers are configured but unavailable: " + signal.getComponent());
                return;
            }
            if (!wakeup && !packageManager.queryBroadcastReceivers(signal, 65536).isEmpty()) {
                this.loge("Runtime signals shouldn't be configured in Manifest: " + signal.getComponent());
                return;
            }
            signal.putExtra("subscription", this.mPhone.getSubId());
            signal.addFlags(0x10000000);
            if (!wakeup) {
                signal.setFlags(16);
            }
            try {
                this.mPhone.getContext().sendBroadcast(signal);
                this.log("Sending signal " + signal.getAction() + (signal.getComponent() != null ? " to the carrier signal receiver: " + signal.getComponent() : ""));
            }
            catch (ActivityNotFoundException e) {
                this.loge("Send broadcast failed: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCarrierSignalReceivers(Intent intent) {
        Set<ComponentName> receiverSet;
        Map<String, Set<ComponentName>> map = this.mCachedWakeSignalConfigs;
        synchronized (map) {
            receiverSet = this.mCachedWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverSet)) {
                this.broadcast(intent, receiverSet, true);
            }
        }
        map = this.mCachedNoWakeSignalConfigs;
        synchronized (map) {
            receiverSet = this.mCachedNoWakeSignalConfigs.get(intent.getAction());
            if (!ArrayUtils.isEmpty(receiverSet)) {
                this.broadcast(intent, receiverSet, false);
            }
        }
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void loge(String s) {
        this.mErrorLocalLog.log(s);
        Rlog.e(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    private void logv(String s) {
        Rlog.v(LOG_TAG, "[" + this.mPhone.getPhoneId() + "]" + s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        pw.println("mCachedWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, Set<ComponentName>> entry : this.mCachedWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("mCachedNoWakeSignalConfigs:");
        ipw.increaseIndent();
        for (Map.Entry<String, Set<ComponentName>> entry : this.mCachedNoWakeSignalConfigs.entrySet()) {
            pw.println("signal: " + entry.getKey() + " componentName list: " + entry.getValue());
        }
        ipw.decreaseIndent();
        pw.println("mDefaultNetworkAvail: " + this.mDefaultNetworkAvail);
        pw.println("error log:");
        ipw.increaseIndent();
        this.mErrorLocalLog.dump(fd, pw, args);
        ipw.decreaseIndent();
    }
}

