/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.telephony.Rlog;
import com.android.internal.telephony.HbpcdLookup;

public final class HbpcdUtils {
    private static final String LOG_TAG = "HbpcdUtils";
    private static final boolean DBG = false;
    private ContentResolver resolver = null;

    public HbpcdUtils(Context context) {
        this.resolver = context.getContentResolver();
    }

    public int getMcc(int sid, int tz, int DSTflag, boolean isNitzTimeZone) {
        String[] projection5;
        Cursor c5;
        String[] projection3;
        Cursor c3;
        int tmpMcc = 0;
        String[] projection2 = new String[]{"MCC"};
        Cursor c2 = this.resolver.query(HbpcdLookup.ArbitraryMccSidMatch.CONTENT_URI, projection2, "SID=" + sid, null, null);
        if (c2 != null) {
            int c2Counter = c2.getCount();
            if (c2Counter == 1) {
                c2.moveToFirst();
                tmpMcc = c2.getInt(0);
                c2.close();
                return tmpMcc;
            }
            c2.close();
        }
        if ((c3 = this.resolver.query(HbpcdLookup.MccSidConflicts.CONTENT_URI, projection3 = new String[]{"MCC"}, "SID_Conflict=" + sid + " and (((" + "GMT_Offset_Low" + "<=" + tz + ") and (" + tz + "<=" + "GMT_Offset_High" + ") and (0=" + DSTflag + ")) or ((" + "GMT_DST_Low" + "<=" + tz + ") and (" + tz + "<=" + "GMT_DST_High" + ") and (1=" + DSTflag + ")))", null, null)) != null) {
            int c3Counter = c3.getCount();
            if (c3Counter > 0) {
                if (c3Counter > 1) {
                    Rlog.w(LOG_TAG, "something wrong, get more results for 1 conflict SID: " + c3);
                }
                c3.moveToFirst();
                tmpMcc = c3.getInt(0);
                if (!isNitzTimeZone) {
                    tmpMcc = 0;
                }
                c3.close();
                return tmpMcc;
            }
            c3.close();
        }
        if ((c5 = this.resolver.query(HbpcdLookup.MccSidRange.CONTENT_URI, projection5 = new String[]{"MCC"}, "SID_Range_Low<=" + sid + " and " + "SID_Range_High" + ">=" + sid, null, null)) != null) {
            if (c5.getCount() > 0) {
                c5.moveToFirst();
                tmpMcc = c5.getInt(0);
                c5.close();
                return tmpMcc;
            }
            c5.close();
        }
        return tmpMcc;
    }

    public String getIddByMcc(int mcc) {
        String idd = "";
        Cursor c = null;
        String[] projection = new String[]{"IDD"};
        Cursor cur = this.resolver.query(HbpcdLookup.MccIdd.CONTENT_URI, projection, "MCC=" + mcc, null, null);
        if (cur != null) {
            if (cur.getCount() > 0) {
                cur.moveToFirst();
                idd = cur.getString(0);
            }
            cur.close();
        }
        if (c != null) {
            c.close();
        }
        return idd;
    }
}

