/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IntentBroadcaster {
    private static final String TAG = "IntentBroadcaster";
    private Map<Integer, Intent> mRebroadcastIntents = new HashMap<Integer, Intent>();
    private static IntentBroadcaster sIntentBroadcaster;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.USER_UNLOCKED")) {
                Map map = IntentBroadcaster.this.mRebroadcastIntents;
                synchronized (map) {
                    Iterator iterator = IntentBroadcaster.this.mRebroadcastIntents.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry pair = iterator.next();
                        Intent i = (Intent)pair.getValue();
                        i.putExtra("rebroadcastOnUnlock", true);
                        iterator.remove();
                        IntentBroadcaster.this.logd("Rebroadcasting intent " + i.getAction() + " " + i.getStringExtra("ss") + " for slotId " + pair.getKey());
                        ActivityManager.broadcastStickyIntent(i, -1);
                    }
                }
            }
        }
    };

    private IntentBroadcaster(Context context) {
        context.registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.USER_UNLOCKED"));
    }

    public static IntentBroadcaster getInstance(Context context) {
        if (sIntentBroadcaster == null) {
            sIntentBroadcaster = new IntentBroadcaster(context);
        }
        return sIntentBroadcaster;
    }

    public static IntentBroadcaster getInstance() {
        return sIntentBroadcaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastStickyIntent(Intent intent, int slotId) {
        this.logd("Broadcasting and adding intent for rebroadcast: " + intent.getAction() + " " + intent.getStringExtra("ss") + " for slotId " + slotId);
        Map<Integer, Intent> map = this.mRebroadcastIntents;
        synchronized (map) {
            ActivityManager.broadcastStickyIntent(intent, -1);
            this.mRebroadcastIntents.put(slotId, intent);
        }
    }

    private void logd(String s) {
        Log.d(TAG, s);
    }
}

