/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.res.Resources;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.HardwareConfig;
import java.util.ArrayList;
import java.util.List;

public class TelephonyDevController
extends Handler {
    private static final String LOG_TAG = "TDC";
    private static final boolean DBG = true;
    private static final Object mLock = new Object();
    private static final int EVENT_HARDWARE_CONFIG_CHANGED = 1;
    private static TelephonyDevController sTelephonyDevController;
    private static ArrayList<HardwareConfig> mModems;
    private static ArrayList<HardwareConfig> mSims;
    private static Message sRilHardwareConfig;

    private static void logd(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelephonyDevController create() {
        Object object = mLock;
        synchronized (object) {
            if (sTelephonyDevController != null) {
                throw new RuntimeException("TelephonyDevController already created!?!");
            }
            sTelephonyDevController = new TelephonyDevController();
            return sTelephonyDevController;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TelephonyDevController getInstance() {
        Object object = mLock;
        synchronized (object) {
            if (sTelephonyDevController == null) {
                throw new RuntimeException("TelephonyDevController not yet created!?!");
            }
            return sTelephonyDevController;
        }
    }

    private void initFromResource() {
        Resources resource = Resources.getSystem();
        String[] hwStrings = resource.getStringArray(17236029);
        if (hwStrings != null) {
            for (String hwString : hwStrings) {
                HardwareConfig hw = new HardwareConfig(hwString);
                if (hw == null) continue;
                if (hw.type == 0) {
                    TelephonyDevController.updateOrInsert(hw, mModems);
                    continue;
                }
                if (hw.type != 1) continue;
                TelephonyDevController.updateOrInsert(hw, mSims);
            }
        }
    }

    private TelephonyDevController() {
        this.initFromResource();
        mModems.trimToSize();
        mSims.trimToSize();
    }

    public static void registerRIL(CommandsInterface cmdsIf) {
        cmdsIf.getHardwareConfig(sRilHardwareConfig);
        if (sRilHardwareConfig != null) {
            AsyncResult ar = (AsyncResult)TelephonyDevController.sRilHardwareConfig.obj;
            if (ar.exception == null) {
                TelephonyDevController.handleGetHardwareConfigChanged(ar);
            }
        }
        cmdsIf.registerForHardwareConfigChanged(sTelephonyDevController, 1, null);
    }

    public static void unregisterRIL(CommandsInterface cmdsIf) {
        cmdsIf.unregisterForHardwareConfigChanged(sTelephonyDevController);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                TelephonyDevController.logd("handleMessage: received EVENT_HARDWARE_CONFIG_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                TelephonyDevController.handleGetHardwareConfigChanged(ar);
                break;
            }
            default: {
                TelephonyDevController.loge("handleMessage: Unknown Event " + msg.what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateOrInsert(HardwareConfig hw, ArrayList<HardwareConfig> list) {
        Object object = mLock;
        synchronized (object) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                HardwareConfig item = list.get(i);
                if (item.uuid.compareTo(hw.uuid) != 0) continue;
                TelephonyDevController.logd("updateOrInsert: removing: " + item);
                list.remove(i);
            }
            TelephonyDevController.logd("updateOrInsert: inserting: " + hw);
            list.add(hw);
        }
    }

    private static void handleGetHardwareConfigChanged(AsyncResult ar) {
        if (ar.exception == null && ar.result != null) {
            List hwcfg = (List)ar.result;
            for (int i = 0; i < hwcfg.size(); ++i) {
                HardwareConfig hw = null;
                hw = (HardwareConfig)hwcfg.get(i);
                if (hw == null) continue;
                if (hw.type == 0) {
                    TelephonyDevController.updateOrInsert(hw, mModems);
                    continue;
                }
                if (hw.type != 1) continue;
                TelephonyDevController.updateOrInsert(hw, mSims);
            }
        } else {
            TelephonyDevController.loge("handleGetHardwareConfigChanged - returned an error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getModemCount() {
        Object object = mLock;
        synchronized (object) {
            int count = mModems.size();
            TelephonyDevController.logd("getModemCount: " + count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareConfig getModem(int index) {
        Object object = mLock;
        synchronized (object) {
            if (mModems.isEmpty()) {
                TelephonyDevController.loge("getModem: no registered modem device?!?");
                return null;
            }
            if (index > TelephonyDevController.getModemCount()) {
                TelephonyDevController.loge("getModem: out-of-bounds access for modem device " + index + " max: " + TelephonyDevController.getModemCount());
                return null;
            }
            TelephonyDevController.logd("getModem: " + index);
            return mModems.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSimCount() {
        Object object = mLock;
        synchronized (object) {
            int count = mSims.size();
            TelephonyDevController.logd("getSimCount: " + count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareConfig getSim(int index) {
        Object object = mLock;
        synchronized (object) {
            if (mSims.isEmpty()) {
                TelephonyDevController.loge("getSim: no registered sim device?!?");
                return null;
            }
            if (index > this.getSimCount()) {
                TelephonyDevController.loge("getSim: out-of-bounds access for sim device " + index + " max: " + this.getSimCount());
                return null;
            }
            TelephonyDevController.logd("getSim: " + index);
            return mSims.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HardwareConfig getModemForSim(int simIndex) {
        Object object = mLock;
        synchronized (object) {
            if (mModems.isEmpty() || mSims.isEmpty()) {
                TelephonyDevController.loge("getModemForSim: no registered modem/sim device?!?");
                return null;
            }
            if (simIndex > this.getSimCount()) {
                TelephonyDevController.loge("getModemForSim: out-of-bounds access for sim device " + simIndex + " max: " + this.getSimCount());
                return null;
            }
            TelephonyDevController.logd("getModemForSim " + simIndex);
            HardwareConfig sim = this.getSim(simIndex);
            for (HardwareConfig modem : mModems) {
                if (!modem.uuid.equals(sim.modemUuid)) continue;
                return modem;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HardwareConfig> getAllSimsForModem(int modemIndex) {
        Object object = mLock;
        synchronized (object) {
            if (mSims.isEmpty()) {
                TelephonyDevController.loge("getAllSimsForModem: no registered sim device?!?");
                return null;
            }
            if (modemIndex > TelephonyDevController.getModemCount()) {
                TelephonyDevController.loge("getAllSimsForModem: out-of-bounds access for modem device " + modemIndex + " max: " + TelephonyDevController.getModemCount());
                return null;
            }
            TelephonyDevController.logd("getAllSimsForModem " + modemIndex);
            ArrayList<HardwareConfig> result = new ArrayList<HardwareConfig>();
            HardwareConfig modem = this.getModem(modemIndex);
            for (HardwareConfig sim : mSims) {
                if (!sim.modemUuid.equals(modem.uuid)) continue;
                result.add(sim);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HardwareConfig> getAllModems() {
        Object object = mLock;
        synchronized (object) {
            ArrayList<HardwareConfig> modems = new ArrayList<HardwareConfig>();
            if (mModems.isEmpty()) {
                TelephonyDevController.logd("getAllModems: empty list.");
            } else {
                for (HardwareConfig modem : mModems) {
                    modems.add(modem);
                }
            }
            return modems;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HardwareConfig> getAllSims() {
        Object object = mLock;
        synchronized (object) {
            ArrayList<HardwareConfig> sims = new ArrayList<HardwareConfig>();
            if (mSims.isEmpty()) {
                TelephonyDevController.logd("getAllSims: empty list.");
            } else {
                for (HardwareConfig sim : mSims) {
                    sims.add(sim);
                }
            }
            return sims;
        }
    }

    static {
        mModems = new ArrayList();
        mSims = new ArrayList();
    }
}

