/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkRequest;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseIntArray;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.RetryManager;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ApnContext {
    public final String LOG_TAG;
    private static final String SLOG_TAG = "ApnContext";
    protected static final boolean DBG = false;
    private final Phone mPhone;
    private final String mApnType;
    private DctConstants.State mState;
    public final int priority;
    private ApnSetting mApnSetting;
    DcAsyncChannel mDcAc;
    String mReason;
    PendingIntent mReconnectAlarmIntent;
    AtomicBoolean mDataEnabled;
    private final Object mRefCountLock = new Object();
    private int mRefCount = 0;
    AtomicBoolean mDependencyMet;
    private final DcTracker mDcTracker;
    private boolean mConcurrentVoiceAndDataAllowed;
    private final AtomicInteger mConnectionGeneration = new AtomicInteger(0);
    private final RetryManager mRetryManager;
    private final ArrayList<LocalLog> mLocalLogs = new ArrayList();
    private final ArrayList<NetworkRequest> mNetworkRequests = new ArrayList();
    private final ArrayDeque<LocalLog> mHistoryLogs = new ArrayDeque();
    private static final int MAX_HISTORY_LOG_COUNT = 4;
    private final SparseIntArray mRetriesLeftPerErrorCode = new SparseIntArray();

    public ApnContext(Phone phone, String apnType, String logTag, NetworkConfig config, DcTracker tracker) {
        this.mPhone = phone;
        this.mApnType = apnType;
        this.mState = DctConstants.State.IDLE;
        this.setReason("dataEnabled");
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(config.dependencyMet);
        this.priority = config.priority;
        this.LOG_TAG = logTag;
        this.mDcTracker = tracker;
        this.mRetryManager = new RetryManager(phone, apnType);
    }

    public String getApnType() {
        return this.mApnType;
    }

    public synchronized DcAsyncChannel getDcAc() {
        return this.mDcAc;
    }

    public synchronized void setDataConnectionAc(DcAsyncChannel dcac) {
        this.mDcAc = dcac;
    }

    public synchronized void releaseDataConnection(String reason) {
        if (this.mDcAc != null) {
            this.mDcAc.tearDown(this, reason, null);
            this.mDcAc = null;
        }
        this.setState(DctConstants.State.IDLE);
    }

    public synchronized PendingIntent getReconnectIntent() {
        return this.mReconnectAlarmIntent;
    }

    public synchronized void setReconnectIntent(PendingIntent intent) {
        this.mReconnectAlarmIntent = intent;
    }

    public synchronized ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        this.mApnSetting = apnSetting;
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mRetryManager.setWaitingApns(waitingApns);
    }

    public ApnSetting getNextApnSetting() {
        return this.mRetryManager.getNextApnSetting();
    }

    public void setModemSuggestedDelay(long delay) {
        this.mRetryManager.setModemSuggestedDelay(delay);
    }

    public long getDelayForNextApn(boolean failFastEnabled) {
        return this.mRetryManager.getDelayForNextApn(failFastEnabled || this.isFastRetryReason());
    }

    public void markApnPermanentFailed(ApnSetting apn) {
        this.mRetryManager.markApnPermanentFailed(apn);
    }

    public ArrayList<ApnSetting> getWaitingApns() {
        return this.mRetryManager.getWaitingApns();
    }

    public synchronized void setConcurrentVoiceAndDataAllowed(boolean allowed) {
        this.mConcurrentVoiceAndDataAllowed = allowed;
    }

    public synchronized boolean isConcurrentVoiceAndDataAllowed() {
        return this.mConcurrentVoiceAndDataAllowed;
    }

    public synchronized void setState(DctConstants.State s) {
        this.mState = s;
        if (this.mState == DctConstants.State.FAILED && this.mRetryManager.getWaitingApns() != null) {
            this.mRetryManager.getWaitingApns().clear();
        }
    }

    public synchronized DctConstants.State getState() {
        return this.mState;
    }

    public boolean isDisconnected() {
        DctConstants.State currentState = this.getState();
        return currentState == DctConstants.State.IDLE || currentState == DctConstants.State.FAILED;
    }

    public synchronized void setReason(String reason) {
        this.mReason = reason;
    }

    public synchronized String getReason() {
        return this.mReason;
    }

    public boolean isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    public boolean isConnectable() {
        return this.isReady() && (this.mState == DctConstants.State.IDLE || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING || this.mState == DctConstants.State.FAILED);
    }

    private boolean isFastRetryReason() {
        return "nwTypeChanged".equals(this.mReason) || "apnChanged".equals(this.mReason);
    }

    public boolean isConnectedOrConnecting() {
        return this.isReady() && (this.mState == DctConstants.State.CONNECTED || this.mState == DctConstants.State.CONNECTING || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING);
    }

    public void setEnabled(boolean enabled) {
        this.mDataEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.mDataEnabled.get();
    }

    public void setDependencyMet(boolean met) {
        this.mDependencyMet.set(met);
    }

    public boolean getDependencyMet() {
        return this.mDependencyMet.get();
    }

    public boolean isProvisioningApn() {
        String provisioningApn = this.mPhone.getContext().getResources().getString(17040259);
        if (!TextUtils.isEmpty(provisioningApn) && this.mApnSetting != null && this.mApnSetting.apn != null) {
            return this.mApnSetting.apn.equals(provisioningApn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLog(String str) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (LocalLog l : this.mLocalLogs) {
                l.log(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNetwork(NetworkRequest networkRequest, LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (this.mLocalLogs.contains(log) || this.mNetworkRequests.contains(networkRequest)) {
                log.log("ApnContext.requestNetwork has duplicate add - " + this.mNetworkRequests.size());
            } else {
                this.mLocalLogs.add(log);
                this.mNetworkRequests.add(networkRequest);
                this.mDcTracker.setEnabled(ApnContext.apnIdForApnName(this.mApnType), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNetwork(NetworkRequest networkRequest, LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (!this.mLocalLogs.contains(log)) {
                log.log("ApnContext.releaseNetwork can't find this log");
            } else {
                this.mLocalLogs.remove(log);
            }
            if (!this.mNetworkRequests.contains(networkRequest)) {
                log.log("ApnContext.releaseNetwork can't find this request (" + networkRequest + ")");
            } else {
                this.mNetworkRequests.remove(networkRequest);
                log.log("ApnContext.releaseNetwork left with " + this.mNetworkRequests.size() + " requests.");
                if (this.mNetworkRequests.size() == 0) {
                    this.mDcTracker.setEnabled(ApnContext.apnIdForApnName(this.mApnType), false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NetworkRequest> getNetworkRequests() {
        Object object = this.mRefCountLock;
        synchronized (object) {
            return new ArrayList<NetworkRequest>(this.mNetworkRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNoRestrictedRequests(boolean excludeDun) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (NetworkRequest nr : this.mNetworkRequests) {
                if (excludeDun && nr.networkCapabilities.hasCapability(2) || nr.networkCapabilities.hasCapability(13)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetErrorCodeRetries() {
        this.requestLog("ApnContext.resetErrorCodeRetries");
        String[] config = this.mPhone.getContext().getResources().getStringArray(0x1070017);
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            this.mRetriesLeftPerErrorCode.clear();
            for (String c : config) {
                String[] errorValue = c.split(",");
                if (errorValue != null && errorValue.length == 2) {
                    int count = 0;
                    int errorCode = 0;
                    try {
                        errorCode = Integer.parseInt(errorValue[0]);
                        count = Integer.parseInt(errorValue[1]);
                    }
                    catch (NumberFormatException e) {
                        this.log("Exception parsing config_retries_per_error_code: " + e);
                        continue;
                    }
                    if (count <= 0 || errorCode <= 0) continue;
                    this.mRetriesLeftPerErrorCode.put(errorCode, count);
                    continue;
                }
                this.log("Exception parsing config_retries_per_error_code: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartOnError(int errorCode) {
        boolean result = false;
        int retriesLeft = 0;
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            retriesLeft = this.mRetriesLeftPerErrorCode.get(errorCode);
            switch (retriesLeft) {
                case 0: {
                    break;
                }
                case 1: {
                    this.resetErrorCodeRetries();
                    result = true;
                    break;
                }
                default: {
                    this.mRetriesLeftPerErrorCode.put(errorCode, retriesLeft - 1);
                    result = false;
                }
            }
        }
        String str = "ApnContext.restartOnError(" + errorCode + ") found " + retriesLeft + " and returned " + result;
        this.requestLog(str);
        return result;
    }

    public int incAndGetConnectionGeneration() {
        return this.mConnectionGeneration.incrementAndGet();
    }

    public int getConnectionGeneration() {
        return this.mConnectionGeneration.get();
    }

    long getRetryAfterDisconnectDelay() {
        return this.mRetryManager.getRetryAfterDisconnectDelay();
    }

    public static int apnIdForType(int networkType) {
        switch (networkType) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 10: {
                return 6;
            }
            case 11: {
                return 5;
            }
            case 12: {
                return 7;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 9;
            }
        }
        return -1;
    }

    public static int apnIdForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return -1;
        }
        int apnId = -1;
        boolean error = false;
        if (nc.hasCapability(12)) {
            apnId = 0;
        }
        if (nc.hasCapability(0)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 1;
        }
        if (nc.hasCapability(1)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 2;
        }
        if (nc.hasCapability(2)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 3;
        }
        if (nc.hasCapability(3)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 6;
        }
        if (nc.hasCapability(4)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 5;
        }
        if (nc.hasCapability(5)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 7;
        }
        if (nc.hasCapability(7)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 8;
        }
        if (nc.hasCapability(8)) {
            if (apnId != -1) {
                error = true;
            }
            Rlog.d(SLOG_TAG, "RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (apnId != -1) {
                error = true;
            }
            Rlog.d(SLOG_TAG, "XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (apnId != -1) {
                error = true;
            }
            apnId = 9;
        }
        if (error) {
            Rlog.d(SLOG_TAG, "Multiple apn types specified in request - result is unspecified!");
        }
        if (apnId == -1) {
            Rlog.d(SLOG_TAG, "Unsupported NetworkRequest in Telephony: nr=" + nr);
        }
        return apnId;
    }

    public static int apnIdForApnName(String type) {
        switch (type) {
            case "default": {
                return 0;
            }
            case "mms": {
                return 1;
            }
            case "supl": {
                return 2;
            }
            case "dun": {
                return 3;
            }
            case "hipri": {
                return 4;
            }
            case "ims": {
                return 5;
            }
            case "fota": {
                return 6;
            }
            case "cbs": {
                return 7;
            }
            case "ia": {
                return 8;
            }
            case "emergency": {
                return 9;
            }
        }
        return -1;
    }

    private static String apnNameForApnId(int id2) {
        switch (id2) {
            case 0: {
                return "default";
            }
            case 1: {
                return "mms";
            }
            case 2: {
                return "supl";
            }
            case 3: {
                return "dun";
            }
            case 4: {
                return "hipri";
            }
            case 5: {
                return "ims";
            }
            case 6: {
                return "fota";
            }
            case 7: {
                return "cbs";
            }
            case 8: {
                return "ia";
            }
            case 9: {
                return "emergency";
            }
        }
        Rlog.d(SLOG_TAG, "Unknown id (" + id2 + ") in apnIdToType");
        return "default";
    }

    public synchronized String toString() {
        return "{mApnType=" + this.mApnType + " mState=" + (Object)((Object)this.getState()) + " mWaitingApns={" + this.mRetryManager.getWaitingApns() + "} mApnSetting={" + this.mApnSetting + "} mReason=" + this.mReason + " mDataEnabled=" + this.mDataEnabled + " mDependencyMet=" + this.mDependencyMet + "}";
    }

    private void log(String s) {
        Rlog.d(this.LOG_TAG, "[ApnContext:" + this.mApnType + "] " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        Object object = this.mRefCountLock;
        synchronized (object) {
            pw.println(this.toString());
            if (this.mNetworkRequests.size() > 0) {
                pw.println("NetworkRequests:");
                pw.increaseIndent();
                for (NetworkRequest nr : this.mNetworkRequests) {
                    pw.println(nr);
                }
                pw.decreaseIndent();
            }
            pw.increaseIndent();
            for (LocalLog l : this.mLocalLogs) {
                l.dump(fd, pw, args);
            }
            if (this.mHistoryLogs.size() > 0) {
                pw.println("Historical Logs:");
            }
            for (LocalLog l : this.mHistoryLogs) {
                l.dump(fd, pw, args);
            }
            pw.decreaseIndent();
            pw.println(this.mRetryManager);
        }
    }
}

