/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.SystemProperties;
import android.telephony.Rlog;
import android.text.TextUtils;
import com.android.internal.telephony.dataconnection.DcFailCause;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DataCallResponse {
    private final boolean DBG = true;
    private final String LOG_TAG = "DataCallResponse";
    public final int status;
    public final int suggestedRetryTime;
    public final int cid;
    public final int active;
    public final String type;
    public final String ifname;
    public final String[] addresses;
    public final String[] dnses;
    public String[] gateways;
    public final String[] pcscf;
    public final int mtu;

    public DataCallResponse(int status, int suggestedRetryTime, int cid, int active, String type, String ifname, String addresses, String dnses, String gateways, String pcscf, int mtu) {
        this.status = status;
        this.suggestedRetryTime = suggestedRetryTime;
        this.cid = cid;
        this.active = active;
        this.type = type == null ? "" : type;
        String string2 = this.ifname = ifname == null ? "" : ifname;
        if (status == DcFailCause.NONE.getErrorCode() && TextUtils.isEmpty(ifname)) {
            throw new RuntimeException("DataCallResponse, no ifname");
        }
        this.addresses = TextUtils.isEmpty(addresses) ? new String[]{} : addresses.split(" ");
        this.dnses = TextUtils.isEmpty(dnses) ? new String[]{} : dnses.split(" ");
        this.gateways = TextUtils.isEmpty(gateways) ? new String[]{} : gateways.split(" ");
        this.pcscf = TextUtils.isEmpty(pcscf) ? new String[]{} : pcscf.split(" ");
        this.mtu = mtu;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DataCallResponse: {").append(" status=").append(this.status).append(" retry=").append(this.suggestedRetryTime).append(" cid=").append(this.cid).append(" active=").append(this.active).append(" type=").append(this.type).append(" ifname=").append(this.ifname).append(" mtu=").append(this.mtu).append(" addresses=[");
        for (String addr : this.addresses) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.addresses.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("] dnses=[");
        for (String addr : this.dnses) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.dnses.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("] gateways=[");
        for (String addr : this.gateways) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.gateways.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("] pcscf=[");
        for (String addr : this.pcscf) {
            sb.append(addr);
            sb.append(",");
        }
        if (this.pcscf.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]}");
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public SetupResult setLinkProperties(LinkProperties linkProperties, boolean okToUseSystemPropertyDns) {
        SetupResult result;
        if (linkProperties == null) {
            linkProperties = new LinkProperties();
        } else {
            linkProperties.clear();
        }
        if (this.status == DcFailCause.NONE.getErrorCode()) {
            String propertyPrefix = "net." + this.ifname + ".";
            try {
                InetAddress ia;
                int n;
                linkProperties.setInterfaceName(this.ifname);
                if (this.addresses != null && this.addresses.length > 0) {
                    for (String string2 : this.addresses) {
                        LinkAddress la;
                        void ia2;
                        void var7_10;
                        int addrPrefixLen;
                        String string3 = string2.trim();
                        if (string3.isEmpty()) continue;
                        String[] ap = string3.split("/");
                        if (ap.length == 2) {
                            String string4 = ap[0];
                            addrPrefixLen = Integer.parseInt(ap[1]);
                        } else {
                            addrPrefixLen = 0;
                        }
                        try {
                            InetAddress ia22 = NetworkUtils.numericToInetAddress((String)var7_10);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric ip addr=" + (String)var7_10);
                        }
                        if (ia2.isAnyLocalAddress()) continue;
                        if (addrPrefixLen == 0) {
                            addrPrefixLen = ia2 instanceof Inet4Address ? 32 : 128;
                        }
                        Rlog.d("DataCallResponse", "addr/pl=" + (String)var7_10 + "/" + addrPrefixLen);
                        try {
                            la = new LinkAddress((InetAddress)ia2, addrPrefixLen);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Bad parameter for LinkAddress, ia=" + ia2.getHostAddress() + "/" + addrPrefixLen);
                        }
                        linkProperties.addLinkAddress(la);
                    }
                } else {
                    throw new UnknownHostException("no address for ifname=" + this.ifname);
                }
                if (this.dnses != null && this.dnses.length > 0) {
                    String[] stringArray = this.dnses;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String string6 = stringArray[n];
                        string6 = string6.trim();
                        if (string6.isEmpty()) continue;
                        try {
                            ia = NetworkUtils.numericToInetAddress(string6);
                        }
                        catch (IllegalArgumentException e) {
                            throw new UnknownHostException("Non-numeric dns addr=" + string6);
                        }
                        if (ia.isAnyLocalAddress()) continue;
                        linkProperties.addDnsServer(ia);
                    }
                } else if (okToUseSystemPropertyDns) {
                    void var7_18;
                    String[] dnsServers = new String[]{SystemProperties.get(propertyPrefix + "dns1"), SystemProperties.get(propertyPrefix + "dns2")};
                    String[] stringArray = dnsServers;
                    n = stringArray.length;
                    boolean bl = false;
                    while (var7_18 < n) {
                        String dnsAddr = stringArray[var7_18];
                        if (!(dnsAddr = dnsAddr.trim()).isEmpty()) {
                            void ia3;
                            try {
                                InetAddress ia32 = NetworkUtils.numericToInetAddress(dnsAddr);
                            }
                            catch (IllegalArgumentException e) {
                                throw new UnknownHostException("Non-numeric dns addr=" + dnsAddr);
                            }
                            if (!ia3.isAnyLocalAddress()) {
                                linkProperties.addDnsServer((InetAddress)ia3);
                            }
                        }
                        ++var7_18;
                    }
                } else {
                    throw new UnknownHostException("Empty dns response and no system default dns");
                }
                if (this.gateways == null || this.gateways.length == 0) {
                    String sysGateways = SystemProperties.get(propertyPrefix + "gw");
                    this.gateways = sysGateways != null ? sysGateways.split(" ") : new String[0];
                }
                for (String string7 : this.gateways) {
                    String string8 = string7.trim();
                    if (string8.isEmpty()) continue;
                    try {
                        ia = NetworkUtils.numericToInetAddress(string8);
                    }
                    catch (IllegalArgumentException e) {
                        throw new UnknownHostException("Non-numeric gateway addr=" + string8);
                    }
                    linkProperties.addRoute(new RouteInfo(ia));
                }
                linkProperties.setMtu(this.mtu);
                result = SetupResult.SUCCESS;
            }
            catch (UnknownHostException e) {
                Rlog.d("DataCallResponse", "setLinkProperties: UnknownHostException " + e);
                e.printStackTrace();
                result = SetupResult.ERR_UnacceptableParameter;
            }
        } else {
            result = SetupResult.ERR_RilError;
        }
        if (result != SetupResult.SUCCESS) {
            Rlog.d("DataCallResponse", "setLinkProperties: error clearing LinkProperties status=" + this.status + " result=" + (Object)((Object)result));
            linkProperties.clear();
        }
        return result;
    }

    public static enum SetupResult {
        SUCCESS,
        ERR_BadCommand,
        ERR_UnacceptableParameter,
        ERR_GetLastErrorFromRil,
        ERR_Stale,
        ERR_RilError;

        public DcFailCause mFailCause = DcFailCause.fromInt(0);

        public String toString() {
            return this.name() + "  SetupResult.mFailCause=" + (Object)((Object)this.mFailCause);
        }
    }
}

