/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.StringNetworkSpecifier;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionMonitor;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class TelephonyNetworkFactory
extends NetworkFactory {
    public final String LOG_TAG;
    protected static final boolean DBG = true;
    private final PhoneSwitcher mPhoneSwitcher;
    private final SubscriptionController mSubscriptionController;
    private final SubscriptionMonitor mSubscriptionMonitor;
    private final DcTracker mDcTracker;
    private final HashMap<NetworkRequest, LocalLog> mDefaultRequests = new HashMap();
    private final HashMap<NetworkRequest, LocalLog> mSpecificRequests = new HashMap();
    private int mPhoneId;
    private boolean mIsActive;
    private boolean mIsDefault;
    private int mSubscriptionId;
    private static final int TELEPHONY_NETWORK_SCORE = 50;
    private final Handler mInternalHandler;
    private static final int EVENT_ACTIVE_PHONE_SWITCH = 1;
    private static final int EVENT_SUBSCRIPTION_CHANGED = 2;
    private static final int EVENT_DEFAULT_SUBSCRIPTION_CHANGED = 3;
    private static final int EVENT_NETWORK_REQUEST = 4;
    private static final int EVENT_NETWORK_RELEASE = 5;
    private static final int REQUEST_LOG_SIZE = 40;
    private static final boolean REQUEST = true;
    private static final boolean RELEASE = false;

    public TelephonyNetworkFactory(PhoneSwitcher phoneSwitcher, SubscriptionController subscriptionController, SubscriptionMonitor subscriptionMonitor, Looper looper, Context context, int phoneId, DcTracker dcTracker) {
        super(looper, context, "TelephonyNetworkFactory[" + phoneId + "]", null);
        this.mInternalHandler = new InternalHandler(looper);
        this.setCapabilityFilter(this.makeNetworkFilter(subscriptionController, phoneId));
        this.setScoreFilter(50);
        this.mPhoneSwitcher = phoneSwitcher;
        this.mSubscriptionController = subscriptionController;
        this.mSubscriptionMonitor = subscriptionMonitor;
        this.mPhoneId = phoneId;
        this.LOG_TAG = "TelephonyNetworkFactory[" + phoneId + "]";
        this.mDcTracker = dcTracker;
        this.mIsActive = false;
        this.mPhoneSwitcher.registerForActivePhoneSwitch(this.mPhoneId, this.mInternalHandler, 1, null);
        this.mSubscriptionId = -1;
        this.mSubscriptionMonitor.registerForSubscriptionChanged(this.mPhoneId, this.mInternalHandler, 2, null);
        this.mIsDefault = false;
        this.mSubscriptionMonitor.registerForDefaultDataSubscriptionChanged(this.mPhoneId, this.mInternalHandler, 3, null);
        this.register();
    }

    private NetworkCapabilities makeNetworkFilter(SubscriptionController subscriptionController, int phoneId) {
        int subscriptionId = subscriptionController.getSubIdUsingPhoneId(phoneId);
        return this.makeNetworkFilter(subscriptionId);
    }

    private NetworkCapabilities makeNetworkFilter(int subscriptionId) {
        NetworkCapabilities nc = new NetworkCapabilities();
        nc.addTransportType(0);
        nc.addCapability(0);
        nc.addCapability(1);
        nc.addCapability(2);
        nc.addCapability(3);
        nc.addCapability(4);
        nc.addCapability(5);
        nc.addCapability(7);
        nc.addCapability(8);
        nc.addCapability(9);
        nc.addCapability(10);
        nc.addCapability(13);
        nc.addCapability(12);
        nc.setNetworkSpecifier(new StringNetworkSpecifier(String.valueOf(subscriptionId)));
        return nc;
    }

    private void applyRequests(HashMap<NetworkRequest, LocalLog> requestMap, boolean action, String logStr) {
        for (NetworkRequest networkRequest : requestMap.keySet()) {
            LocalLog localLog = requestMap.get(networkRequest);
            localLog.log(logStr);
            if (action) {
                this.mDcTracker.requestNetwork(networkRequest, localLog);
                continue;
            }
            this.mDcTracker.releaseNetwork(networkRequest, localLog);
        }
    }

    private void onActivePhoneSwitch() {
        boolean newIsActive = this.mPhoneSwitcher.isPhoneActive(this.mPhoneId);
        if (this.mIsActive != newIsActive) {
            this.mIsActive = newIsActive;
            String logString = "onActivePhoneSwitch(" + this.mIsActive + ", " + this.mIsDefault + ")";
            this.log(logString);
            if (this.mIsDefault) {
                this.applyRequests(this.mDefaultRequests, this.mIsActive, logString);
            }
            this.applyRequests(this.mSpecificRequests, this.mIsActive, logString);
        }
    }

    private void onSubIdChange() {
        int newSubscriptionId = this.mSubscriptionController.getSubIdUsingPhoneId(this.mPhoneId);
        if (this.mSubscriptionId != newSubscriptionId) {
            this.log("onSubIdChange " + this.mSubscriptionId + "->" + newSubscriptionId);
            this.mSubscriptionId = newSubscriptionId;
            this.setCapabilityFilter(this.makeNetworkFilter(this.mSubscriptionId));
        }
    }

    private void onDefaultChange() {
        boolean newIsDefault;
        int newDefaultSubscriptionId = this.mSubscriptionController.getDefaultDataSubId();
        boolean bl = newIsDefault = newDefaultSubscriptionId == this.mSubscriptionId;
        if (newIsDefault != this.mIsDefault) {
            this.mIsDefault = newIsDefault;
            String logString = "onDefaultChange(" + this.mIsActive + "," + this.mIsDefault + ")";
            this.log(logString);
            if (!this.mIsActive) {
                return;
            }
            this.applyRequests(this.mDefaultRequests, this.mIsDefault, logString);
        }
    }

    @Override
    public void needNetworkFor(NetworkRequest networkRequest, int score) {
        Message msg = this.mInternalHandler.obtainMessage(4);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private void onNeedNetworkFor(Message msg) {
        NetworkRequest networkRequest = (NetworkRequest)msg.obj;
        boolean isApplicable = false;
        LocalLog localLog = null;
        if (networkRequest.networkCapabilities.getNetworkSpecifier() == null) {
            localLog = this.mDefaultRequests.get(networkRequest);
            if (localLog == null) {
                localLog = new LocalLog(40);
                localLog.log("created for " + networkRequest);
                this.mDefaultRequests.put(networkRequest, localLog);
                isApplicable = this.mIsDefault;
            }
        } else {
            localLog = this.mSpecificRequests.get(networkRequest);
            if (localLog == null) {
                localLog = new LocalLog(40);
                this.mSpecificRequests.put(networkRequest, localLog);
                isApplicable = true;
            }
        }
        if (this.mIsActive && isApplicable) {
            String s = "onNeedNetworkFor";
            localLog.log(s);
            this.log(s + " " + networkRequest);
            this.mDcTracker.requestNetwork(networkRequest, localLog);
        } else {
            String s = "not acting - isApp=" + isApplicable + ", isAct=" + this.mIsActive;
            localLog.log(s);
            this.log(s + " " + networkRequest);
        }
    }

    @Override
    public void releaseNetworkFor(NetworkRequest networkRequest) {
        Message msg = this.mInternalHandler.obtainMessage(5);
        msg.obj = networkRequest;
        msg.sendToTarget();
    }

    private void onReleaseNetworkFor(Message msg) {
        NetworkRequest networkRequest = (NetworkRequest)msg.obj;
        LocalLog localLog = null;
        boolean isApplicable = false;
        if (networkRequest.networkCapabilities.getNetworkSpecifier() == null) {
            localLog = this.mDefaultRequests.remove(networkRequest);
            isApplicable = localLog != null && this.mIsDefault;
        } else {
            localLog = this.mSpecificRequests.remove(networkRequest);
            boolean bl = isApplicable = localLog != null;
        }
        if (this.mIsActive && isApplicable) {
            String s = "onReleaseNetworkFor";
            localLog.log(s);
            this.log(s + " " + networkRequest);
            this.mDcTracker.releaseNetwork(networkRequest, localLog);
        } else {
            String s = "not releasing - isApp=" + isApplicable + ", isAct=" + this.mIsActive;
            localLog.log(s);
            this.log(s + " " + networkRequest);
        }
    }

    @Override
    protected void log(String s) {
        Rlog.d(this.LOG_TAG, s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println(this.LOG_TAG + " mSubId=" + this.mSubscriptionId + " mIsActive=" + this.mIsActive + " mIsDefault=" + this.mIsDefault);
        pw.println("Default Requests:");
        pw.increaseIndent();
        for (NetworkRequest nr : this.mDefaultRequests.keySet()) {
            pw.println(nr);
            pw.increaseIndent();
            this.mDefaultRequests.get(nr).dump(fd, pw, args);
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TelephonyNetworkFactory.this.onActivePhoneSwitch();
                    break;
                }
                case 2: {
                    TelephonyNetworkFactory.this.onSubIdChange();
                    break;
                }
                case 3: {
                    TelephonyNetworkFactory.this.onDefaultChange();
                    break;
                }
                case 4: {
                    TelephonyNetworkFactory.this.onNeedNetworkFor(msg);
                    break;
                }
                case 5: {
                    TelephonyNetworkFactory.this.onReleaseNetworkFor(msg);
                }
            }
        }
    }
}

